// Glove pointer device

// Written by Dave Stampe, August 1992

// Copyright 1992 by Dave Stampe and Bernie Roehl.
// May be freely used to write software for release into the public domain;
// all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
// for permission to incorporate any part of this software into their
// products!


#include <stdio.h>
#include <dos.h>
#include <conio.h>

#include "rend386.hpp"
#include "segasupp.hpp"
#include "pointer.hpp"
#include "intmath.h"
#include "userint.hpp"
#include "keyboard.hpp"
#include "demo4.hpp"

#include <string.h>
#include "smooth.hpp"
#include "ini.hpp"
#include "rendgest.hpp"
#include "gestsys.hpp"

// INTERNAL GLOVE SETUP

static PDRIVER *glove_device;

extern int stereo_type; // required for proper int. initialization

#define sub_exit        atexit

static rawGlove * g_driver_ptr[2] = {NULL, NULL};

void gloveptr_quit()
{
	pointer_quit(glove_device);
}

RendGestSet * gestset[2] = {NULL, NULL};
GestureSystem * gestsys[2] = {NULL, NULL};

PDRIVER *gloveptr_init(char *gname, int which)
{
	PDRIVER *p;

	p = pointer_init(P_IS3DG | P_IS6DG, gname, which); // setup glove device
	if (p==NULL) return NULL;

	glove_device = p;

	return p;
}

void gloveptr_setup(PDRIVER * p, long sx, long sy, long sz, long srx, long sry, long srz)
{
	POINTER x;

	init_pointer(&x); // so that defaults are OK
	// use abs. glove motion
	pointer_abscale(p, sx, sy, sz, srx, sry, srz);
	set_mouse_limits(p, screeninfo->xmax, screeninfo->ymax);
	while (!pointer_read(p, &x));
	while (!pointer_read(p, &x)); // save current position
	mouse_read(p, NULL, NULL, NULL);
	return;
}


// GLOVE POINTER DRIVER

pconfig glove_pconfig = {
	5*65536L, 5*65536L, -15*65536L, // position res: mm/tick in <16.16>
	120, 120, 120, -120, -120, -120, // xyz ranges:
	0, -30*65536L, 0,
	0, 0, 0, 120, 11, 120, // some rotation (swing emulation)
	320, 200, // mouse emulation limits (writable)
	P_HASX | P_HASY | P_HASZ | P_HASRY | P_HASSCR |
		P_HASGEST | P_HASFLEX | P_HASKEYS, // databits
	P_CENTER | P_SCREEN, 0xFF, 11, // modes, nullkey, flexnum
	2, 50, 20, // delay, idelay, reads/sec
	P_IS3DG | P_IS3D | P_IS2D, // uses
	"Default Powerglove Driver"
};


#define DEBOUNCE_TIME 2

static fbend[4] = { 127, 90, 40, 0 }; // finger flexions
static tbbend[4] = { 127, 72, 25, 0 };
static ttbend[4] = { 127, 80, 35, 0 };

#include "ds_gest.hpp"
InitFile * gloveIni;

Boolean keyhit_quit()
{
	if (kbhit()) {
		getch();
		return True;
	}
	return False;
}

void setup_gestset(int which)
{
	gestset[which] = new RendGestSet(*gloveIni, which);
}

int perform_gestset(int which)
{
	g_driver_ptr[which]->checkGestures();
//	if (which != 1) {
		(gestset[which])->postCheck();
//	}
	return gestset[which]->findGest();
}

extern void InitEpsilon(InitFile &ini);

pconfig *glove_driver(int op, POINTER *p, int mode, int which)
{
	static char section[] = "1.Smoothing";
	// int type = FP_OFF(p); /* way to get integer arg. */
	int ft, fi, fm, fp;

	switch(op)
	{
	case DRIVER_CMD:
	case DRIVER_RESET:
		break;

	case DRIVER_INIT:
		if (!which) {
			gloveIni = new InitFile("glove.ini");
			InitEpsilon(*gloveIni);
		}

//		init_gestures();
		setup_gestset(which);
		gestsys[which] = new GestureSystem;
		if (gestset[which]) {
			(gestset[which])->turnOn();
			*(gestsys[which]) + gestset[which];
			(gestsys[which])->turnOn();
		}
		section[0] = '1' + char(which);
		if (!strcmp(gloveIni->find(section, "smoothingEnabled", "False"),
		     "True"))
			g_driver_ptr[which] = new smoothGlove(*gloveIni, gestsys[which], keyhit_quit,
				(stereo_type == SWITCHED) ? switch_sega : NULL);
		else
			g_driver_ptr[which] = new rawGlove(*gloveIni, gestsys[which], keyhit_quit,
				(stereo_type == SWITCHED) ? switch_sega : NULL);

		if ((g_driver_ptr[which])->driverStatus() != gloveDriver::EverythingOK) {
			delete g_driver_ptr[which];
			g_driver_ptr[which] = NULL;
		}
		break;

	case DRIVER_READ:       // pointer (2DP) read
		if (mode == P_POINTER)
		{
			if (!(g_driver_ptr[which])) return NULL;
			if (((g_driver_ptr[which])->driverStatus())
			    == gloveDriver::PolledModeWorking)
				(g_driver_ptr[which])->waitForSample();
			else
				if (!(g_driver_ptr[which])->yield())
					return NULL;
			p->x = (long)((g_driver_ptr[which])->getX());
			p->y = (long)((g_driver_ptr[which])->getY());
			p->z = (long)((g_driver_ptr[which])->getZ());
			p->rx = 0L;
			p->ry = ((long) ((g_driver_ptr[which])->getRotation())) << 16;
			p->rz = 0L;
			p->buttons = 0;
			p->keys = (unsigned)(g_driver_ptr[which])->getKeys();

			// finger joint angles
			ft = ((g_driver_ptr[which])->getThumb());
			fi = ((g_driver_ptr[which])->getIndex());
			fm = ((g_driver_ptr[which])->getMiddle());
			fp = ((g_driver_ptr[which])->getRing());

			p->flex[0] = tbbend[ft];
			p->flex[1] = ttbend[ft];
			p->flex[2] = p->flex[3] = fbend[fi];
			p->flex[4] = p->flex[5] = fbend[fm];
			p->flex[6] = p->flex[7] = fbend[fp];
			p->flex[8] = p->flex[9] = fbend[fp];

			p->gesture = G_UNKNOWN;
/**
			p->gesture = (gesture_time[which] > DEBOUNCE_TIME) ?
				gesture_type[which] : G_UNKNOWN;
**/
		}
		else if (mode == P_SCREEN) // mouse read (640x480)
		{
			p->x = scale_16(((long)glove_pconfig.maxsx) << 8, 127, ((long)(g_driver_ptr[which])->getX()));
			p->y = scale_16(((long)glove_pconfig.maxsy) << 8, 127, -((long)(g_driver_ptr[which])->getY()));
			if (p->x < 0) p->x = 0;
			if (p->y < 0) p->y = 0;
			if (p->x > glove_pconfig.maxsx) p->x = glove_pconfig.maxsx;
			if (p->y > glove_pconfig.maxsy) p->y = glove_pconfig.maxsy;
			p->gesture = G_UNKNOWN;
/***
			p->gesture = ((gesture_time[which]) > DEBOUNCE_TIME) ? (gesture_type[which]) : G_UNKNOWN;
***/
			p->buttons = (p->gesture==G_FIST) ? 1 : 0;
		}
		break;

	case DRIVER_CHECK:
		if ((g_driver_ptr[which])->driverStatus() != gloveDriver::EverythingOK) return NULL;
		break;
	case DRIVER_QUIT:
		if ((g_driver_ptr[0])) delete (g_driver_ptr[0]);
		if ((g_driver_ptr[1])) delete (g_driver_ptr[1]);
		break;
	}
	return &glove_pconfig;
}

// following only gets called once
void glove_Start()
{
	(g_driver_ptr[0])->Start(strcmp(gloveIni->find(
				gloveDriver::getTitle(),
				"PolledOperation", "False"),
				"True") ? True : False);
	gloveIni->write();
	delete gloveIni;
	InitFile::dealloc();
	sub_exit(gloveptr_quit);
}

Boolean glove_Polarity(int which)
{
	return ((g_driver_ptr[which])->getPolarity());
}
