/* Code for loading drivers at runtime */

/* Written by Dave Stampe, August 1992 */

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

#include <dos.h>
#include <stdio.h>
#include <alloc.h>
#include <stdlib.h>

#include "rend386.hpp"

void *load_driver(char *dfile)
{
	FILE *f;
	long s;
	void *d_mem, *d_ptr;

	f = fopen(dfile,"rb"); /* open driver file */
	if (f == NULL) return NULL;

	fseek(f, 0, SEEK_END); /* find length, get memory */
	s = ftell(f);
	d_mem = (char *) malloc(s+16);
	if (d_mem == NULL)
	{
		fprintf(stderr,"Cannot allocate memory for driver.\n");
		exit(0);
	}/* setup for segment aligned load */

	d_ptr = MK_FP(FP_SEG(d_mem),0);
	fseek(f, FP_OFF(d_mem), SEEK_SET);
	fread(d_mem, 16, s-FP_OFF(d_mem), f);

	fclose(f);

	return d_ptr;
}
