/* A simple user-interface demo -- Version 4 */

/* Written by Bernie Roehl, February 1992 */

/* Latest version (re)written June 1992 */

/* Contact: broehl@sunee.waterloo.edu */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <mem.h>
#include <dos.h>
#include <bios.h>
#include <iostream.h>
#include <strstream.h>
#include <conio.h>

#include "rend386.hpp"
#include "intmath.h"
#include "plg.h"
#include "segio.hpp"
#include "segasupp.hpp"
#include "splits.hpp"
#include "pointer.hpp"
#include "tasks.hpp"
#include "cursor.hpp"
#include "userint.hpp"
#include "world.hpp"
#include "colormap.hpp"
#include "hdmanip.hpp"
#include "keyboard.hpp"
#include "render.hpp"
#include "vd2.hpp"

#include "isr.hpp"
#include "inputptr.hpp"
#include "shamless.hpp"

extern void *screen_data();

extern unsigned _stklen = 10000;

#define XFSC 536870912   /* 2**29 for shifting xform coeffs to long */

#define sub_exit        atexit

/* default screen data setup */

STEREO default_stereo = {
	600 , 240, 320, 50, 600, 1*65536L };

VIEW default_view = {
	0,0,-8000, /* ex,ey,ez */
	0,0,0, /* pan,tilt,roll */
	4*65536L, /* zoom */
	1000,15000,-5000, /* lx,ly,lz */
	0,63, /* point, ambient */
	0,319,0,200, /* left,right,top,bottom */
	1,100000, /* hither, yon */
	1/1.25*65536L, /* aspect ratio */
	0, /* flags */
	0,0, /* no offset */
	0 /* no flip */
}; /* don't init. matrix */

VIEW *current_view = &default_view;

VIEW orig_view; /* used for '*' key */

int v_page = 0; /* screen page swap variable */

OBJLIST *objlist; /* the linked list of objects in the scene */

int running = 1; /* non-zero until we're ready to exit */
int redraw = 1; /* non-zero if we need a redraw */
int review = 1; /* non-zero if we need to recompute current view */
int reframe = 1; /* non-zero if we need to copy our frame back on-screen */

int do_horizon = 1;

int stereo_type = MONOSCOPIC;

extern int use_old_keys; /* NEED TO SET DISTANCE AS WELL ! */

int have_joystick = 0; /* non-zero if we have one or more joysticks */
joystick_data joy;

long spacestep = 10L; /* "granularity" of motion */

unsigned lastkey = 0, nextolastkey = 0;

char *progname = "demo";

char vdname[40] = "vd256.rvd";
int vdmode = 0x14;

char swdname[40] = "sega";

char mdname[40] = "mouse";
PDRIVER *cursor_device = NULL; // primary mouse device
PDRIVER *menu_device = NULL; // secondary mouse device
int manip_2D_avail = 0; // can do mouse manipulation

char gpdname[40] = "pglove";
char gpcursor[80] = "handsm.fig";
char lgpcursor[80] = "lhandsm.fig";
float gpdo_x = 1, gpdo_y = 1, gpdo_z = 2, gpdo_rx = 1, gpdo_ry = 1, gpdo_rz = 1;
int have_glove = 0;
int have_ptr = 0;
PDRIVER *manip_device[2] = {NULL, NULL}; // extended manip. device (glove or pointer)

char hdname[40] = "none";
float hdo_x = 0, hdo_y = 0, hdo_z = 0; // relative pos'n to neck
float hdo_rx = 0, hdo_ry = 0, hdo_rz = 0;
PDRIVER *head_device = NULL; // head tracking device


MATRIX head_tracker_map = { 
	XFSC, 0, 0, 0, XFSC, 0, 0, 0, XFSC, 0, 0, 0 };

int sl_xflip = 0, sl_xoff = 0;
long sl_left = -1, sl_top, sl_right, sl_bottom;
int sr_xflip = 0, sr_xoff = 0;
long sr_left = -1, sr_top, sr_right, sr_bottom;
float sl_xrot = 0, sr_xrot = 0;

int use_glove = 0;
int use_ht = 0;
int use_wide = 0;
int use_BW = 0;
int swap_eyes = 0;
int vd_loaded = 0;

int fancy_background = 0; // if set, we display a fancy background
int reflection_pool = 0; // if set, draw a "reflecting pool" at the bottom of the screen
int have_logo = 0; // if set, we have a logo
int show_logo = 0; // if set, show the logo (if we have one)
int show_location = 1; // if set, we display the current location on-screen
int show_compass = 1; // if set, we display the 3-D compass on-screen
int show_framerate = 1; // if set, we display the frames/second rate
int show_gestures = 1; // display the name of the gestures.
int do_screen_clear = 1; // by default, we clear the screen on each frame
int use_frame = 0; // if set, draw a "frame"
int frame_x = 0, frame_y = 0, frame_w = 320, frame_h = 200; // frame location

TASK *tasklist = NULL;

SPLIT *split_tree = NULL;

int npalette = 0; /* non-zero if we have a palette loaded */
unsigned char palette[256*3];

extern unsigned getkey();

char framefname[100];

extern struct Screeninfo *screeninfo;
extern highest_color;

char loadpath[100] = "";
char cursorloadpath[100] = "";

segaISR* switcherISR;

static char buff[100];          // for temporary output

Boolean want_mouse = True;

char *fix_fname(char *name)
{
	static char tempname[100];

	if (loadpath[0] && !strchr(name, '\\') && !strchr(name, '/')) {
		strcpy(tempname, loadpath);
		strcat(tempname, "\\");
		strcat(tempname, name);
		// sprintf(tempname, "%s\\%s", loadpath, name);
	}
	else
		strcpy(tempname, name);
	strlwr(tempname);
	return tempname;
}

void *v_driver_pointer = NULL;

Boolean load_video_driver(char *dfile)
{
	if (vd_loaded) return True;
	v_driver_pointer = load_driver(dfile);
	if (v_driver_pointer == NULL)
	{
		cerr << "Cannot read video driver " <<  dfile << endl;
		return False;
	}
	return True;
}

void read_file_arg(char * name)
{
	FILE *in;
	long x, y, z;
	OBJECT *obj;
	char *in_filename;
	in_filename = fix_fname(name);
	if (strstr(in_filename,".plg")) // check if plg or fig file
	{
		if ((in = fopen(in_filename, "r")) == NULL) {
			cerr << "Could not open '" << in_filename << "'" << endl;
			fclose(in);
			return;
		}

		set_loadplg_offset(0,0,0);
		set_loadplg_scale(1,1,1);
		while ((obj = load_plg(in)) != NULL)
		{
			SEGMENT *s;
			add_to_objlist(objlist, obj);
			if ((s = new_seg(NULL)) == NULL)
				cerr << "Warning: out of memory while loading an object" << endl;
			else
			{
				seg_set_object(s, obj);
				set_object_owner(obj, s);
				update_segment(s);
			}
			if (spacestep < get_object_bounds(obj, &x, &y, &z)/5L)
				spacestep = get_object_bounds(obj, &x, &y, &z)/5L;
		}
		if (load_err)
		{
			cerr << "Load error: " << load_err << endl;
			getkey();
		}
	}
	else if (strstr(in_filename,".fig")) /* check if plg or fig file */
	{
		SEGMENT *s;
		int c;
		if ((in = fopen(in_filename, "r")) == NULL) {
			cerr << "Could not open '" << in_filename << "'" << endl;
			fclose(in);
			return;
		}
		set_readseg_objlist(objlist);
		if ((s = readseg(in, NULL)) == NULL)
			cerr << "Could not read '" << name << "'" << endl;
		else
			update_segment(s);
	}
	else {
		FILE * fptr = fopen(fix_fname(in_filename), "r");
		if (fptr) {
			if (!read_world(fptr))
				cerr << "Error reading world file" << endl;
			fclose(fptr);
		}
		// defaults should not be written to file.
		// (since this is not a "config" file.)
	}
}

void parse_args(char *argv[])
{
	int i = 0;
	for (; argv[i]; ++i)
	{
		if (argv[i][0] == '/' || argv[i][0] == '-')
		{
			switch(toupper(argv[i][1]))
			{
			case 'M':/* mirror stereo */
				stereo_type = SPLITLR;
				/* possibly problem here: assumes 320x200 mode before checking */
				default_stereo.phys_screen_dist = 200;
				default_stereo.phys_convergence = 700;
				default_stereo.phys_screen_width = 120;
				default_stereo.pixel_width = 160;
				default_view.right = 159;
				compute_stereo_data(&default_stereo, 0, 0, 0, 0, 0, 0, 159, 100);
				compute_stereo_data(&default_stereo, 1, 1, 0, 0, 160, 0, 319, 100);
				break;
			case 'R':/* swap eyes on Sega driver */
				swap_eyes = 1;
				break;
			case 'C':/* set conv. distance */
				default_stereo.phys_screen_dist = atol(argv[++i]);
				break;
			case 'S':/* set world scale */
				default_stereo.world_scaling = 65536.0*atof(argv[++i]);
				break;
			case 'E':/* set eye spacing */
				default_stereo.phys_eye_spacing = atol(argv[++i]);
				break;
			case 'X':/* turn on stereo */
				stereo_type = SWITCHED;
				break;
			case 'J':/* sort by object (default is polys) */
				set_default_depth_sort(get_default_depth_sort() | BYOBJECT);
				break;
			case 'P':/* depth sort-- deepest */
				set_default_depth_sort(get_default_depth_sort() & (~(BYOBJECT|AVERAGE|ATBACK)));
				break;
			case 'A':/* depth sort-- middle */
				set_default_depth_sort(get_default_depth_sort() | AVERAGE);
				break;
			case '1':/* com 1 for SEGA */
				select_sega_port(0x3FC);
				break;
			case '2':/* com 2 for SEGA */
				select_sega_port(0x2FC);
				break;
			case 'G':/* enable glove */
				use_glove = 1;
				if(!have_ptr) have_glove = 1;
				break;
			case 'H':/* enable head tracker */
				use_ht = 1;
				break;
			case 'W':/* enable wide-angle dual-VGA displays */
				use_wide = 1;
				stereo_type = SEPARATE;
				default_stereo.phys_screen_dist = 50;
				default_stereo.phys_convergence = 1200;
				default_stereo.phys_screen_width = 115;
				default_stereo.pixel_width = 320; /* hmm... may vary */
				break;
			case 'B':/* force all colors to monochrome */
				use_BW = 1;
				break;
			}
		}
		else
			read_file_arg(argv[i]);
	}
}

void parse_all_argv(char *argv[])
{
	char * fname;
	int i = 1;

	if(!stricmp(&(argv[i][0]), "/C"))
	{
		i = 2;
		fname = &(argv[i][0]);
	}
	else fname = "rend386.cfg";

//      InitFile ini(fname);
	FILE * fptr = fopen(fix_fname(fname), "r");
	if (fptr) {
		if (!read_world(fptr))
			cerr << "Error reading config file '" << fname << "'" << endl;
		fclose(fptr);
	}
	// Save defaults if necessary.
//      ini.write();
	parse_args(&argv[i]);
}

void main_entry(char * name)
{
	void wrap(); /* wrap-up function, shuts everything down */

	if ((progname = strrchr(name, '.')) != NULL) *progname = '\0';
	progname = name;

	if (getenv("REND386"))
		strcpy(loadpath, getenv("REND386"));

	setup_render(50,800); /* # of K, # of polys */
	sub_exit(wrap);
	set_global_split_root(&split_tree);
	initial_world_split(&split_tree);
	set_move_handler(split_move_handler);
	objlist = new_objlist();
}


void main_body()
{
	void joystick_calibration(joystick_data *joy) , refresh_display();

	unsigned getkey();
	PDRIVER *dm;

	have_joystick = joystick_check();

//      if (!load_video_driver(vdname)) return;
	screeninfo = (Screeninfo *)screen_data();
	highest_color = screeninfo->colors-1;
	preset_default_colors();

	frame_x = screeninfo->xmin;
	frame_y = screeninfo->ymin;
	frame_w = screeninfo->xmax - screeninfo->xmin + 1;
	frame_h = screeninfo->ymax - screeninfo->ymin + 1;

	/* Default view is full-screen: */
	default_view.left = screeninfo->xmin;
	default_view.top = screeninfo->ymin;
	default_view.right = screeninfo->xmax;
	default_view.bottom = screeninfo->ymax;
	default_view.aspect = screeninfo->aspect;

	orig_view = default_view;

	PDRIVER *gd1, *gd2;
	if(use_glove && (!have_ptr))
	{
		cout << "Looking for glove #1..." << endl;
		cout << "(press any key to proceed without glove)" << endl;
		gd1 = gloveptr_init(gpdname, 0);
		if (!pointer_check(gd1, 0)) {
			gd1 = gd2 = NULL;
			use_glove = 0;
		}

		manip_device[0] = menu_device = gd1;

		if (gd1) {
			cout << "Looking for glove #2..." << endl;
			cout << "(press any key to proceed with just 1 glove)" << endl;
			gd2 = gloveptr_init(gpdname, 1);
			if (!pointer_check(gd2, 1)) gd2 = NULL;
			manip_device[1] = gd2;
			glove_Start();
		}
	}
	if (enter_graphics())
	{
		cerr << "Could not enter graphics mode" << endl;
		return;
		// exit(1);
	}
	vd_loaded++;

	initialize_screen_factors(current_view);
	fast_view_factors(current_view);

	if (npalette)
		load_DAC_colors(palette, highest_color+1, use_BW);

	if (use_frame)
	{
		FILE *in;
		use_frame = 0; /* we only set it back to 1 if we're successful */
		if(stereo_type == MONOSCOPIC)
			if ((in = fopen(fix_fname(framefname), "rb")) != NULL)
			{
				if (load_pcx(in, 3) == 0) use_frame = 1;
				copy_block(3, 0, 0, 0, frame_x, frame_y, frame_w, frame_h);
				copy_block(3, 0, 0, 1, frame_x, frame_y, frame_w, frame_h);
				copy_block(3, 0, 0, 2, frame_x, frame_y, frame_w, frame_h);
				fclose(in);
			}
	}

	init_body_links();

	if(stereo_type != MONOSCOPIC)
	{
		if (!init_switch_driver(swdname)) return;

		if(sl_left<0)
		{
			sl_left = default_view.left;
			sl_right = default_view.right;
			sl_top = default_view.top;
			sl_bottom = default_view.bottom;
		}
		compute_stereo_data(&default_stereo, 0, sl_xflip, sl_xoff, 65536.0*sl_xrot,
		sl_left, sl_top, sl_right, sl_bottom);

		if(sr_left<0)
		{
			sr_left = default_view.left;
			sr_right = default_view.right;
			sr_top = default_view.top;
			sr_bottom = default_view.bottom;
		}
		compute_stereo_data(&default_stereo, 1, sr_xflip, sr_xoff, 65536.0*sr_xrot,
		sr_left, sr_top, sr_right, sr_bottom);
	}

	if (want_mouse) {
		if ((dm=mouseptr_init(mdname))!=NULL) {
			cursor_show(v_page);
			manip_2D_avail++;
		}
	}
	else {
		dm = NULL;
	}
	cursor_device = dm;
	menu_device = dm;

	if(stricmp(hdname,"none") && use_ht)
	{
		extern PDRIVER *init_head_device(char *name, long x, long y, long z, long rx, long ry, long rz);
		head_device = init_head_device(hdname, hdo_x, hdo_y, hdo_z,
		hdo_rx*65536.0, hdo_ry*65536.0, hdo_rz*65536.0);
	}

	// not going to be using powerglove
	if ((!use_glove) || have_ptr || stricmp(gpdname,"pglove"))
	{
		switcherISR = new segaISR;
		if(stereo_type==SWITCHED) {
			switcherISR->Init(switch_sega);
			switcherISR->run();
			// init_SG_interrupt(switch_sega,NULL,6500);
		}
		else {
			switcherISR->Init();
			switcherISR->run();
			// init_timer();
		}
	}

	if(use_glove && (!have_ptr))
	{

		extern SEGMENT *body_seg;
		if(gd1 || gd2) {
			if(gd1) gloveptr_setup(gd1, gpdo_x*65536.0, gpdo_y*65536.0, gpdo_z*65536.0,
				gpdo_rx*65536.0, gpdo_ry*65536.0, gpdo_rz*65536.0);
			if(gd2) gloveptr_setup(gd2, gpdo_x*65536.0, gpdo_y*65536.0, gpdo_z*65536.0,
				gpdo_rx*65536.0, gpdo_ry*65536.0, gpdo_rz*65536.0);
		}
		refresh_display();

		if(gd1 || gd2) {
			if(gd1)
				load_glove_cursor(body_seg, manip_device[0], gpcursor, 0);
			if(gd2) {
				if (glove_Polarity(1))
					load_glove_cursor(body_seg, manip_device[1], gpcursor, 1);
				else
					load_glove_cursor(body_seg, manip_device[1], lgpcursor, 1);
			}
		}
		else have_glove = use_glove = 0;
	}

	if(use_glove && have_ptr)
	{
		extern SEGMENT *body_seg;
		PDRIVER *gd;
//              extern PDRIVER *gloveptr_init(char *gname, long sx, long sy, long sz, long srx, long sry, long srz, int which);

		gd = gloveptr_init(gpdname, 0);
		gloveptr_setup(gd, gpdo_x*65536.0, gpdo_y*65536.0, gpdo_z*65536.0,
			gpdo_rx*65536.0, gpdo_ry*65536.0, gpdo_rz*65536.0);
		manip_device[0] = menu_device = gd;
		if(gd)
		{
			set_loadplg_offset(0, 0, 0);
			set_loadplg_scale(1, 1, 1);
			load_3D_cursor(body_seg, manip_device[0], gpcursor);
		}
		else have_ptr = use_glove = 0;
	}

	if ((have_joystick) != 0)
	{
#ifdef ASKUSER
		popmsg("Joystick found -- use it?");
		reframe = 1;
		joystick_read(&joy);
		while(!kbhit() && (joy.buttons==0)) joystick_read(&joy);
		if(joy.buttons || toupper(getkey()) == 'Y')
		{
			refresh_display();
			joystick_calibration(&joy);
		}
		else
			have_joystick = 0;
		refresh_display();
#else
		joystick_calibration(&joy);
#endif
	}

	while (running)
	{
		int x, y;
		unsigned buttons;

		if (cursor_device) move_and_select_2D(cursor_device);

		if (have_joystick)
			if (joystick_read(&joy))
				do_joy(&joy);
		if (bioskey(1))
		{
			do_key(nextolastkey = getkey());
			lastkey = nextolastkey;
		}

		if(head_device && use_ht) head_update(0);

		if (use_glove)
		{
			POINTER gp, gp2;
			int g;

// FIRST GLOVE
			if((!have_ptr) && gd1)
			{
				glove_update(manip_device[0], &gp, 0);
				gp.gesture = perform_gestset(0);
				switch(gp.gesture)
				{
				case G_FIST :
					g = GRASP_DO;
					break;
				case G_PINCH:
					g = ROTATE_DO;
					break;
				case G_POINT:
					g = SELECT_DO;
					break;
				default:
					g = FREE_DO;
					break;
				}
			}
/***
			else
				{
				cursor_update3D(manip_device[0], &gp);
				switch(gp.buttons)
				{
				case 2:
					g = GRASP_DO;
					break;
				case 3:
					g = ROTATE_DO;
					break;
				case 1:
					g = SELECT_DO;
					break;
				default:
					g = FREE_DO;
					break;
				}
			}
****/

			if (gd1) manip_do(manip_device[0],g, 0);
// SECOND GLOVE
			if((!have_ptr) && gd2)
			{
				glove_update(manip_device[1], &gp2, 1);
				gp2.gesture = perform_gestset(1);
				switch(gp2.gesture)
				{
				case G_FIST :
					g = GRASP_DO;
					break;
				case G_PINCH:
					g = ROTATE_DO;
					break;
				case G_POINT:
					g = SELECT_DO;
					break;
				default:
					g = FREE_DO;
					break;
				}
			}
			if (gd2) manip_do(manip_device[1],g, 1);
		}

		run_tasks(tasklist);

		if (redraw) refresh_display();
	}
}

unsigned __ovrbuffer = 0x1000;

#ifdef CMD_LINE
#pragma argsused
void main(int argc, char *argv[])
{
	main_entry(argv[0]);
	parse_all_argv(argv);
	main_body();
	sub_exit_funcs();
	//exit(0);
}

#else

void internal_demo(char * exe_name, char *file_selected)
{
	running = 1;
	reset_sub_exits();
	main_entry(exe_name);
	InitFile ini("rend386.cfg");
	if (!read_world(ini))
		cerr << "Error reading config file 'rend386.cfg'" << endl;
	// Save defaults if necessary.
	ini.write();
	read_file_arg(file_selected);
	main_body();
	sub_exit_funcs();
}
#endif

void wrap() /* end program */
{
	int i;

	if (have_joystick) joystick_quit();
	if(vd_loaded) exit_graphics();
	reset_render();
	cout << endl << "The libraries used in this package are available on the Internet," << endl;
	cout << "via anonymous ftp to sunee.uwaterloo.ca in pub/rend386." << endl << endl;
	cout << "For more information, send e-mail to:" << endl;
	cout << "    Bernie Roehl  (broehl@sunee.uwaterloo.ca)" << endl;
	cout << "    Dave Stampe   (dstampe@sunee.uwaterloo.ca)" << endl << endl;
	shamelessFunc();
	//sub_exit_funcs();
}


static l_x = 1000, l_y = 15000, l_z = -5000; /* light source */

long center_d = 10000;
long center_x = 0;
long center_y = 0;
long center_z = 0;
long latitude = 0;
long longitude = 0;
long center_roll = 0;

static long light_d = 1000000;

void polar_compute()
{
	MATRIX m,n;

	long x = 0;
	long y = 0;
	long z = -center_d;

	std_matrix(n,longitude,latitude,center_roll,0,0,0);

	matrix_point(n,&x,&y,&z);
	current_view->ex = x + center_x;
	current_view->ey = y + center_y;
	current_view->ez = z + center_z;

	x = l_x;
	y = l_y; 
	z = l_z;
	matrix_point(n,&x,&y,&z);
	current_view->lx = x;
	current_view->ly = y;
	current_view->lz = z;
	current_view->pan = latitude;
	current_view->tilt = longitude;
	current_view->roll = center_roll;
}

void refresh_display()
{
	VIEW v;

	if (use_old_keys) polar_compute();
	initialize_screen_factors(current_view);

	if (!(use_glove || head_device)) {
		fast_view_factors(current_view);
		screen_refresh(current_view);
	}
	else {
		body_centric_map(current_view, &v);
		screen_refresh(&v);
	}

	redraw = 0;
}

load_logo(char *filename)
{
	char far *buffer;
	FILE *in;
	if ((in = fopen(fix_fname(filename), "rb")) == NULL) return 0;
	if (load_pcx(in, 3)) { /* some sort of problem loading it in */
		fclose(in);
		return 0;
	}
	fclose(in);
	return 1; /* all is well... we have a logo */
}

resize_viewport()
{
	int top, left, bottom, right;
	unsigned buttons;
	cursor_hide();
	clear_display(v_page);
	cursor_show(v_page);
	popmsg("Click top-left and drag");
	do {
		move_2D(cursor_device, &left, &top, &buttons);
	}
	while (buttons == 0);
	while (buttons) {
		while (!move_2D(cursor_device, &right, &bottom, &buttons));
		clear_display(v_page);
		vgabox(left, top, right, bottom, 15);
	}
	if (right - left > 10) {
		current_view->left = left & (~0x0007); /* always on a 16-pixel boundary */
		current_view->right = (right & (~0x0007)) + 7;
	}
	if (bottom - top > 10) {
		current_view->top = top;
		current_view->bottom = bottom;
	}

 if(stereo_type == SWITCHED)  /* makes sense for Sega only (no shift) */
	{
		compute_stereo_data(&default_stereo, 0, sl_xflip, sl_xoff, 65536.0*sl_xrot,
		current_view->left, current_view->top, current_view->right, current_view->bottom);
		compute_stereo_data(&default_stereo, 1, sr_xflip, sr_xoff, 65536.0*sr_xrot,
		current_view->left, current_view->top, current_view->right, current_view->bottom);
	}

	/* Make sure all pages are refreshed: */
	reset_screens();
	refresh_display();
	return 0;
}

save_pcx_file()
{
	char far *buffer;
	FILE *out;
	refresh_display();
	askfor("File to save to? ", buff, 15);
	reframe = 1;
	if (buff[0] == '\0') return 1;
	refresh_display();
	if ((out = fopen(buff, "wb")) == NULL) {
		popmsg("Could not open file");
		reframe = 1;
		getkey();
		return 3;
	}
	cursor_hide();
	save_pcx(out, v_page);
	cursor_show(v_page);
	fclose(out);
	return 0;
}

/* Some support routines */

char * center(char *s, int w)
{
	//if (!s) return;
	int slen = strlen(s);
	if (slen == 0) return s;
	int n = (w - slen) / 2;
	if (n < 0) return s;
	char * retval = new char[n + slen + 2];
	for (int i = 0; i < n; i ++) retval[i] = ' ';
	retval[n] = '\0';
	strcat(retval, s);
	return retval;
}

disp_status(VIEW *v)
{
	char *text[9];
	int w, i;

	text[0] = "STATUS";
	text[1] = "";

	ostrstream xyz;
	xyz << "X = " << v->ex << "  Y = " << v->ey << "  Z = " << v->ez << '\0';
	text[2] = xyz.str();
	w = strlen(text[2]);

	ostrstream ptr;
	ptr << "Pan = " << v->pan/65536L << "   Tilt = "
		<< v->tilt/65536L << "   Roll = "
		<< v->roll/65536L << '\0';
	text[3] = ptr.str();
	w = max(w, strlen(text[3]));

	ostrstream zm;
	zm << "Zoom = " << v->zoom/65536L << '\0';
	text[4] = zm.str();
	w = max(w, strlen(text[4]));

	ostrstream hy;
	hy << "Hither = " << v->hither << "  Yon = " << v->yon << '\0';
	text[5] = hy.str();
	w = max(w, strlen(text[5]));

	if (have_joystick) {
		joystick_read(&joy);
		ostrstream js;
		js << "Joystick = " << joy.x << "," << joy.y << '\0';
		text[6] = js.str();
		w = max(w, strlen(text[6]));
		text[7] = NULL;
	}
	else text[6] = NULL;

	char * temp;
	w += 2;

	for (i = 0; text[i]; ++i) {
		temp = text[i];
		text[i] = center(text[i], w);
		if (i > 1) free(temp);
	}
	poptext(text);
	reframe = 1;
	getkey();
	for (i = 2; text[i]; ++i) delete text[i];
	return 0;
}


void joystick_calibration(joystick_data *joy)
{
	if (have_joystick == 0) return;
	if (have_joystick & 1) joystick_init(joy, 0);
	else if (have_joystick & 2) joystick_init(joy, 1);

	joystick_setscale(joy, 100);
	reframe = 1;
}

static int nobjs, nverts, npolys;

void gather_data(OBJECT *obj)
{
	int nv = 0, np = 0;
	get_obj_info(obj, &nv, &np);
	++nobjs;
	nverts += nv;
	npolys += np;
}

disp_info()
{
	OBJECT *obj;
	nobjs = 0, nverts = 0, npolys = 0;
	char * text[9];

	walk_split_tree(split_tree, gather_data);
	ostrstream objs;
	objs << nobjs << " object" << ((nobjs == 1) ? "" : "s") << '\0';
	text[0] = objs.str();

	ostrstream vrt;
	vrt << nverts << " vert" << ((nverts == 1) ? "ex" : "ices") << '\0';
	text[1] = vrt.str();

	ostrstream plg;
	plg << npolys << " polygon" << ((npolys == 1) ? "" : "s") << '\0';
	text[2] = plg.str();

	text[3] = NULL;

	int w = max(strlen(text[0]), strlen(text[1]));
	w = max(w, strlen(text[2]));
	char * temp;
	for (int i = 0; text[i]; ++i) {
		temp = text[i];
		text[i] = center(text[i], w);
		delete temp;
	}

	poptext(text);
	reframe = 1;
	getkey();
	for (i = 0; text[i]; ++i) delete text[i];
	return 0;
}

extern AREA *areas;

extern POINTER gloveptr;

char *gest[] = {
	"FLAT", "THUMB_IN", "INDEX_IN", "MIDDLE_IN",
	"RING_IN", "PINCH", "FIST", "THUMB_OUT", "POINT",
	"BADFINGER", "RING_OUT", "??????" };

void prprint(int x,int y, int color, char *t)
{
	int bk = (color>8) ? 0 : 15;

	printxyr(x,y,bk,t,0);
	printxyr(x+1,y+1,color,t,0);
}

status_on_screen()
{
	AREA *a;
	long floor_at(), ceiling_at();

	if (show_location) {
		strcpy(buff, "Pos(x,z): ");
		ltoa(current_view->ex, buff + 10, 10);
		strcat(buff, ",");
		ltoa(current_view->ez, buff + strlen(buff), 10);
		prprint(2, 3, 15, buff);

		strcpy(buff, "Not in any area");
		a = what_area(split_tree, current_view->ex, current_view->ey, current_view->ez);
		if (a)
		{
			char *p = find_value((NAMEREF *)areas, a);
			if (p) {
				strcpy(buff, "Area: ");
				strcat(buff, p);
				// sprintf(buff, "Area: %s", p);
			}
		}
		prprint(2,15,15,buff);
	}
	if (show_gestures && use_glove)
	{
		int sl;
		POINTER p;

		last_pointer(manip_device[0], &p);
		strcpy(buff, "Glove 1: ");
		strcat(buff, gest[p.gesture]);
		//sprintf(buff,"Glove: %s",gest[p.gesture]);
		sl = strlen(buff)<<3;
		prprint(300-sl,3,15,buff);
		if (manip_device[1]) {
			last_pointer(manip_device[1], &p);
			strcpy(buff, "Glove 2: ");
			strcat(buff, gest[p.gesture]);
			//sprintf(buff,"Glove: %s",gest[p.gesture]);
			sl = strlen(buff)<<3;
			prprint(300-sl,15,15,buff);
		}
	}
	return 0;

}

