// Copyright 1993, Mark T. Pflaging
#include "rendgest.hpp"
#include "userint.hpp"
#include "keyboard.hpp"
#include "segasupp.hpp"
void RendGestSet::Init(InitFile & ini, char * sectionName)
{
	setName(sectionName);
	addId(ini.find(sectionName, "Up"), Up);
	addId(ini.find(sectionName, "Down"), Down);
	addId(ini.find(sectionName, "Left"), Left);
	addId(ini.find(sectionName, "Right"), Right);

	addId(ini.find(sectionName, "StraightUp"), StraightUp);
	addId(ini.find(sectionName, "StraightDown"), StraightDown);
	addId(ini.find(sectionName, "StraightLeft"), StraightLeft);
	addId(ini.find(sectionName, "StraightRight"), StraightRight);

	addId(ini.find(sectionName, "GeneralExtreme"), GeneralExtreme);
	addId(ini.find(sectionName, "ExtremeUp"), ExtremeUp);
	addId(ini.find(sectionName, "ExtremeDown"), ExtremeDown);
	addId(ini.find(sectionName, "ExtremeLeft"), ExtremeLeft);
	addId(ini.find(sectionName, "ExtremeRight"), ExtremeRight);

	addId(ini.find(sectionName, "TiltUp"), TiltUp);
	addId(ini.find(sectionName, "TiltDown"), TiltDown);
	addId(ini.find(sectionName, "TwistCW"), TwistCW);
	addId(ini.find(sectionName, "TwistCCW"), TwistCCW);

	addId(ini.find(sectionName, "Mode1On"), Mode1On);
	addId(ini.find(sectionName, "Mode2On"), Mode2On);
	char * temp = ini.find(sectionName, "Mode1Off");
	if (temp) {
		addId(temp, Mode1Off);
		useMode1Off = True;
	}
	else useMode1Off = False;
	temp = ini.find(sectionName, "Mode2Off");
	if (temp) {
		addId(temp, Mode2Off);
		useMode2Off = True;
	}
	else useMode2Off = False;
	addId(ini.find(sectionName, "Select"), Select);
	addId(ini.find(sectionName, "Move"), Move);
	addId(ini.find(sectionName, "Twist"), Twist);
	for (int i = 0; i <= Twist; i ++) {
		statusBits[i] = False;
	}
}

void RendGestSet::Register(Gesture & arg, Boolean onOrOff)
{
	NumberedGestSet::Register(arg, onOrOff);
	NumberedGesture & found = (NumberedGesture &)arg;
	if (!onOrOff) {
		switch (RendGests(found.getId())) {
		case Mode1On:
			if (useMode1Off) return;
		case Mode2On:
			if (useMode2Off) return;
/***
		case Mode1Off:
		case Mode2Off:
			return;
***/
		}
	}
	if (onOrOff) {
		switch (RendGests(found.getId())) {
		case Mode1Off:
			statusBits[Mode1On] = False;
			return;
		case Mode2Off:
			statusBits[Mode2On] = False;
			return;
		}
	}
	statusBits[found.getId()] = onOrOff;
}

void RendGestSet::postCheck()
{
	int x = 0, y = 0, buttons = 0;
	if (statusBits[Up] || statusBits[TiltDown] || statusBits[StraightUp]) {
		y -= 28;
		if (statusBits[GeneralExtreme]) y -= 60;
	}
	if (statusBits[ExtremeUp]) y -= 60;
	if (statusBits[Down] || statusBits[TiltUp] || statusBits[StraightDown]) {
		y += 28;
		if (statusBits[GeneralExtreme]) y += 60;
	}
	if (statusBits[ExtremeDown]) y += 60;
	if (statusBits[Right] || statusBits[TwistCW] || statusBits[StraightRight]) {
		x += 28;
		if (statusBits[GeneralExtreme]) x += 60;
	}
	if (statusBits[ExtremeRight]) x += 60;
	if (statusBits[Left] || statusBits[TwistCCW] || statusBits[StraightLeft]) {
		x -= 28;
		if (statusBits[GeneralExtreme]) x -= 60;
	}
	if (statusBits[ExtremeLeft]) x -= 60;
	if (((statusBits[Mode1On]) && (statusBits[Mode2On])) ||
		(statusBits[TwistCW] || statusBits[TwistCCW])
	) buttons = 3;
	else {
		if (statusBits[Mode1On] || statusBits[TiltUp] || statusBits[TiltDown]) buttons = 1;
		if (statusBits[Mode2On] || statusBits[StraightUp] || statusBits[StraightDown]) buttons = 2;
	}
	do_joy_move(x, y, buttons);
}

int RendGestSet::findGest()
{
	if (statusBits[Move]) return G_FIST;
	if (statusBits[Twist]) return G_PINCH;
	if (statusBits[Select]) return G_POINT;
	return G_UNKNOWN;
}
