/* ----------------------------------------------------------------------- */
/* -----  Set include file list                                      ----- */
/* ----------------------------------------------------------------------- */
#include<graph.h>
#include<malloc.h>
#include<errno.h>
#include<stdlib.h>

/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */
/* -----                       SUBROUTINES                           ----- */
/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */


char compute(int xloc,int yloc,double rcent,double icent,double limit,
	     double res,int k,double kinv)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine is called by the main mandelbrot           ----- */
/* -----  computational subroutine to perform individual checks at   ----- */
/* -----  specific locations in the complex domain.                  ----- */
/* -----                                                             ----- */
/* -----  INT    xloc  = The current x pixel location on the screen  ----- */
/* -----  INT    yloc  = The current y pixel location on the screen  ----- */
/* -----  DOUBLE rcent = Real Coordinate Value of Screen Center      ----- */
/* -----  DOUBLE icent = Imaginary Coordinate Value of Screen Center ----- */
/* -----  DOUBLE limit = The boundary at which point the complex     ----- */
/* -----                 number is considered to have diverged       ----- */
/* -----  DOUBLE res   = A value equal to one-fourhundredth of the   ----- */
/* -----                 screen width                                ----- */
/* -----  INT    k     = The limit on the number of iterations       ----- */
/* -----                 to try (k+2 iterations will be attempted)   ----- */
/* -----  DOUBLE kinv  = The value of 1/(k+2)                        ----- */
/* -----                                                             ----- */
/* -----  Returns the color code value at the specified location.    ----- */
/* ----------------------------------------------------------------------- */
{
     int flag,test;
     double rc1,ic1,rc,ic,newrc,newic;
     char returnval;

     rc = rcent+res*xloc;
     ic = icent+res*yloc;
     rc1 = rc;
     ic1 = ic;
     flag = 0;
     test = 0;
     while (flag == 0) {
	  if (rc1*rc1+ic1*ic1 > limit) {
	       flag = 1;
	  }
	  else {
	      newrc = rc1*rc1 - ic1*ic1 + rc;
	      newic = 2*rc1*ic1         + ic;
	      rc1 = newrc;
	      ic1 = newic;
	      test++;
	      if (test >= k+2) flag = 1;
	  }
     }
     returnval = test*kinv;
     return(returnval);
}


int mandel(double rcent,double icent,double res,int k,double limit,
	   int color,int prec)
/* ----------------------------------------------------------------------- */
/* -----  This is the main computation portion of the program.  Here ----- */
/* -----  the Mandelbrot domain is computed and displayed according  ----- */
/* -----  to the parameters passed to it.                            ----- */
/* -----                                                             ----- */
/* -----  DOUBLE rcent = Real Coordinate Value of Screen Center      ----- */
/* -----  DOUBLE icent = Imaginary Coordinate Value of Screen Center ----- */
/* -----  DOUBLE res   = A value equal to one-fourhundredth of the   ----- */
/* -----                 screen width                                ----- */
/* -----  INT    k     = The limit on the number of iterations       ----- */
/* -----                 to try (k+2 iterations will be attempted)   ----- */
/* -----  DOUBLE limit = The boundary at which point the complex     ----- */
/* -----                 number is considered to have diverged       ----- */
/* -----  INT    color = A flag indicating whether to display in     ----- */
/* -----                 color mode 1 (1)       color mode 2 (2)     ----- */
/* -----                 black/white  (3)       white/black  (4)     ----- */
/* -----  INT    prec  = precision (1 = float, 2 = double)           ----- */
/* -----                                                             ----- */
/* -----  Program returns a 1 is sucessful, a 2 if not sucessful.    ----- */
/* ----------------------------------------------------------------------- */
{
     int xloc,yloc,point1,point2,point3,point4,oldcolor,newcolor,flag,test;
     char _huge *precomp,_huge *current1;
     float rcf,icf,rc1f,ic1f,newrcf,newicf,kinvf;
     double rcd,icd,rc1d,ic1d,newrcd,newicd,kinvd,kinv;
     float rcentf,icentf,limitf,resf;
     double rcentd,icentd,limitd,resd;

     /* -----  Attempt to allocate memory for preprocessing, on fail ----- */
     /* -----  print error message and return to main program.       ----- */
     precomp = (char _huge *)halloc(160801L,sizeof(char));
     if (precomp == NULL) {
	  _setcolor(1);
	  _rectangle(_GFILLINTERIOR,237,2,637,403);
	  _setcolor(15);
	  _moveto(323,158);
	  _outgtext("INSUFFICIENT MEMORY");
	  _moveto(353,182);
	  _outgtext("TO RUN PROGRAM");
	  return(2);
     }
     else {
	  /* -----  Preprocess Mandelbrot domain map in a coarse     ----- */
	  /* -----  manner.                                          ----- */
	  current1 = precomp;
	  _setcolor(1);
	  _rectangle(_GFILLINTERIOR,237,2,637,403);
	  _setcolor(15);
	  _moveto(329,182);
	  _outgtext("PROCESSING STAGE 1");
	  _setcolor(13);
	  _rectangle(_GBORDER,336,211,538,233);
	  _setcolor(14);
	  if (prec == 1) {
	       rcentf = rcent;
	       icentf = icent;
	       limitf = limit;
	       resf = res;
	       kinvf = 15.01/(k+2.0);
	       for (xloc = -200;xloc <= 200;xloc+=2) {
		    rcf = rcentf + resf * xloc;
		    for (yloc = -200;yloc <= 200;yloc+=2) {
			 icf = icentf + resf * yloc;
			 flag = 0;
			 test = 0;
			 rc1f = rcf;
			 ic1f = icf;
			 while (flag == 0) {
			      if (rc1f*rc1f+ic1f*ic1f > limitf) {
				   flag = 1;
			      }
			      else {
				   newrcf = rc1f*rc1f - ic1f*ic1f + rcf;
				   newicf = 2*rc1f*ic1f + icf;
				   rc1f = newrcf;
				   ic1f = newicf;
				   test++;
				   if (test >= k+2) flag = 1;
			      }
			 }
			 *current1 = test*kinvf;
			 current1+=2;
		    }
		    _moveto(387+(xloc+100)/2,212);
		    _lineto(387+(xloc+100)/2,232);
		    current1+=400;
	       }
	  }
	  if (prec == 2) {
	       rcentd = rcent;
	       icentd = icent;
	       limitd = limit;
	       resd = res;
	       kinvd = 15.01/(k+2.0);
	       for (xloc = -200;xloc <= 200;xloc+=2) {
		    rcd = rcentd + resd * xloc;
		    for (yloc = -200;yloc <= 200;yloc+=2) {
			 icd = icentd + resd * yloc;
			 flag = 0;
			 test = 0;
			 rc1d = rcd;
			 ic1d = icd;
			 while (flag == 0) {
			      if (rc1d*rc1d+ic1d*ic1d > limitd) {
				   flag = 1;
			      }
			      else {
				   newrcd = rc1d*rc1d - ic1d*ic1d + rcd;
				   newicd = 2*rc1d*ic1d + icd;
				   rc1d = newrcd;
				   ic1d = newicd;
				   test++;
				   if (test >= k+2) flag = 1;
			      }
			 }
			 *current1 = test*kinvd;
			 current1+=2;
		    }
		    _moveto(387+(xloc+100)/2,212);
		    _lineto(387+(xloc+100)/2,232);
		    current1+=400;
	       }
	  }
	  /* -----  Fill in the gaps in the coarse calculations      ----- */
	  _setcolor(1);
	  _rectangle(_GFILLINTERIOR,237,2,637,403);
	  _setcolor(15);
	  _moveto(329,182);
	  _outgtext("PROCESSING STAGE 2");
	  _setcolor(13);
	  _rectangle(_GBORDER,336,211,538,233);
	  _setcolor(14);
	  current1 = precomp;
	  kinv = 15.01/(k+2.0);
	  for (xloc = -200;xloc <= 200;xloc+=2) {
	       for (yloc = -200;yloc <= 200;yloc+=2) {
		    oldcolor = *(current1+0);
		    flag = 0;
		    if (*(current1+   2) != *(current1+   0)) flag = 1;
		    if (*(current1+ 802) != *(current1+ 804)) flag = 1;
		    if (*(current1- 802) != *(current1- 800)) flag = 1;
		    if (*(current1+1604) != *(current1+1608)) flag = 1;
		    if (*(current1-   2) != *(current1+ 800)) flag = 1;
		    if (*(current1+   4) != *(current1+ 806)) flag = 1;
		    if (*(current1+   0) != *(current1- 802)) flag = 1;
		    if (*(current1+ 804) != *(current1+ 806)) flag = 1;
		    if (*(current1+1604) != *(current1-   2)) flag = 1;
		    if (*(current1+   0) != *(current1-   2)) flag = 1;
		    if (*(current1+   0) != *(current1+   4)) flag = 1;
		    if (flag == 0) {
			 if (yloc != 200) {
			      *(current1+401) = oldcolor;
			      if (xloc != 200) {
				   *(current1+402) = oldcolor;
			      }
			 }
			 if (xloc != 200) {
			      *(current1+1) = oldcolor;
			 }
		    }
		    else {
			 if (xloc != 200) {
			      *(current1+401) = compute(xloc+1,yloc,rcent,icent,limit,res,k,kinv);
			      if (yloc != 200) {
				   *(current1+402) = compute(xloc+1,yloc+1,rcent,icent,limit,res,k,kinv);
			      }
			 }
			 if (yloc != 200) {
			      *(current1+1) = compute(xloc,yloc+1,rcent,icent,limit,res,k,kinv);
			 }
		    }
		    current1+=2;
	       }
	       _moveto(387+(xloc+100)/2,212);
	       _lineto(387+(xloc+100)/2,232);
	       current1+=400;
	  }

	  /* -----  Draw Mandelbrot domain                           ----- */
	  current1 = precomp;
	  for (xloc = -200;xloc <= 200;xloc++) {
	       newcolor = 1;
	       if (color == 1) {
		    newcolor = *current1;
	       }
	       if (color == 2) {
		    newcolor = 15 - *current1;
	       }
	       if (color == 3) {
		    if (*current1 == 15) {
			 newcolor = 15;
		    }
		    else {
			 newcolor = 0;
		    }
	       }
	       if (color == 4) {
		    if (*current1 == 15) {
			 newcolor = 0;
		    }
		    else {
			 newcolor = 15;
		    }
	       }
	       if (color == 5) {
		    newcolor = *current1;
	       }
	       if (color == 6) {
		    newcolor = 15 - *current1;
	       }
	       if (color == 7) {
		    newcolor = *current1;
	       }
	       if (color == 8) {
		    newcolor = 15 - *current1;
	       }
	       _setcolor(newcolor);
	       _moveto(xloc+437,2);
	       oldcolor = newcolor;
	       for (yloc = -200;yloc <= 200;yloc++) {
		    newcolor = 1;
		    if (color == 1) {
			 newcolor = *current1;
		    }
		    if (color == 2) {
			 newcolor = 15 - *current1;
		    }
		    if (color == 3) {
			 if (*current1 == 15) {
			      newcolor = 15;
			 }
			 else {
			      newcolor = 0;
			 }
		    }
		    if (color == 4) {
			 if (*current1 == 15) {
			      newcolor = 0;
			 }
			 else {
			      newcolor = 15;
			 }
		    }
		    if (color == 5) {
			 newcolor = *current1;
		    }
		    if (color == 6) {
			 newcolor = 15 - *current1;
		    }
		    if (color == 7) {
			 newcolor = *current1;
		    }
		    if (color == 8) {
			 newcolor = 15 - *current1;
		    }
		    if (newcolor != oldcolor) {
			 _lineto(xloc+437,yloc+202);
			 _moveto(xloc+437,yloc+203);
			 _setcolor(newcolor);
			 oldcolor = newcolor;
		    }
		    current1++;
	       }
	       if (newcolor == oldcolor) {
		    _lineto(xloc+437,403);
	       }
	  }
	  hfree(precomp);
	  return(1);
     }
}


