/* ----------------------------------------------------------------------- */
/* -----  Set include file list                                      ----- */
/* ----------------------------------------------------------------------- */
#include<graph.h>

/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */
/* -----                       SUBROUTINES                           ----- */
/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */


void initializedisplay()
/* ----------------------------------------------------------------------- */
/* -----  This subroutine is executed at the start of the program    ----- */
/* -----  run to setup the display framework for the user.           ----- */
/* ----------------------------------------------------------------------- */
{
     _setcolor(0);
     _rectangle(_GFILLINTERIOR,0,0,639,479);
     _setcolor(1);
     _rectangle(_GFILLINTERIOR,237,2,637,403);
     _setcolor(14);
     _rectangle(_GBORDER,235,0,639,405);

     _setcolor(8);
     _rectangle(_GFILLINTERIOR,0,0,230,410);
     _rectangle(_GFILLINTERIOR,0,410,639,479);

     _setcolor(15);
     _moveto(10,10);
     _outgtext("MANDELBROT  v1.2");
     _moveto(10,25);
     _outgtext("By Brian Cranton");

     _moveto(10,55);
     _outgtext("F1 = DECREASE K");
     _moveto(10,70);
     _outgtext("F2 = INCREASE K");
     _moveto(10,85);
     _outgtext("F3 = ZOOM IN");
     _moveto(10,100);
     _outgtext("F4 = ZOOM OUT");
     _moveto(10,115);
     _outgtext("F5 = DECR. LIMIT");
     _moveto(10,130);
     _outgtext("F6 = INCR. LIMIT");
     _moveto(10,160);
     _outgtext("F7 = PRECISION");
     _moveto(10,175);
     _outgtext("F8 = DISPLAY MODES");
     _moveto(10,190);
     _outgtext("F9 = CURSOR ON/OFF");
     _moveto(10,220);
     _outgtext("F10 = GENERATE");
     _moveto(10,250);
     _outgtext("q   = QUIT");
     _moveto(10,265);
     _outgtext("i   = INFORMATION");

     _moveto(10,460);
     _outgtext("K VALUE:");
     _moveto(240,445);
     _outgtext("WIDTH     :");
     _moveto(240,460);
     _outgtext("LIMIT     :");
     _moveto(240,415);
     _outgtext("REAL      :");
     _moveto(240,430);
     _outgtext("IMAGINARY :");

     _moveto(35,312);
     _outgtext("7");
     _moveto(35,345);
     _outgtext("4");
     _moveto(35,378);
     _outgtext("1");
     _moveto(66,312);
     _outgtext("8");
     _moveto(66,340);
     _outgtext("5");
     _moveto(66,378);
     _outgtext("2");
     _moveto(98,312);
     _outgtext("9");
     _moveto(98,345);
     _outgtext("6");
     _moveto(98,378);
     _outgtext("3");
     _moveto(54,352);
     _outgtext("SET");

     _moveto(135,295);
     _outgtext("NUMLOCK");
     _moveto(135,310);
     _outgtext("TOGGLES");
     _moveto(135,325);
     _outgtext("BETWEEN");
     _moveto(135,340);
     _outgtext("FAST");
     _moveto(135,355);
     _outgtext("AND");
     _moveto(135,370);
     _outgtext("SLOW");
     _moveto(135,385);
     _outgtext("CURSOR");
     _moveto(135,400);
     _outgtext("SPEEDS");

     _moveto(20,300);
     _lineto(30,310);
     _moveto(20,300);
     _lineto(20,305);
     _moveto(20,300);
     _lineto(25,300);
     _moveto(20,352);
     _lineto(30,352);
     _moveto(20,352);
     _lineto(25,347);
     _moveto(20,352);
     _lineto(25,357);
     _moveto(20,405);
     _lineto(30,395);
     _moveto(20,405);
     _lineto(25,405);
     _moveto(20,405);
     _lineto(20,400);
     _moveto(72,300);
     _lineto(72,310);
     _moveto(72,300);
     _lineto(67,305);
     _moveto(72,300);
     _lineto(77,305);
     _moveto(72,405);
     _lineto(72,395);
     _moveto(72,405);
     _lineto(67,400);
     _moveto(72,405);
     _lineto(77,400);
     _moveto(125,300);
     _lineto(115,310);
     _moveto(125,300);
     _lineto(125,305);
     _moveto(125,300);
     _lineto(120,300);
     _moveto(125,352);
     _lineto(115,352);
     _moveto(125,352);
     _lineto(120,347);
     _moveto(125,352);
     _lineto(120,357);
     _moveto(125,405);
     _lineto(115,395);
     _moveto(125,405);
     _lineto(120,405);
     _moveto(125,405);
     _lineto(125,400);

     _setcolor(13);
     _rectangle(_GBORDER,5,285,220,420);
     _setcolor(12);
     _rectangle(_GBORDER,15,295,50,330);
     _rectangle(_GBORDER,15,335,50,370);
     _rectangle(_GBORDER,15,375,50,410);
     _rectangle(_GBORDER,55,295,90,330);
     _rectangle(_GBORDER,55,335,90,370);
     _rectangle(_GBORDER,55,375,90,410);
     _rectangle(_GBORDER,95,295,130,330);
     _rectangle(_GBORDER,95,335,130,370);
     _rectangle(_GBORDER,95,375,130,410);
}

void information()
/* ----------------------------------------------------------------------- */
/* -----  This subroutine displays the help screens for this program ----- */
/* ----------------------------------------------------------------------- */
{
     _setcolor(1);
     _rectangle(_GFILLINTERIOR,237,2,637,403);
     _setcolor(15);
     _moveto(298,5);
     _outgtext("MANDELBROT VERSION 1.2");
     _moveto(334,20);
     _outgtext("BY BRIAN CRANTON");
     _moveto(316,35);
     _outgtext("PROGRAM INFORMATION");
     _moveto(238,65);
     _outgtext("  The purpose of this program is ");
     _moveto(238,80);
     _outgtext("to generate plots of the         ");
     _moveto(238,95);
     _outgtext("Mandelbrot set in a fast, easy to");
     _moveto(238,110);
     _outgtext("use manner.                      ");
     _moveto(238,125);
     _outgtext("                                 ");
     _moveto(238,140);
     _outgtext("  The following pages of text    ");
     _moveto(238,155);
     _outgtext("provide some background on what  ");
     _moveto(238,170);
     _outgtext("the Mandelbrot set is and how    ");
     _moveto(238,185);
     _outgtext("this program operates.           ");
     _moveto(238,380);
     _outgtext("   <PRESS ANY KEY TO CONTINUE>   ");
     getch();

     _setcolor(1);
     _rectangle(_GFILLINTERIOR,237,2,637,403);
     _setcolor(15);
     _moveto(238,5);
     _outgtext("  The Mandelbrot Set is displayed");
     _moveto(238,20);
     _outgtext("on a Two-Dimensional axis.  The  ");
     _moveto(238,35);
     _outgtext("X-axis represents the real       ");
     _moveto(238,50);
     _outgtext("component of each location and   ");
     _moveto(238,65);
     _outgtext("Y-axis represents the imaginary  ");
     _moveto(238,80);
     _outgtext("component of each location.      ");
     _moveto(238,110);
     _outgtext("  To compute the patterns you see");
     _moveto(238,125);
     _outgtext("displayed on the screen, the     ");
     _moveto(238,140);
     _outgtext("computer takes the complex value ");
     _moveto(238,155);
     _outgtext("of each location and repetitively");
     _moveto(238,170);
     _outgtext("squares that value and adds the  ");
     _moveto(238,185);
     _outgtext("original value to the result.    ");
     _moveto(238,215);
     _outgtext("  Some points in the domain will ");
     _moveto(238,230);
     _outgtext("get smaller as this process is   ");
     _moveto(238,245);
     _outgtext("applied (converge) while other   ");
     _moveto(238,260);
     _outgtext("points in the domain will get    ");
     _moveto(238,275);
     _outgtext("large (diverge).                 ");
     _moveto(238,305);
     _outgtext("  This program operates on each  ");
     _moveto(238,320);
     _outgtext("point up through k+2 iterations  ");
     _moveto(238,335);
     _outgtext("before labeling it as one that   ");
     _moveto(238,350);
     _outgtext("will always converge.            ");
     _moveto(238,380);
     _outgtext("   <PRESS ANY KEY TO CONTINUE>   ");
     getch();

     _setcolor(1);
     _rectangle(_GFILLINTERIOR,237,2,637,403);
     _setcolor(15);
     _moveto(238,5);
     _outgtext("  The limit at which point the   ");
     _moveto(238,20);
     _outgtext("program will label a point as    ");
     _moveto(238,35);
     _outgtext("diverging is when the vector sum ");
     _moveto(238,50);
     _outgtext("of its real and imaginary        ");
     _moveto(238,65);
     _outgtext("components exceeds the limit     ");
     _moveto(238,80);
     _outgtext("defined by the user.             ");
     _moveto(238,110);
     _outgtext("  The colors/gray shades shown   ");
     _moveto(238,125);
     _outgtext("represent the fraction between   ");
     _moveto(238,140);
     _outgtext("the number of iterations before  ");
     _moveto(238,155);
     _outgtext("diverging and the itteration     ");
     _moveto(238,170);
     _outgtext("limit.                           ");
     _moveto(238,380);
     _outgtext("   <PRESS ANY KEY TO CONTINUE>   ");
     getch();

     _setcolor(1);
     _rectangle(_GFILLINTERIOR,237,2,637,403);
     _setcolor(15);
     _moveto(322,185);
     _outgtext("END OF INFORMATION");

}


void dispk(int k)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine displays the value of k at a predefined    ----- */
/* -----  location on the screen.                                    ----- */
/* -----                                                             ----- */
/* -----  INT k = The current value of k                             ----- */
/* ----------------------------------------------------------------------- */
{
     char number[15];

     _setcolor(8);
     _rectangle(_GFILLINTERIOR,130,460,230,474);
     _setcolor(15);
     _moveto(130,460);
     itoa(k,number,10);
     _outgtext(number);
}


void dispres(double res)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine displays the width of the viewscreen at    ----- */
/* -----  a predefined location on the screen.                       ----- */
/* -----                                                             ----- */
/* -----  DOUBLE res = The current value of res                      ----- */
/* ----------------------------------------------------------------------- */
{
     char number[20];

     _setcolor(8);
     _rectangle(_GFILLINTERIOR,396,445,639,459);
     _setcolor(15);
     _moveto(396,445);
     gcvt(res*400,8,number);
     _outgtext(number);
}


void displimit(double limit)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine displays the value of the iteration limit  ----- */
/* -----  at a predefined location on the screen.                    ----- */
/* -----                                                             ----- */
/* -----  DOUBLE limit = The current value of limit                  ----- */
/* ----------------------------------------------------------------------- */
{
     char number[20];

     _setcolor(8);
     _rectangle(_GFILLINTERIOR,396,460,639,474);
     _setcolor(15);
     _moveto(396,460);
     gcvt(limit,8,number);
     _outgtext(number);
}


void dispcolor(int color)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine displays the current color or black/white  ----- */
/* -----  display mode at a predefined location on the screen.       ----- */
/* -----                                                             ----- */
/* -----  INT color = The current value of color                     ----- */
/* -----              1 = Color mode 1, 2 = Color mode 2,            ----- */
/* -----              3 = Black/white mode, 4 = white/black mode     ----- */
/* ----------------------------------------------------------------------- */
{
     _setcolor(8);
     _rectangle(_GFILLINTERIOR,10,445,230,459);
     _setcolor(15);
     _moveto(10,445);
     if (color == 1) {
	  _outgtext("COLOR MODE 1");
     }
     if (color == 2) {
	  _outgtext("COLOR MODE 1 INV");
     }
     if (color == 3) {
	  _outgtext("BLACK/WHITE MODE");
     }
     if (color == 4) {
	  _outgtext("WHITE/BLACK MODE");
     }
     if (color == 5) {
	  _outgtext("GRAY SHADES 1");
     }
     if (color == 6) {
	  _outgtext("GRAY SHADES 1 INV");
     }
     if (color == 7) {
	  _outgtext("GRAY SHADES 2");
     }
     if (color == 8) {
	  _outgtext("GRAY SHADES 2 INV");
     }
}


void dispprec(int prec)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine displays the current precision used in     ----- */
/* -----  the mandelbrot calculations.                               ----- */
/* -----                                                             ----- */
/* -----  INT prec = The current precision mode used                 ----- */
/* -----              1 = Single precision, 2 = Double precision     ----- */
/* ----------------------------------------------------------------------- */
{
     _setcolor(8);
     _rectangle(_GFILLINTERIOR,10,430,230,444);
     _setcolor(15);
     _moveto(10,430);
     if (prec == 1) {
	  _outgtext("SINGLE PRECISION");
     }
     if (prec == 2) {
	  _outgtext("DOUBLE PRECISION");
     }
}


void disprcent(double rcent)
{
/* ----------------------------------------------------------------------- */
/* -----  This subroutine displays the current real center value of  ----- */
/* -----  the viewport.                                              ----- */
/* -----                                                             ----- */
/* -----  DOUBLE rcent = Current real value of center of viewport    ----- */
/* ----------------------------------------------------------------------- */
     char number[20];

     _setcolor(8);
     _rectangle(_GFILLINTERIOR,396,415,639,429);
     _setcolor(15);
     _moveto(396,415);
     gcvt(rcent,8,number);
     _outgtext(number);
}


void dispicent(double icent)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine displays the current imagingary center     ----- */
/* -----  value of the viewport.                                     ----- */
/* -----                                                             ----- */
/* -----  DOUBLE icent = Current imaginary value of center of        ----- */
/* -----                 viewport                                    ----- */
/* ----------------------------------------------------------------------- */
{
     char number[20];

     _setcolor(8);
     _rectangle(_GFILLINTERIOR,396,429,639,444);
     _setcolor(15);
     _moveto(396,430);
     gcvt(-icent,8,number);
     _outgtext(number);
}

