/* ----------------------------------------------------------------------- */
/* -----  Define memory model to be HUGE                             ----- */
/* ----------------------------------------------------------------------- */
M_I86HM;

/* ----------------------------------------------------------------------- */
/* -----  Set include file list                                      ----- */
/* ----------------------------------------------------------------------- */
#include<graph.h>
#include<conio.h>
#include<math.h>
#include<malloc.h>
#include<stdlib.h>

/* ----------------------------------------------------------------------- */
/* -----  Set subroutine list                                        ----- */
/* ----------------------------------------------------------------------- */
void cursor(int x,int y);
void move(int _huge *cursorloc,int changex,int changey);
double changeres(double res,int flag);
double changelimit(double limit,int flag);

/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */
/* -----  MAIN PROGRAM                                               ----- */
/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */
void main()
{
     double rcent,icent,res,limit,pastres;
     int k,loop1,xref,yref,color,prec,cursoron;
     char value;
     int _huge *cursorloc;

     if ( (cursorloc = (int _huge *)halloc(2L,sizeof(int))) == NULL) {
	  printf("Insufficient memory to do anything \n");
	  exit(1);
     }

     rcent = -0.5;
     icent = 0.0;
     res = 0.0100;
     pastres = res;
     k = 15;
     limit = 1024.0;
     *(cursorloc+0) = 437;
     *(cursorloc+1) = 202;
     xref = 437;
     yref = 202;
     color = 1;
     prec = 1;
     cursoron = 1;
     loop1 = 1;

     if (_setvideomode(_VRES16COLOR) == 0) {
	  printf("Unable to enter a 16 color, 640x480 resolution graphic mode \n");
	  exit(1);
     }
     _setcolor(15);
     if (_registerfonts("courb.fon") <= 0) {
	  _setvideomode(_TEXTC80);
	  printf("Unable to find the file 'courb.fon' \n");
	  exit(1);
     }
     _setfont("t'courier'");

     initializedisplay();
     disprcent(rcent);
     dispicent(icent);
     dispres(res);
     dispk(k);
     displimit(limit);
     dispcolor(color);
     dispprec(prec);

     mandel(rcent,icent,res,k,limit,color,prec);
     pastres = res;
     *(cursorloc+0) = 437;
     *(cursorloc+1) = 202;
     xref = *(cursorloc+0);
     yref = *(cursorloc+1);
     cursor(*(cursorloc+0),*(cursorloc+1));

     /* -----  Main program loop                                     ----- */
     while (loop1 == 1) {
	  value = getch();
	  if (value == 113) loop1 = 0;
	  if (value == 105) {
	       information();
	       cursoron = 2;
	  }
	  if (value == 59) k = changek(k,2);
	  if (value == 60) k = changek(k,1);
	  if (value == 61) res = changeres(res,2);
	  if (value == 62) res = changeres(res,1);
	  if (value == 63) limit = changelimit(limit,2);
	  if (value == 64) limit = changelimit(limit,1);
	  if (value == 65) prec = changeprec(prec);
	  if (value == 66) color = changecolor(color);
	  if (value == 67) {
	       cursor(*(cursorloc+0),*(cursorloc+1));
	       if (cursoron == 1) {
		    cursoron = 2;
	       }
	       else {
		    cursoron = 1;
	       }
	  }
	  if (value == 68) {
	       mandel(rcent,icent,res,k,limit,color,prec);
	       pastres = res;
	       *(cursorloc+0) = 437;
	       *(cursorloc+1) = 202;
	       xref = *(cursorloc+0);
	       yref = *(cursorloc+1);
	       if (cursoron = 1) {
		    cursor(*(cursorloc+0),*(cursorloc+1));
	       }
	  }
	  if (value == 53) value = 76;
	  if (value == 76) {
	       rcent-=(xref-*(cursorloc+0))*pastres;
	       icent-=(yref-*(cursorloc+1))*pastres;
	       xref = *(cursorloc+0);
	       yref = *(cursorloc+1);
	       disprcent(rcent);
	       dispicent(icent);
	  }
	  if (cursoron == 1) {
	       if (value == 73) move(cursorloc, 1,-1);
	       if (value == 72) move(cursorloc, 0,-1);
	       if (value == 71) move(cursorloc,-1,-1);
	       if (value == 77) move(cursorloc, 1, 0);
	       if (value == 75) move(cursorloc,-1, 0);
	       if (value == 81) move(cursorloc, 1, 1);
	       if (value == 80) move(cursorloc, 0, 1);
	       if (value == 79) move(cursorloc,-1, 1);
	       if (value == 57) move(cursorloc, 10,-10);
	       if (value == 56) move(cursorloc,  0,-10);
	       if (value == 55) move(cursorloc,-10,-10);
	       if (value == 54) move(cursorloc, 10,  0);
	       if (value == 52) move(cursorloc,-10,  0);
	       if (value == 51) move(cursorloc, 10, 10);
	       if (value == 50) move(cursorloc,  0, 10);
	       if (value == 49) move(cursorloc,-10, 10);
	  }
     }

     _setvideomode(_TEXTC80);
     hfree(cursorloc);
}

/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */
/* -----                       SUBROUTINES                           ----- */
/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */


void cursor(int x,int y)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine either draws or removes the cursor at the  ----- */
/* -----  location (x,y).                                            ----- */
/* -----                                                             ----- */
/* -----  INT x = the x coordinate at which to draw cursor           ----- */
/* -----  INT y = the y coordinate at which to draw cursor           ----- */
/* ----------------------------------------------------------------------- */
{
     int xloc,yloc,x1,y1,x2,y2,color,temp;

     if (x-4 > 237) {
	  x1 = x-4;
     }
     else {
	  x1 = 237;
     }
     if (x+4 < 637) {
	  x2 = x+4;
     }
     else {
	  x2 = 637;
     }
     if (y-4 > 2) {
	  y1 = y-4;
     }
     else {
	  y1 = 2;
     }
     if (y+4 < 402) {
	  y2 = y+4;
     }
     else {
	  y2 = 402;
     }
     if (x1 > x2) {
	  temp = x1;
	  x1 = x2;
	  x2 = temp;
     }
     if (y1 > y2) {
	  temp = y1;
	  y1 = y2;
	  y2 = temp;
     }
     for (xloc = x1;xloc <= x2;xloc++) {
	  color = _getpixel(xloc,y);
	  if (color+8 < 16) {
	       _setcolor(color+8);
	  }
	  else {
	       _setcolor(color-8);
	  }
	  _setpixel(xloc,y);
     }
     for (yloc = y1;yloc <= y2;yloc++) {
	  color = _getpixel(x,yloc);
	  if (color+8 < 16) {
	       _setcolor(color+8);
	  }
	  else {
	       _setcolor(color-8);
	  }
	  _setpixel(x,yloc);
     }
}


void move(int _huge *cursorloc,int changex,int changey)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine moves the cursor a fixed amount in the x   ----- */
/* -----  and/or y directions.  The *cursorloc pointer is changed by ----- */
/* -----  this subroutine.                                           ----- */
/* -----                                                             ----- */
/* -----  INT _huge *cursorloc = pointer containing current x and y  ----- */
/* -----                         cursor locations                    ----- */
/* -----  INT changex          = amount to move in x direction       ----- */
/* -----  INT changey          = amount to move in y direction       ----- */
/* ----------------------------------------------------------------------- */
{
     int x,y;

     cursor(*(cursorloc+0),*(cursorloc+1));
     x = *(cursorloc+0)+changex;
     y = *(cursorloc+1)+changey;
     if (x > 637) x = 637;
     if (x < 237) x = 237;
     if (y > 402) y = 402;
     if (y < 2) y = 2;
     *(cursorloc+0) = x;
     *(cursorloc+1) = y;
     cursor(*(cursorloc+0),*(cursorloc+1));
}


double changeres(double res,int flag)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine changes the 'size' of the viewing window   ----- */
/* -----  to create an effect of zooming in or out of the Mandelbrot ----- */
/* -----  domain.                                                    ----- */
/* -----                                                             ----- */
/* -----  DOUBLE res  = The current resolution of the viewscreen     ----- */
/* -----  INT    flag = An indication of whether to zoomout (2) or   ----- */
/* -----                zoomin (1) on the current location           ----- */
/* -----                                                             ----- */
/* -----  The program passes back the new value of res               ----- */
/* ----------------------------------------------------------------------- */
{
     double temp;

     if (flag == 1) temp = res*1.25;
     if (flag == 2) temp = res*0.8;
     dispres(temp);
     return(temp);
}


double changelimit(double limit,int flag)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine changes the value of the limit placed on   ----- */
/* -----  the number of iterations to try at each point.  As the     ----- */
/* -----  limit value gets larger, the rate at which it changes gets ----- */
/* -----  larger.                                                    ----- */
/* -----                                                             ----- */
/* -----  DOUBLE limit = The value of the current limit              ----- */
/* -----                                                             ----- */
/* -----  This program passes back the new value of limit.           ----- */
/* ----------------------------------------------------------------------- */
{
     double temp;

     if (flag == 1) temp = limit*2;
     if (flag == 2) temp = limit*0.5;
     if (temp < 2.0) temp = 2.0;
     if (temp > 1048576.0) temp = 1048576.0;
     displimit(temp);
     return(temp);
}


