/* xlglobals - xlisp global variables */
/*  Copyright (c) 1985, by David Michael Betz
        All Rights Reserved
        Permission is granted for unrestricted non-commercial use   */

#include "xlisp.h"

/* symbols */
struct node isnil;

LVAL true=NULL,obarray=NULL;
LVAL s_unbound=NIL,s_dot=NULL;
LVAL s_quote=NULL,s_function=NULL;
LVAL s_bquote=NULL,s_comma=NULL,s_comat=NULL;
LVAL s_evalhook=NULL,s_applyhook=NULL,s_tracelist=NULL;
LVAL s_lambda=NULL,s_macro=NULL;
LVAL s_stdin=NULL,s_stdout=NULL,s_stderr=NULL,s_debugio=NULL,s_traceout=NULL;
LVAL s_rtable=NULL;
LVAL s_tracenable=NULL,s_tlimit=NULL,s_breakenable=NULL;
LVAL s_setf=NULL,s_car=NULL,s_cdr=NULL,s_nth=NULL,s_aref=NULL,s_get=NULL;
LVAL s_svalue=NULL,s_sfunction=NULL,s_splist=NULL;
LVAL s_eql=NULL,s_gcflag=NULL,s_gchook=NULL;
LVAL s_ifmt=NULL,s_ffmt=NULL;
#ifdef RATIOS
LVAL s_rfmt=NULL;
#endif
LVAL s_1plus=NULL,s_2plus=NULL,s_3plus=NULL;
LVAL s_1star=NULL,s_2star=NULL,s_3star=NULL;
LVAL s_minus=NULL,s_printcase=NULL;
LVAL s_printlevel=NULL, s_printlength=NULL;
LVAL s_dispmacros=NULL;
LVAL s_strtypep=NULL, s_mkstruct=NULL, s_cpystruct=NULL;
LVAL s_strref=NULL, s_strset=NULL;
LVAL s_x=NULL, s_s=NULL, s_sslots=NULL;
LVAL s_elt = NULL;
LVAL a_list=NULL, a_number=NULL, a_null=NULL, a_atom=NULL, a_anystream=NULL;
LVAL s_and=NULL, s_or=NULL, s_not=NULL, s_satisfies=NULL, s_member=NULL;
LVAL a_struct = NULL;
#ifdef DOSINPUT
LVAL s_dosinput=NULL;
#endif
#ifdef HASHFCNS
LVAL s_gethash = NULL, a_hashtable = NULL;
#endif
#ifdef COMPLX
LVAL a_complex = NULL;
#endif
#ifdef RANDOM
LVAL s_randomstate=NULL, a_randomstate=NULL;
#endif
#ifdef READTABLECASE
LVAL s_rtcase=NULL;
#endif


/* keywords */
LVAL k_test=NULL,k_tnot=NULL;
LVAL k_wspace=NULL,k_const=NULL,k_nmacro=NULL,k_tmacro=NULL;
LVAL k_sescape=NULL,k_mescape=NULL;
LVAL k_direction=NULL,k_input=NULL,k_output=NULL;
LVAL k_start=NULL,k_end=NULL,k_1start=NULL,k_1end=NULL;
LVAL k_2start=NULL,k_2end=NULL,k_count=NULL;
LVAL k_verbose=NULL,k_print=NULL;
LVAL k_upcase=NULL,k_downcase=NULL;
LVAL k_io=NULL, k_elementtype=NULL;
LVAL s_termio=NULL, k_exist=NULL, k_nexist=NULL, k_error=NULL;
LVAL k_rename=NULL, k_newversion=NULL, k_overwrite=NULL, k_append=NULL;
LVAL k_supersede=NULL, k_rendel=NULL, k_probe=NULL, k_create=NULL;
LVAL k_concname=NULL, k_include=NULL;
#ifdef REDUCE
LVAL k_ivalue=NULL;
#endif
#ifdef KEYARG
LVAL k_key=NULL;
#endif
#ifdef HASHFCNS
LVAL k_size = NULL;
#endif
#ifdef RANDOM
LVAL k_data=NULL;
#endif
#ifdef READTABLECASE
LVAL k_preserve=NULL,k_invert=NULL;
#endif


/* lambda list keywords */
LVAL lk_optional=NULL,lk_rest=NULL,lk_key=NULL,lk_aux=NULL;
LVAL lk_allow_other_keys=NULL;

/* type names */
LVAL a_subr=NULL,a_fsubr=NULL;
LVAL a_cons=NULL,a_symbol=NULL,a_fixnum=NULL,a_flonum=NULL;
LVAL a_string=NULL,a_object=NULL,a_stream=NULL,a_vector=NULL;
LVAL a_closure=NULL,a_char=NULL,a_ustream=NULL;
#ifdef RATIOS
LVAL a_ratio=NULL;
LVAL a_rational=NULL;
#endif

/* evaluation variables */
LVAL * XNEAR xlstkbase[EDEPTH];
LVAL * XNEAR *xlstack = NULL;
LVAL xlenv=NULL,xlfenv=NULL,xldenv=NULL;

/* argument stack */
LVAL XNEAR xlargstkbase[ADEPTH]; /* argument stack */
LVAL XNEAR *xlfp = NULL;         /* argument frame pointer */
LVAL XNEAR *xlsp = NULL;         /* argument stack pointer */
LVAL XNEAR *xlargv = NULL;       /* current argument vector */
int xlargc = 0;         /* current argument count */

/* exception handling variables */
CONTEXT *xlcontext = NULL;  /* current exception handler */
CONTEXT *xltarget = NULL;   /* target context (for xljump) */
LVAL xlvalue=NULL;      /* exception value (for xljump) */
int xlmask=0;           /* exception type (for xljump) */

/* debugging variables */
int xldebug = 0;        /* debug level */
int xlsample = 0;       /* control character sample rate */
int xltrcindent = 0;        /* trace indent level */

/* gensym variables */
char gsprefix[STRMAX+1] = { 'G',0 };    /* gensym prefix string */
FIXTYPE gsnumber = 1;       /* gensym number */

/* i/o variables */
int xlfsize = 0;        /* flat size of current print call */
FILEP tfp = CLOSED;     /* transcript file pointer */

/* general purpose string buffer */
char buf[STRMAX+1] = { 0 };

#ifdef FILETABLE
FILETABLETYPE filetab[FTABSIZE] =
{{stdin,"(stdin)"},
 {stdout,"(stdout)"},
 {stderr,"(console)"},
 {0,""}};
#endif
/* $putpatch.c$: "MODULE_XLGLOB_C_GLOBALS" */
