{@#PtGen1.2, English, Help#@}
{@#help.txt#@}
{ Created : 1993-05-29

Last changes :
}


{$X+,F+,O+,R-,Q-,V-,S-,I-,L-,D-}
unit SQLXPLMN;
{@#Application SqlXplApp#@}

interface

{@#Stage InterfaceUses#@}
uses Objects, Drivers, Views, Menus, Dialogs, App, BBDlg, PreApp;

{@#Stage InterfaceConst#@}
const
{@#SqlXplApp#@}
  cmAbout = 2000;
  cmTranslate = 2001;
  cmOpenTranslateDlg = 2002;
  cmClear = 2003;


{@#Help#@}
  hcNoContext = 0;
  hcOK = 1991;
  hcCancel = 1992;
  hcYes = 1993;
  hcNo = 1994;
  hcZoekRecord = 1995;
  hcWijzigRecord = 1996;
  hcNieuwRecord = 1997;
  hcVerwijderRecord = 1998;
  hcExitRecord = 1999;
  hcH2000 = 2000;
  hcAbout = 2001;
  hcH2002 = 2002;
  hcH2003 = 2003;
  hcH2004 = 2004;
  hcOpenTranslateDlg = 2005;
  hcH2006 = 2006;

{@#Stage InterfaceType#@}
type
  PAboutDlg = ^TAboutDlg;
  TAboutDlg = object(TDialog)
    constructor Init;
  end;

  PXplainStatementDlg = ^TXplainStatementDlg;
  TXplainStatementDlg = object(TDialog)
    constructor Init;
  end;

{@#tvDialog 1001#@}
  TXplainStatementDlgRec = record
    Statement : record  Length : word; Buffer : array[0..4096] of char;  end;
  end;


{@#SqlXplApp#@}
  PSqlXplApp = ^TSqlXplApp;
  TSqlXplApp = object(TPreApp)
    constructor Init;
    procedure InitMenuBar;  virtual;
    procedure InitStatusLine;  virtual;
    procedure HandleEvent(var Event : TEvent);  virtual;
  end;



implementation

{@#Stage ImplementationUses#@}
uses BBUtil, Editors, BBStrRes;


{@#Stage ImplementationType#@}
type
  zzzzzzz = byte;     {* only a dummy *}

{@#Stage ImplementationCode#@}

{@#tvDialog 1000#@}
constructor TAboutDlg.Init;
var
  R : TRect;
  P : PView;
begin
  R.Assign(12,2, 65,16);
  inherited Init(R, 'About');
  Options := Options or (ofCenterX + ofCenterY);
  HelpCtx := 2002;
  R.Assign(2,2, 51,7);
  Insert(New(PStaticText, Init(R, ''#3'SQL Explainer 1.00'#13''#13''#3'A progra' +
    'm to convert Xplain statements to SQL'#13''#13''#3'(c) 1993 by Berend d' +
    'e Boer and Ronald Breedveld')));
  R.Assign(21,10, 31,12);
  P := New(PButton, Init(R, 'O~K~', cmOK, bfDefault));
  P^.HelpCtx := hcOK;
  Insert(P);
  SelectNext(FALSE);
end;
{@#tvDialog#@}


{@#tvDialog 1001#@}
constructor TXplainStatementDlg.Init;
var
  R : TRect;
  P : PView;
  HScrollBar, VScrollBar : PScrollBar;
begin
  R.Assign(10,3, 65,16);
  inherited Init(R, 'Xplain statement');
  Options := Options or (ofCenterX + ofCenterY);
  HelpCtx := hcNoContext;
  R.Assign(2,7, 52,8);
  HScrollBar := New(PScrollBar, Init(R));
  Insert(HScrollBar);
  R.Assign(52,3, 53,7);
  VScrollBar := New(PScrollBar, Init(R));
  Insert(VScrollBar);
  R.Assign(2,3, 52,7);
  P := New(PMemo, Init(R, HScrollBar, VScrollBar, nil, 4096));
  P^.HelpCtx := 2003;
  Insert(P);
  R.Assign(1,2, 12,3);
  Insert(New(PLabel, Init(R, '~S~tatement', Current)));
  R.Assign(11,10, 26,12);
  P := New(PButton, Init(R, '~T~ranslate', cmTranslate, bfDefault));
  P^.HelpCtx := 2004;
  Insert(P);
  R.Assign(32,10, 45,12);
  P := New(PButton, Init(R, '~C~lear', cmClear, bfNormal));
  P^.HelpCtx := 2006;
  Insert(P);
  SelectNext(FALSE);
end;
{@#tvDialog#@}




{@#SqlXplApp#@}
constructor TSqlXplApp.Init;
begin
  HFileName := 'help.HLP';
  TPreApp.Init;
end;

procedure TSqlXplApp.InitMenuBar;
var
  R : TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~~', 2000, NewMenu(
      NewItem('~A~bout...', '', kbNoKey, cmAbout, hcAbout,
      nil)),
    NewItem('~T~ranslate', '', kbNoKey, cmOpenTranslateDlg, hcOpenTranslateDlg,
    nil))
  )));
end;

procedure TSqlXplApp.InitStatusLine;
var
  R : TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PPreAppStatusLine, Init(R,
    NewStatusDef(0, 1990,
      NewStatusKey('~F1~ Help', kbF1, cmHelp,
      NewStatusKey('~F10~ Menu', kbF10, cmMenu,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      nil))),
    NewStatusDef(1991, 3000,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('~F1~ Help', kbF1, cmHelp,
      NewStatusKey('', kbAltF3, cmClose,
      NewStatusKey('', kbAltX, cmQuit,
      nil)))),
    nil))
  ));
end;

procedure TSqlXplApp.HandleEvent (var Event : TEvent);
{@#cmAbout#@}
{@#tvDialog 1000#@}
begin
  TApplication.HandleEvent(Event);
  if Event.What and evCommand <> 0 then  begin
    case Event.Command of
      cmAbout : ExecDialog(New(PAboutDlg, Init), nil);
    else  Exit;
    end;  { of case }
    ClearEvent(Event);
  end;
end;
{@#SqlXplApp#@}


end.  { of SQLXPLMN }
