//
// regx.cpp     : Define implementation for regular expression class
// Author       : Roy S. Woll
//
// Copyright (c) 1993 by Roy S. Woll
// You may distribute this source freely as long as you leave all files
// in their original form, including the copyright notice as is.
//
//
// Version 2.1      12/10/92
//    Add copy constructor
//
// Version 2.00     11/31/92
//    Define class for regular expressions.
//

#include <iostream.h>
#include <limits.h>
#include <string.h>
#include "regX.h"
#include "regximp.h"

regXimp::regXimp(void):compiledPattern(256){
   error = 1;
   caseSensitive=1;
   startMatch=endMatch=0;
};


regX::regX(void):imp(new regXimp()){};

regX::regX(const regX& r):imp(new regXimp())
{
   *imp = *r.imp;
};

regX::regX(const char * regexp):imp(new regXimp())
{
   imp->makepat(regexp);
};

regX::~regX(void){ delete imp;};

regX& regX::operator=(const char * regexp){
   return *this = regX(regexp);
};

regX& regX::operator=(const regX& r){
   *imp = *r.imp;
   return *this;
};


int regX::index(const char * s, int * matchLenPtr, int start,
                    int p_caseSensitive) const
{
   if (error()) return -1;

   if ( imp->matchs(s+start, p_caseSensitive) ){
      *matchLenPtr = imp->endMatch - imp->startMatch +1;
      return imp->startMatch - s;
   }
   else {
      *matchLenPtr = 0;
      return -1;
   };
};

int regX::error(void) const{ return imp->error; };


int str::index(const regX& reg, int start) const{
   int matchlen;
   return reg.index(*this, &matchlen, start, caseSensitive());
};


int str::index(const regX& reg, int * matchLen, int start) const
{
   return reg.index(*this, matchLen, start, caseSensitive());
};

int str::search(const regX& reg, int * startPtr) const{
   return search(reg, 0, startPtr);
};

int str::search(const regX& reg, int start) const{
   return search(reg, 0, &start);
};

int str::search(const regX& reg, str * matchPtr, int start) const{
   return search(reg, matchPtr, &start);
};

int str::search(const regX& reg, str * matchPtr, int * startPtr) const{

   int matchLen;
   int start = reg.index(*this, &matchLen, *startPtr, caseSensitive());
   if (start>=0) {
      if (matchPtr) *matchPtr = operator()(start, matchLen);
      if (startPtr) *startPtr = start;
      return 1;
   }
   else {
      if (matchPtr) *matchPtr = "";
      if (startPtr) *startPtr = -1;
      return 0;
   };

};


int str::replace(const regX& reg, const char* replaceStr,
                 int start, int numReplacements)
{
  return replace(reg, replaceStr, &start, numReplacements);
};

int str::replace(const regX& reg, const char* replaceStr,
                 int* startPtr, int numReplacements)
{
   int& start = *startPtr;
   if (numReplacements==0) return 0;

   int countReplacements=0, matchLen;
   int replaceLen = strlen(replaceStr);

   do {
      start = index(reg, &matchLen, start);
      if (start<0) break;
      countReplacements++;
      operator()(start, matchLen) = replaceStr;
      start+= replaceLen;           //skip past newly added data

      if (!--numReplacements) break;
   } while (1);

   return countReplacements;

};

int str::replaceAll(const regX& reg, const char* replaceStr, int start)
{
  return replace(reg, replaceStr, &start, INT_MAX);
};



