//
// strsearch.cpp: str class member functions for searching and replacing
// Author       : Roy S. Woll
//
// Copyright (c) 1993 by Roy S. Woll
// You may distribute this source freely as long as you leave all files
// in their original form, including the copyright notice as is.
//
//
// Version 2.2      5/5/93
//    Fix bug in index relating to case sensitivity (backwards)
//
// Version 2.00     11/31/92
//    Support searching/replacing, regular expressions, case sensitivity
//

#include <string.h>
#include <limits.h>

#include "str.h"
//#include "regx.h"


// 
// index member functions
//
int str::index(const char * s, int start) const{
   if (!caseSensitive()){
      str mylowstr(::lowercase(*this));
      const char * charptr = strstr(mylowstr(start), ::lowercase(s));
      if (charptr) return (charptr - mylowstr());
      else return (-1);
   }
   else {
      const char * charptr = strstr((*this)(start), s);
      if (charptr) return (charptr - data->buf);
      else return (-1);
   }
};


//
// search operator functions
//

int str::search(const char * s, int* startPtr) const{
   *startPtr = index(s, *startPtr);
   return *startPtr>=0;
};

int str::search(const char * s, int start) const{
   return index(s, start)>=0;
};


int str::replace(const char * searchStr, const char* replaceStr,
                 int start, int numReplacements)
{
  return replace(searchStr, replaceStr, &start, numReplacements);
};

int str::replace(const char * searchStr, const char* replaceStr,
                 int* startPtr, int numReplacements)
{

   if (numReplacements==0) return 0;

   int& start = *startPtr;
   int countReplacements=0;
   int searchLen = strlen(searchStr), replaceLen = strlen(replaceStr);

   do {

      start = index(searchStr, start);
      if (start<0) break;
      countReplacements++;
      operator()(start, searchLen) = replaceStr;
      start+= replaceLen;           //skip past newly added data

      if (!--numReplacements) break;

   } while (1);

   return countReplacements;

};


int str::replaceAll(const char * searchStr, const char* replaceStr, int start)
{
  return replace(searchStr, replaceStr, &start, INT_MAX);
};

