//
// tokens.cpp : tokens class implementation
// Author     : Roy S. Woll
//
// Copyright (c) 1993 by Roy S. Woll
// You may distribute this source freely as long as you leave all files
// in their original form, including the copyright notice as is.
//
//
// Version 1.00     2/1/93
//
//  Implementation file for class tokens.  Tokens will break up
//  a character buffer into one or more tokens, where the delimeters are 
//  specified by the user.
//

#include <tokens.h>
#include <str.h>
#include <minmax.h>
#include <string.h>

   int tokens::_gettoken(int& pos){
      if ((*curtoken)==0) return 0;
      char temp;

      int delimeters = strspn(curtoken, delimptr); 
      if (skipRepeatingDelimeters) curtoken += delimeters;
      else if (delimeters) if (!firstTime) curtoken++;

      firstTime = 0;

      if (endingpos) {// Force strcspn to not exceed endingpos
         if ((curtoken-alltokens)>endingpos) return 0;
         temp = alltokens[endingpos+1];
         alltokens[endingpos+1]=0;
      };

      pos = strcspn(curtoken, delimptr);

      if (endingpos) {alltokens[endingpos+1]=temp;};
      return 1;
   };


//
// Create a token parser
//     break p_tokens into tokens defined by a delimeter set p_delim
//     Only search up to p_endingpos
//
   tokens::tokens(const char * p_tokens,
          const char * p_delim, int p_endingpos){
      delimptr = (char *)p_delim;
      curtoken = alltokens = (char *)p_tokens;
      endingpos = p_endingpos;
      skipRepeatingDelimeters = 1;
      firstTime = 1;
   };


   int tokens::getToken(char * word, int maxlen){
      int pos;
      if (_gettoken(pos)) {
                        pos = min(pos, maxlen);
         strncpy(word, curtoken, pos);
         word[pos]=0;
         curtoken += pos;

         return 1;

      }
      else return 0;
   };

   int tokens::getToken(str * word){
      int pos;
      if (_gettoken(pos)) {
         word->assign(curtoken, pos); // assign word
         curtoken += pos;

         return 1;
      }
      else return 0;
   };



