// Persistence of Vision Raytracer
// Shape Test file

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

camera {
   location <0.0 -8.0  1.0>
   direction <0.0 1.0  0.0>
   up  <0.0  0.0  1.0>
   right <1.33333 0.0 0.0>
}

object {
   plane {<0.0 0.0 1.0> -10.0 }
   colour White
   texture {
      colour SeaGreen
      ambient 0.2
      diffuse 0.8
   }
}

//Include Shape to be tested
#include "coil.inc"

object {
   coil
   rotate <45.0 0.0 0.0>
}

//Light Source
object {
   light_source { <10.0 -50.0 1000.0>
      colour White
   }
}
