	.file	"acbg.s"
/*======================================================================*
 *
 * ACBG.S
 *
 *======================================================================*
 * AckCopyBackGround routine originally in ACKASM.ASM
 * Written by Lary Myers
 * Modified for GNU assembler by k.graham.
 *======================================================================*/

.text

/*======================================================================*
 * AckCopyBackground(UCHAR far *scrn, UCHAR far *bkgd, int len, int off);
 *======================================================================*/
.equ	ACBscrn,  8                     /* offsets for arguments        */
.equ	ACBbkgd, 12
.equ	ACBlen,  16
.equ	ACBoff,  20

        .align 2
.global _AckCopyBackground

_AckCopyBackground:
	pushl	%ebp                    /* build stack frame            */
	movl	%esp, %ebp
	pushl   %esi
	pushl   %edi

/*----------------------------------------------------------------------*
 * Quickly transfer the pre-built background ceiling and floor 
 * to the screen.
 *----------------------------------------------------------------------*/
        movl    ACBscrn(%ebp), %edi     /* get destination address      */
	addl    ACBoff(%ebp), %edi      /* add offset                   */
	movl    ACBlen(%ebp), %ecx      /* Number of DWORDS to move     */
        movl    ACBbkgd(%ebp), %esi     /* Pre-built buffer             */
        rep
        movsl

	popl    %edi
	popl    %esi

        leave
	ret
