/******************* ( Animation Construction Kit 3D ) **************
 *            Deluxe Paint file reader                              *
 * CopyRight (c) 1993  Authors: Jaimi McEntire, Lary Myers          *
 ********************************************************************
 * modified for GNU C 2/17/94 kgraham
 *
 * This function will return a pointer to a buffer that holds the
 * raw image. Just free the pointer to delete this buffer. After 
 * returning, the array colordat will hold the adjusted palette of
 * this pic.
 *
 * Also, this has been modified to only read in form PBM brushes. 
 * Form ILBM's (the "old" type) are not supported. use the "new" 
 * deluxe paint .lbm type and do not choose "old".
 *
 ********************************************************************/

#include <stdio.h>
#include <conio.h>
#include <process.h>
#include <bios.h>
#include <fcntl.h>
#include <malloc.h>
#include <memory.h>
#include "ack3d.h"
#include "ackeng.h"
#include "ackext.h"
#include "iff.h"


UCHAR colordat[768];            /* maximum it can be...256 colors       */

UCHAR cplanes[8][80];           /* setting max at 640 pixels width      */
                                /* thats 8 pixels per byte per plane    */
UCHAR *pplanes=(char *) &cplanes[0][0];             /* for a form pbm   */

UCHAR *AckReadiff(char *picname)
{
    int         sofar;
    int         height;
    char        value;      /* must remain signed, no matter what.      */
                            /* ignore any warnings.                     */
    FILE       *pic;
    UCHAR      *destx;
    UCHAR      *savedestx;
    form_chunk  fchunk;
    ChunkHeader chunk;
    BitMapHeader bmhd;

    if ((pic = fopen(picname,"r+b"))== NULL) {
        ErrorCode = ERR_BADPICNAME;
        return(0L);
    }

    fread(&fchunk,1,sizeof(form_chunk),pic); /* read in the first 12 bytes*/

    if (fchunk.type != FORM) {
        fclose(pic);
        ErrorCode = ERR_INVALIDFORM;
        return(0L);
    }

    if (fchunk.subtype != ID_PBM) {
        printf("Error: Not form PBM!");
        fclose(pic);
        ErrorCode = ERR_NOPBM;
        return(0L);
    }
   /* now lets loop...Because the Chunks can be in any order! */
    while(1) {
        fread(&chunk,1,sizeof(ChunkHeader),pic);
        ByteFlipLong((long *)(&chunk.ckSize));
        if (chunk.ckSize & 1) {
            chunk.ckSize++;     /* must be word aligned   */
        }
        if (chunk.ckID == ID_BMHD) {
            fread(&bmhd,1,sizeof(BitMapHeader),pic);
#if !defined(GNU)
            bmhd.w = SWAB(bmhd.w);          /* the only things we need. */
            bmhd.h = SWAB(bmhd.h);
#else
            SWAB(bmhd.w);                   /* the only things we need. */
            SWAB(bmhd.h);
#endif
            destx = (UCHAR *)malloc((bmhd.w * bmhd.h)+4);
            if ( !destx ) {
                fclose(pic);
                ErrorCode = ERR_NOMEMORY;
                return(0L);
            }

            savedestx = destx;

            destx[0] = (UCHAR)bmhd.w%256;
            destx[1] = (UCHAR)bmhd.w/256;
            destx[2] = (UCHAR)bmhd.h%256;
            destx[3] = (UCHAR)bmhd.h/256;
            destx += 4;
            continue;
        }
        if (chunk.ckID == ID_CMAP) {
            int     i;
            UCHAR   r;
            UCHAR   g;

            fread(colordat,1,(size_t)chunk.ckSize,pic);
            for (i=0;i<768;i++) {
                r = colordat[i];      /* r,g do not stand for red and green */
                g = r >> 2;
                colordat[i] = g;
            }
            continue;
        }
        if (chunk.ckID == ID_BODY) {
            for(height = 0; (UWORD)height<bmhd.h; height ++) {
                UCHAR *dest;
                dest = (UCHAR *)&(pplanes[0]); /* point at first char  */
                sofar = bmhd.w;                /* number of bytes = 8  */
                if (sofar&1) {
                    sofar++;
                }
                while (sofar) {
                    if (bmhd.compression) {
                        value=fgetc(pic);      /* get the next byte      */
                        if (value > 0) {
                            int len;
                            len = value +1;
                            sofar -= len;
                            if (!(fread(dest,len,1,pic))) {
                                fclose(pic);
                                ErrorCode = ERR_BADPICFILE;
                                free(savedestx);
                                return(0L);
                            }
                            dest +=len;
                        }
                        else {
                            int count;
                            count = -value; /* get amount to dup */
                            count++;
                            sofar -= count;
                            value = fgetc(pic);
                            while (--count >= 0) {
                                *dest++ = value;
                            }
                        }
                    }
                    else {
                        fread(dest,sofar,1,pic); /* just throw on plane */
                        sofar = 0;
                    }
                }
                if (sofar < 0) {
                    fclose(pic);
                }
                memcpy(destx,pplanes,bmhd.w);
                destx += bmhd.w;
            }
            break; /* leave if we've unpacked the BODY*/
        }
        fseek(pic,chunk.ckSize,SEEK_CUR);
    }

    fclose(pic);
    return((char  *)savedestx);
}

/******************************************
void ByteFlipLong(long *NUMBER)
{
    long    Y;
    long    T;
    int     I;

    T = *NUMBER;
    Y =  0;
    for (I=0;I<4;I++){
        Y = Y | (T & 0xFF);
        if (I<3) {
            Y = Y << 8;
            T = T >> 8;
        }
    }
    *NUMBER = Y;
}
******************************************/

/*=======================================*
 |                                       |
 | Revised ByteFlipLong                  |
 |                                       |
 +---------------------------------------+
 | Revised: 2/18/94 kgraham              |
 |                                       |
 | this is about 2x previous version     |
 |                                       |
 *=======================================*/
void ByteFlipLong(long *NUMBER)
{
    int     i;
    char    b[4];
    char   *ptr = (char *)NUMBER;

    b[3] = *ptr++;
    b[2] = *ptr++;
    b[1] = *ptr++;
    b[0] = *ptr++;
    memcpy(NUMBER, b, 4);
}

#if !defined(GNU)
 int swab(unsigned short number)
 {
   UINT     xx1;
   UINT     xx2;
   UINT     result;

   xx1 = number <<8;
   xx2 = number >>8;
   result = xx1|xx2;
   return(result);
 }
#endif
