/*=========================================================*
 |                                                         |
 | ACKPCX.H                                                |
 |                                                         |
 *=========================================================*
 | PCX Graphics File Format header and info.               |
 *=========================================================*
 | Copyright (c) 1991,1994 kgraham  All Rights Reserved    |
 | These routines are being included with the ACK 3D       |
 | Construction Kit and are subject to the licensing       |
 | restrictions of said software.                          |
 *=========================================================*
 |                                                         |
 | Based on information from the ZSOFT technical reference |
 | manual and Microsoft Windows File Formats               |
 |                                                         |
 *=========================================================*/
#if !defined(_ACKPCX_H_)
#define _ACKPCX_H_ 1

#define     VERSION25   0       /* Version 2.5 of PC Paintbrush     */
#define     VERSION28P  2       /* Version 2.8 with palette info    */
#define     VERSION28   3       /* Version 2.8 w/o palette info     */
#define     VERSIONPP   4       /* PC Paintbrush for Windows 2.x    */
#define     VERSION30   5       /* Version 3.0                      */

#define     PCXFLAG     0x0A    /* PCX file flag (1st byte)         */
#define     PALFLAG     0x0C    /* Extended palette marker          */

typedef struct {
    UCHAR    red;
    UCHAR    green;
    UCHAR    blue;
} TRIPLET;

#define RESERVED    (128-74)    /* number of bytes in unused area   */

typedef struct {
    UCHAR   pcxflag;            /* 0    */      /* typically 0x0A   */
    UCHAR   version;            /* 1    */      /* see defs above   */
    UCHAR   encoding;           /* 2    */      /* 0=no 1=yes(RLE)  */
    UCHAR   bitsperpixel;       /* 3    */
    USHORT  x1;                 /* 4    */      /* upper left x     */
    USHORT  y1;                 /* 6    */      /* upper left y     */
    USHORT  x2;                 /* 8    */      /* lower right x    */
    USHORT  y2;                 /* 10   */      /* lower right y    */
    USHORT  hres;               /* 12   */
    USHORT  vres;               /* 14   */
    TRIPLET triple[16];         /* 16   */      /* palette          */
    UCHAR   videomode;          /* 64   */      /* no longer used   */
    UCHAR   nplanes;            /* 65   */      /* # color planes   */
    USHORT  bytesperline;       /* 66   */
    USHORT  palinfo;            /* 68   */      /* 1=color/mono     */
                                                /* 2=grey scale     */
    USHORT  hscreensize;        /* 70   */      /* optional         */
    USHORT  vscreensize;        /* 72   */      /* optional         */

    UCHAR   __unused[RESERVED]; /* 74   */
} PCXHDR;

typedef struct {
    UCHAR      ext_palette;            /* must be 0x0C for valid palette    */
    TRIPLET    triple[256];
} PCX256PALETTE;

#endif
