/************************************************************
 *                                                          *
 * ackrdini.c                                               *
 *                                                          *
 +----------------------------------------------------------+
 * Routines for reading Microsoft Windows style .INI files  *
 +----------------------------------------------------------+
 * Copyright (c) 1994 kgraham, All Rights Reserved          *
 *                                                          *
 * This file and it's accompanying .H file are released     *
 * as part of the ACK3D Construction Set. Use for any       *
 * other commercial purpose is prohibited without the       *
 * author's permission. See ACK3D.DOC for information       *
 * on contacting the author.                                *
 +----------------------------------------------------------+
 * History:                                                 *
 *   1.0 02/13/94 Initial Version                           *
 *   1.1 03/25/94 Rebuilt for inclusion as part of ACK3D    *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include <string.h>
#include "ackrdini.h"

/*
 * Read Windows style .INI format files for resource definitions
 *
 * The format of the .INI file is as follows:
 * [appname]        -- the application name or name for this section
 * key=             -- a key string being searched for
 * ;Comment         -- a ; denotes a comment
 */
int GetPrivateProfileString(char *appname, char *key, char *deflt, char *ret, int size, char *filename)
{
    FILE    *fp;
    char    buffer[80];
    char    tbuff2[80];
    char    tbuff[80];
    char   *tptr1 = buffer;
    char   *tptr2 = tbuff2;

    if ((fp = fopen(filename, "r")) == NULL) {
        strncpy(ret, deflt, size);
        return(strlen(ret));
    }
    sprintf(tbuff, "[%s]", strupr(appname));
    do {
        if (fgets(buffer, 80, fp) == NULL) {
            strncpy(ret, deflt, size);
            return(strlen(ret));
        }
    } while (strncmp(tbuff, strupr(buffer), strlen(tbuff)));

    sprintf(tbuff, "%s", strupr(key));
    do {
        if (fgets(buffer, 80, fp) == NULL) {
            strncpy(ret, deflt, size);
            return(strlen(ret));
        }
        buffer[strlen(buffer)-1] = '\0';  /* kill the LF  */
        tptr1 = buffer;
        tptr2 = tbuff2;
        while (*tptr1 == ' ') {
            tptr1++;
        }
        while (*tptr1 != ' ' && *tptr1 != '=') {
            *tptr2++ = *tptr1++;
        }
        *tptr2 = '\0';
    } while (strncmp(tbuff, strupr(tbuff2), strlen(tbuff)));
    while (*tptr1 != '=') {
        tptr1++;
    }
    tptr1++;
    while (*tptr1 == ' ') {
        tptr1++;
    }
    strncpy(ret, tptr1, size);
    return(strlen(ret));
}
