/******************* ( Animation Construction Kit 3D ) **********************
 *                          Utility Routines                                *
 * CopyRight (c) 1993   Author: Lary Myers                                  *
 *                  GNU C Mods: Ken Graham                                  *
 ****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <memory.h>
#include <malloc.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <sys\stat.h>
#include "ack3d.h"
#include "ackeng.h"
#include "ackext.h"

/****************************************************************************
** Return the square root of a long value                                  **
****************************************************************************/
long long_sqrt(long v)
{
    int		i;
    unsigned	long result,tmp;
    unsigned	long low,high;

    if (v <= 1L) {
        return((unsigned)v);
    }

    low = v;
    high = 0L;
    result = 0;

    for (i = 0; i < 16; i++) {
        result += result;
        high = (high << 2) | ((low >>30) & 0x3);
        low <<= 2;

        tmp = result + result + 1;
        if (high >= tmp) {
        	result++;
        	high -= tmp;
    	}
    }

    if (v - (result * result) >= (result - 1)) {
        result++;
    }

    return(result);
}


/****************************************************************************
** The application can use this routine to read in a 768 byte palette	   **
** file and immediately set it in the video. PalName is the name of the	   **
** palette file to load.                                                   **
**                                                                         **
****************************************************************************/
int AckLoadAndSetPalette(char *PalName)
{
    int	    handle;
    int     ErrCode;
    char   *buf;

    buf = malloc(800);
    if (buf == NULL) {
        return(ERR_NOMEMORY);
    }

    ErrCode = 0;
    if ((handle = open(PalName,O_RDWR|O_BINARY)) > 0) {
        read(handle,buf,768);
        close(handle);
        AckSetPalette(buf);
    }
    else {
        ErrCode = ERR_BADFILE;
    }

    free(buf);
    return(ErrCode);
}

/****************************************************************************
** The application calls this routine to get the last object hit (from the **
** AckMovePOV() or AckMoveObjectPOV() routines.                            **
**                                                                         **
****************************************************************************/
int AckGetObjectHit(void)
{
    return(LastObjectHit);
}

/****************************************************************************
** The application calls this routine to get the last wall hit (from the   **
** AckMovePOV() or AckMoveObjectPOV() routines.                            **
**                                                                         **
****************************************************************************/
int AckGetWallHit(void)
{
    return(LastMapPosn);
}

/****************************************************************************
** The application calls this routine to make an object invisible. The	   **
** object and object bitmaps are NOT deleted. Currently the active flag	   **
** is set to zero however, future versions may do more in the routine so   **
** it would be a good idea for the application to call here instead of	   **
** setting the active flag to zero on its own.                             **
**                                                                         **
****************************************************************************/
int AckDeleteObject(ACKENG *ae, int ObjIndex)
{

    if (!ae->ObjList[ObjIndex].Active) {
        return(-1);
    }

    ae->ObjList[ObjIndex].Active = 0;

    return(0);
}

/****************************************************************************
** The purpose of this routine is to replace an existing bitmap with a	   **
** new one. The old bitmap is freed and the new one is put into place in   **
** the specified bitmap array.                                             **
**                                                                         **
** index is the number of the bitmap array to replace                      **
** Maps is the bitmap array                                                **
** NewBitmap is a pointer to the new bitmap to use                         **
**                                                                         **
****************************************************************************/
int AckSetNewBitmap(int index, UCHAR **Maps, UCHAR *NewBitmap)
{
    int     i;
    UCHAR  *bPtr;

    bPtr = Maps[index];
    if (bPtr == NewBitmap) {
        return(0);
    }

    free(bPtr);
    Maps[index] = NewBitmap;
    return(0);
}


/****************************************************************************
** This routine should be called for all wall and object bitmaps when using**
** XMS memory. It will copy the bitmap from XMS to a real memory array	   **
** buffer which is then passed back to the caller. It checks for a buffer  **
** that has the smallest usage count (an empty one would have zero), to	   **
** copy the XMS memory into. XMS handles have been observed to have a seg  **
** value of > A000H or < 100H (which hopefully will be true all the time!) **
**                                                                         **
** Note: XMS part has been removed. Function kept for compatibility. kag   **
****************************************************************************/
UCHAR *AckGetBitmapPtr(int index, UCHAR far **Maps)
{
    return(Maps[index]);
}

/****************************************************************************
** This routine loads an XMS bitmap into memory for use by the app. If the **
** bitmap is not in XMS then the bitmap pointer itself is returned.        **
**                                                                         **
** Note: XMS part has been removed. Function kept for compatibility. kag   **
****************************************************************************/
UCHAR *AckLockPtr(UCHAR *bPtr)
{
    return(bPtr);
}


/****************************************************************************
** This routine frees up a previously locked pointer. If the pointer is	   **
** not in XMS then no action is taken.                                     **
**                                                                         **
** Note: XMS part has been removed. Function kept for compatibility. kag   **
****************************************************************************/
int AckUnlockPtr(UCHAR *bPtr)
{
    return(0);
}

/****************************************************************************
** This routine creates a new bitmap buffer (in real or XMS memory) and	   **
** copies the supplied bitmap into it. The return pointer is either an	   **
** XMS handle or a pointer to the real memory.                             **
**                                                                         **
** Note: XMS part has been removed. Function kept for compatibility. kag   **
****************************************************************************/
UCHAR *AckCopyNewBitmap(UCHAR *bPtr)
{
    UCHAR   *bmp;
    
    if ((bmp = malloc(BITMAP_SIZE)) != NULL) {
    	memmove(bmp,bPtr,BITMAP_SIZE);
    }
    return(bmp);
}

/****************************************************************************
** This routine frees the memory used by a bitmap in either real or XMS	   **
** memory.                                                                 **
**                                                                         **
** Note: XMS part has been removed. Function kept for compatibility. kag   **
****************************************************************************/
int AckFreeBitmap(UCHAR *Bmp)
{
    free(Bmp);
    return(0);
}

