//ͻ
//                                                                          
//                                                                 
//                                                            
//                                                                  
//                                                                
//                                                                
//                             2.2                  
//                                                                         
//                                 
//                                                                         
//                                                                          
//                                                                          
//                                                     Copyright (C) 1993:  
//                                                     BASIC d.o.o.         
//                                                     Jesenkova 5          
//                                                     SLO-61000 Ljubljana  
//                                                       
//                                                                          
//                                                                          
//                                                                          
//ͼ
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include <stdarg.h>
#include "adslib.h"
#include "adsdlg.h"
//
//
#undef X
#undef Y
#undef Z
#undef T
#define SymExp MemoryCell *
#define StrExp char *

//
typedef enum {
    l2cFalse,
    l2cTrue
} _Boolean;

//Ŀ
//  Here are supported types:                                               
//
typedef enum {
    cCons,
    cNumber,
    cReal,
    cString,
    cSymbol,
    cFunction,
    cOpen,
    cClose,
    cDot,
    cFile,
    cSubr,
    cExSubr,
    cPickSet,
    cEName,
    cUnknown,
    cReserved
} CellTypes;
//Ŀ
// Basic data structure: MemoryCell (SymExp  MemoryCell *)                
//
typedef struct MemoryCell {
    struct {
        unsigned ID     :  4;
        unsigned Mark   :  1;
        unsigned Point2 :  9;
        unsigned Usable :  1;
    } Flag;
    struct SymExp Next;
    struct SymExp Prev;
    CellTypes CellType;
    union {
        struct {
            StrExp Name;
        } Symbol;
        long   IntValue;
        ads_real RealValue;
        StrExp StrValue;
        struct {
            struct SymExp Car;
            struct SymExp Cdr;
        } Cons;
        struct {
            int    ArgC;
            struct SymExp (*Func)();
        } Func;
        FILE *File;
        ads_name EName;
        ads_name PickSet;
    } Cell;
} MemoryCell;
//Ŀ
// Garbage collector support data:                                          
//
typedef struct SelectionSetList {
    ads_name    SelectionSet;
    int         Flag;
    struct SelectionSetList *Next;
} SelectionSetList;
//
typedef struct FileList {
    FILE    *File;
    int     Flag;
    struct FileList *Next;
} FileList;
//Ŀ
// Symbol table definition:                                                 
//
extern long MaxSymbol;
#define HStep 13

typedef struct HashList {
    SymExp  Value;
    _Boolean Repr;
    struct  HashList *Next;
} HashList_;

typedef struct {
    StrExp  Name;
    struct  HashList *Top;
    _Boolean Local;
} HashTable;

#define ClearError ERROR = FALSE
#define ErrorTest if (ERROR) return (NULL)
//Ŀ
// Predefined symbols:                                                      
//  Only used in applications.                                              
//
#ifndef Lisp2C_Library
extern SymExp TrueExprPtr;

extern SymExp setExprPtr;
extern SymExp setqExprPtr;
extern SymExp mapcarExprPtr;
extern SymExp andExprPtr;
extern SymExp orExprPtr;
extern SymExp whileExprPtr;
extern SymExp foreachExprPtr;
extern SymExp repeatExprPtr;
extern SymExp condExprPtr;
extern SymExp ifExprPtr;
extern SymExp prognExprPtr;
extern SymExp applyExprPtr;
extern SymExp defunExprPtr;
#endif
//Ŀ
// ADS_ and LSP_: AutoLISP functions                                        
//
SymExp ADS_Acad_colordlg (SymExp, SymExp, ...);
SymExp ADS_Acad_helpdlg (SymExp, SymExp, ...);
SymExp ADS_Acad_strlsort (SymExp, ...);
SymExp ADS_Action_tile (SymExp, SymExp,...);
SymExp ADS_Add_list (SymExp,...);
SymExp ADS_Ads (SymExp);
SymExp ADS_Alert (SymExp, ...);
SymExp ADS_Angle (SymExp, SymExp, ...);
SymExp ADS_Angtof (SymExp, SymExp,...);
SymExp ADS_Angtos (SymExp, SymExp,...);
SymExp ADS_Client_data_tile (SymExp, SymExp, ...);
SymExp ADS_Command (SymExp,...);
SymExp ADS_Cvunit (SymExp, SymExp, SymExp, ...);
SymExp ADS_Dimx_tile (SymExp, ...);
SymExp ADS_Dimy_tile (SymExp, ...);
SymExp ADS_Distance (SymExp, SymExp, ...);
SymExp ADS_Distof (SymExp,...);
SymExp ADS_Done_dialog (SymExp,...);
SymExp ADS_End_image (SymExp);
SymExp ADS_End_list (SymExp);
SymExp ADS_Entdel  (SymExp,...);
SymExp ADS_Entget  (SymExp, SymExp, ...);
SymExp ADS_Entlast (SymExp);
SymExp ADS_Entmake (SymExp,...);
SymExp ADS_Entmod  (SymExp,...);
SymExp ADS_Entnext (SymExp,...);
SymExp ADS_Entsel  (SymExp,...);
SymExp ADS_Entupd  (SymExp,...);
SymExp ADS_Fill_image (SymExp, SymExp, SymExp, SymExp, SymExp, ...);
SymExp ADS_Findfile (SymExp, ...);
SymExp ADS_Get_attr (SymExp, SymExp,...);
SymExp ADS_Get_tile (SymExp,...);
SymExp ADS_Getangle (SymExp,...);
SymExp ADS_Getcorner (SymExp, SymExp,...);
SymExp ADS_Getdist (SymExp,...);
SymExp ADS_Getfiled (SymExp, SymExp, SymExp, SymExp, ...);
SymExp ADS_Getint (SymExp,...);
SymExp ADS_Getkword (SymExp,...);
SymExp ADS_Getorient (SymExp,...);
SymExp ADS_Getpoint (SymExp,...);
SymExp ADS_Getreal (SymExp,...);
SymExp ADS_Getstring (SymExp,...);
SymExp ADS_Getvar (SymExp,...);
SymExp ADS_Graphscr (SymExp);
SymExp ADS_Grclear (SymExp);
SymExp ADS_Grdraw (SymExp, SymExp, SymExp, SymExp, ...);
SymExp ADS_Grread (SymExp, ...);
SymExp ADS_Grtext (SymExp, ...);
SymExp ADS_Grvecs (SymExp, SymExp, ...);
SymExp ADS_Handent (SymExp, SymExp);
SymExp ADS_Initget (SymExp,...);
SymExp ADS_Inters (SymExp, SymExp, SymExp, SymExp, SymExp, ...);
SymExp ADS_Load_dialog (SymExp,...);
SymExp ADS_Menucmd (SymExp, ...);
SymExp ADS_Mode_tile (SymExp, SymExp,...);
SymExp ADS_Nentsel (SymExp, ...);
SymExp ADS_Nentselp (SymExp, ...);
SymExp ADS_New_dialog (SymExp, SymExp, SymExp,...);
SymExp ADS_Osnap (SymExp, SymExp, ...);
SymExp ADS_Polar (SymExp, SymExp, SymExp, ...);
SymExp ADS_Prompt (SymExp, ...);
SymExp ADS_Redraw (SymExp, ...);
SymExp ADS_Regapp (SymExp, ...);
SymExp ADS_Rtos (SymExp, SymExp,...);
SymExp ADS_Set_tile (SymExp, SymExp,...);
SymExp ADS_Setvar (SymExp, SymExp, ...);
SymExp ADS_Slide_image (SymExp, SymExp, SymExp, SymExp, SymExp, ...);
SymExp ADS_Ssadd (SymExp,...);
SymExp ADS_Ssdel (SymExp, SymExp, ...);
SymExp ADS_Ssget (SymExp,...);
SymExp ADS_Sslength (SymExp, ...);
SymExp ADS_Ssmemb (SymExp, SymExp, ...);
SymExp ADS_Ssname (SymExp, SymExp, ...);
SymExp ADS_Start_dialog (SymExp);
SymExp ADS_Start_image (SymExp, ...);
SymExp ADS_Start_list (SymExp, SymExp,...);
SymExp ADS_Tablet (SymExp, SymExp, ...);
SymExp ADS_Tblnext (SymExp, SymExp, ...);
SymExp ADS_Tblsearch (SymExp, SymExp, SymExp, ...);
SymExp ADS_Term_dialog (SymExp);
SymExp ADS_Textbox (SymExp, ...);
SymExp ADS_Textscr (SymExp);
SymExp ADS_Trans (SymExp, SymExp, SymExp, SymExp, ...);
SymExp ADS_Unload_dialog (SymExp,...);
SymExp ADS_Vector_image (SymExp, SymExp, SymExp, SymExp, SymExp, ...);
SymExp ADS_Vports (SymExp);
SymExp ADS_Wcmatch (SymExp, SymExp,...);
SymExp ADS_Xdroom (SymExp, ...);
SymExp ADS_Xdsize (SymExp, ...);
SymExp ADS_Xload (SymExp, SymExp,...);
SymExp ADS_Xunload (SymExp, SymExp,...);
SymExp LSP_Abs (SymExp, ...);
SymExp LSP_Addn (SymExp, SymExp, ...);
SymExp LSP_Alloc (SymExp, ...);
SymExp LSP_And (SymExp, ...);
SymExp LSP_Append (SymExp, ...);
SymExp LSP_Ascii (SymExp, ...);
SymExp LSP_Assoc (SymExp, SymExp, ...);
SymExp LSP_Atan (SymExp,...);
SymExp LSP_Atof (SymExp, ...);
SymExp LSP_Atoi (SymExp, ...);
SymExp LSP_Atom (SymExp, ...);
SymExp LSP_AtomsFamily (SymExp, SymExp, ...);
SymExp LSP_BitNot (SymExp, ...);
SymExp LSP_Boole (SymExp, SymExp, SymExp,...);
SymExp LSP_Boundp (SymExp, ...);
SymExp LSP_C_r (SymExp, StrExp, ...);
SymExp LSP_Car (SymExp, ...);
SymExp LSP_Cdr (SymExp, ...);
SymExp LSP_Chr (SymExp, ...);
SymExp LSP_Close (SymExp, ...);
SymExp LSP_Cons (SymExp, SymExp, ...);
SymExp LSP_Cos (SymExp, ...);
SymExp LSP_Divide (SymExp,...);
SymExp LSP_Eq (SymExp, SymExp, ...);
SymExp LSP_Equal (SymExp, SymExp, SymExp,...);
SymExp LSP_Eval (SymExp, ...);
SymExp LSP_Exit (SymExp);
SymExp LSP_Exp (SymExp, ...);
SymExp LSP_Expand (SymExp, ...);
SymExp LSP_Expt (SymExp, SymExp, ...);
SymExp LSP_Fix (SymExp, ...);
SymExp LSP_Float (SymExp, ...);
SymExp LSP_Gc (SymExp);
SymExp LSP_Gcd (SymExp, SymExp, ...);
SymExp LSP_Getenv (SymExp,...);
SymExp LSP_Invoke (StrExp, SymExp, ...);
SymExp LSP_Itoa (SymExp, ...);
SymExp LSP_Last (SymExp, ...);
SymExp LSP_Length (SymExp, ...);
SymExp LSP_LessEqual (SymExp, SymExp, ...);
SymExp LSP_LessThan (SymExp, SymExp, ...);
SymExp LSP_List (SymExp,...);
SymExp LSP_Listp (SymExp, ...);
SymExp LSP_Load (SymExp, SymExp, ...);
SymExp LSP_Log (SymExp, ...);
SymExp LSP_Logand (SymExp, SymExp, ...);
SymExp LSP_Logior (SymExp, SymExp, ...);
SymExp LSP_Lsh (SymExp, SymExp, ...);
SymExp LSP_Max (SymExp,...);
SymExp LSP_Mem (SymExp,...);
SymExp LSP_Member (SymExp, SymExp, ...);
SymExp LSP_Min (SymExp,...);
SymExp LSP_Minus (SymExp,...);
SymExp LSP_Minusp (SymExp, ...);
SymExp LSP_MoreEqual (SymExp, SymExp, ...);
SymExp LSP_MoreThan (SymExp, SymExp, ...);
SymExp LSP_Not (SymExp, ...);
SymExp LSP_Nth (SymExp, SymExp, ...);
SymExp LSP_Null (SymExp, ...);
SymExp LSP_NumEq (SymExp, SymExp, ...);
SymExp LSP_NumNotEq (SymExp, SymExp, ...);
SymExp LSP_Numberp (SymExp, ...);
SymExp LSP_OneMinus (SymExp, ...);
SymExp LSP_OnePlus (SymExp, ...);
SymExp LSP_Open  (SymExp, SymExp, ...);
SymExp LSP_Or (SymExp, ...);
SymExp LSP_Plus (SymExp,...);
SymExp LSP_Prin1 (SymExp, ...);
SymExp LSP_Princ (SymExp, ...);
SymExp LSP_Print (SymExp, ...);
SymExp LSP_Quit (SymExp);
SymExp LSP_Read (SymExp, ...);
SymExp LSP_ReadChar (SymExp, ...);
SymExp LSP_ReadLine (SymExp, ...);
SymExp LSP_Rem (SymExp, SymExp, ...);
SymExp LSP_Reverse (SymExp, ...);
SymExp LSP_Sin (SymExp, ...);
SymExp LSP_Sqrt (SymExp, ...);
SymExp LSP_StrCase (SymExp ,...);
SymExp LSP_StrCat (SymExp, ...);
SymExp LSP_StrLen (SymExp, ...);
SymExp LSP_SubStr (SymExp, SymExp, ...);
SymExp LSP_Subst (SymExp, SymExp, SymExp, ...);
SymExp LSP_Terpri (SymExp);
SymExp LSP_Times (SymExp,...);
SymExp LSP_Trace (SymExp, ...);
SymExp LSP_Type (SymExp, ...);
SymExp LSP_Untrace (SymExp, ...);
SymExp LSP_Ver (SymExp);
SymExp LSP__ver (SymExp);
SymExp LSP_Vmon (SymExp);
SymExp LSP_WriteChar (SymExp, ...);
SymExp LSP_WriteLine (SymExp, ...);
SymExp LSP_Zerop (SymExp, ...);
//Ŀ
// Procedures to allocate memory                                            
//
SymExp MakeEName (ads_name);
SymExp MakeFile (FILE *);
SymExp MakeFunction (SymExp (*F)(), int);
SymExp MakeMatrix (ads_matrix);
SymExp MakeMem (CellTypes, int);
SymExp MakeNumber (long);
SymExp MakePickSet (ads_name);
SymExp MakePoint (ads_point);
SymExp MakeReal (ads_real);
SymExp MakeString (StrExp);
SymExp MakeSymbol (StrExp);
//Ŀ
// Procedures to access memory                                              
//
_Boolean    GetBoolean (SymExp);
long        GetNumber (SymExp);
ads_real    GetReal (SymExp);
FILE *      GetFile (SymExp);
StrExp      GetName (SymExp);
StrExp      GetString (SymExp);
void        GetEName (SymExp, ads_name);
void        GetMatrix (SymExp, ads_matrix);
void        GetPickSet (SymExp, ads_name);
void        GetPoint (SymExp, ads_point);
SymExp    (*GetFunction ())();

_Boolean IsFunction (SymExp);
_Boolean IsPoint (SymExp);

//Ŀ
// Copy copies one SymExp (as strdup copies string).                        
//
SymExp SymCopy (SymExp);

//Ŀ
// Procedures to make, delete etc. symbols (Symbol table access)            
//
SymExp  GetLocal (HashTable *, int);
SymExp  GetSymbol (HashTable *, StrExp);
int     InsGlobal (HashTable *, StrExp, SymExp);
void    PutLocal (HashTable *, int, SymExp);
void    PutSymbol (HashTable *, StrExp, SymExp);
int     InsLocal (HashTable *, StrExp, SymExp);
void    DelLocal (HashTable *, int);
int     HIndex (HashTable *, StrExp);
void    InsTmpLocal (HashTable *, int);

//Ŀ
// Procedure to convert result buffer to SymExp                             
//
SymExp rb2Sym (struct resbuf **);

//Ŀ
// Procedure to return SymExp to AutoLISP                                   
//
int returnADS (SymExp);

//Ŀ
// Process control                                                          
//
void KillMem (HashTable *, long);
void Lisp2C_Exit ();
void Lisp2C_Init (int, char *[], long, int);

//Ŀ
// Memory allocation control                                                
//
void InsertStack (SymExp S[], int);
void RemoveStack ();
void PopObjList (void);
void PushObjList (void);

//Ŀ
// Other procedures                                                         
//
void PrintTable (HashTable *);
void check_resbuf (struct resbuf **);
SymExp EvalLambda (SymExp, SymExp, _Boolean);

//Ŀ
// Error message handler                                                    
//
void WriteError (int, StrExp);

//Ŀ
// Debugger support                                                         
//
void BREAKPT (int, int, int, long);
void debugENTER (StrExp);
void debugEXIT ();
void debugRESULT (SymExp);
//Ŀ
// Error messages                                                           
//
#define errRejected                    0
#define errBadArgType                  1
#define errBadAssocList                2
#define errBadConversion               3
#define errBadComment                  4
#define errBadDotPair                  5
#define errBadENTMODlist               6
#define errBadENTMODval                7
#define errBadFormalList               8
#define errBadFunction                 9
#define errBadFunctionCode            10
#define errBadGrvecsList              11
#define errBadGrvecsMatrix            12
#define errBadList                    13
#define errBadListOfPoints            14
#define errBadMemory                  15
#define errBadNode                    16
#define errBadNodeType                17
#define errBadPointArgument           18
#define errBadPointValue              19
#define errBadReal                    20
#define errBadSsgetList               21
#define errBadSsgetValue              22
#define errBadSsgetMode               23
#define errBadXdata                   24
#define errBasePoint                  25
#define errBoole                      26
#define errCantEvaluate               27
#define errCantOpen                   28
#define errConsole                    29
#define errDivideZero                 30
#define errDivideOverflow             31
#define errExceedStr                  32
#define errExtraRight                 33
#define errFileNotOPen                34
#define errFileRead                   35
#define errFileSize                   36
#define errFloatingPt                 37
#define errFunctionCancel             38
#define errFunctionUndef4Arg          39
#define errFunctionUndefReal          40
#define errGrvecsEndpt                41
#define errHashFull                   42
#define errImproperArg                43
#define errIncorrArgs                 44
#define errIncorrComand               45
#define errInputAbort                 46
#define errInvalidArg                 47
#define errInvalidArgList             48
#define errInvalidChar                49
#define errInvalidDotted              50
#define errInvalidInteger             51
#define errNilFunction                52
#define errNoMemory                   53
#define errQuitExit                   54
#define errTooManyArgs                55
#define errUserBreak                  56
#define errXload                      57
#define errXunload                    58

#define warnBadValue       "Cannot access symbol."
//͸
//
//
//
//
//
//;
