/************************************************************************/
/*	This is a simple utility program for users of Fastgraph Light ver 1.12
	and later.  This program takes the name of an executable program as a
	command line parameter.  It will automatically load the the Fastgraph
	Light driver, run the application program and unload the driver when
	the application program terminates.

	USAGE:			fgloader <PROGRAM NAME>
	AUTHOR:			Adrian M. Benson - Compuserve 73142,125
	VERSION:			1.0
	LAST UPDATE:   11/23/93
	COMPILER:		Borland Turbo C++ v3.0	*/
/************************************************************************/


#include <stdio.h>
#include <process.h>

void main( int argc, char *argv[] )
{

	if( argc < 2 )
	{
		printf( "Program name must be specified on the command line.\n" );
		printf( "USAGE:	fgloader <PROGRAM NAME>" );
		exit( -1 );
	}

	if( argc > 2 )
	{
		printf( "Too many parameters on the command line.\n" );
		exit( -1 );
	}

	/*	Load the Fastgraph driver */
	spawnl( P_WAIT, "fgdriver.exe", NULL );

	/* Load the Fastgraph application program */
	spawnl( P_WAIT, argv[1], NULL );

	printf( "Unloading Fastgraph Driver" );

	/* Unload the Fastgraph driver */
	spawnl( P_WAIT, "fgdriver.exe", "fgdriver.exe", "/u", NULL );

	exit( 0 );
}