VERSION 2.00
Begin Form Setup1 
   AutoRedraw      =   -1  'True
   BackColor       =   &H00C00000&
   BorderStyle     =   0  'None
   Caption         =   "Test App Setup"
   ClientHeight    =   3015
   ClientLeft      =   3840
   ClientTop       =   3000
   ClientWidth     =   6210
   ControlBox      =   0   'False
   FillStyle       =   0  'Solid
   FontBold        =   -1  'True
   FontItalic      =   -1  'True
   FontName        =   "MS Sans Serif"
   FontSize        =   24
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   ForeColor       =   &H00000000&
   Height          =   3420
   Icon            =   SETUP1.FRX:0000
   Left            =   3780
   LinkMode        =   1  'Source
   LinkTopic       =   "Form3"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   201
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   414
   Top             =   2655
   Width           =   6330
   Begin Label Label2 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "To customize this setup program, modify the FORM_LOAD event procedure in this form."
      Height          =   435
      Left            =   15
      TabIndex        =   1
      Top             =   15
      Visible         =   0   'False
      Width           =   5625
   End
   Begin Label Label1 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "This label used for DDE connection to the Program Manager"
      Height          =   390
      Left            =   15
      TabIndex        =   0
      Top             =   525
      Visible         =   0   'False
      Width           =   5610
   End
End

'Version = 1.00.002

' $$$ AppParam
Const APPNAME = "UelbList"
Const APPDIR = "C:\UELBLIST"

Const fDataAccess% = False
Const fODBC% = False
Const fBtrieve% = False
Const fOLE2% = False

' Set the total uncompressed file sizes
' by adding the sizes of the files
' $$$ AppSizes
Const WINSYSNEEDED = 1424732
Const OTHERNEEDED = 55319

Sub DrawBackground ()
    Setup1.CurrentY = 5
    Setup1.CurrentX = 5
    Setup1.ForeColor = QBColor(15)
    Print AppName + " Setup"
End Sub

Sub Form_Load ()
    
    
    '----------
    ' Initialize
    '----------
    dialogCaption$ = AppName + " Setup"
    ShowMainForm dialogCaption$

    winDrive$ = UCase$(Left$(winDir$, 1))
    winDir$ = UCase$(GetWindowsDir$())
    winSysDir$ = UCase$(GetWindowsSysDir$())
    
    '----------------------------------------------------
    ' Get Window version
    '----------------------------------------------------
    TheVerInfo& = GetVersion()
    WinVer& = TheVerInfo& And &HFFFF&
    If Val(Format$(WinVer& Mod 256) + "." + Format$(WinVer& \ 256)) >= 3.1 Then
	gfWin31% = True
    End If
    
    '----------------------------------------------------
    ' OLE 2.0 requires Win 3.1 or greater
    '----------------------------------------------------
    If fOLE2% And Not gfWin31% Then
	MsgBox "Dieses Programm bentigt mindestens Windows 3.1."
	GoTo ErrorSetup
    End If

    '----------------------------------------------------
    ' SETUP.EXE passes the source drive in a command
    ' argument.  If it is empty,  that means the user
    ' executed this .exe directly.  In that case, show
    ' a dialog to get the desired source directory.
    '----------------------------------------------------
    SourcePath$ = Command$
    If SourcePath$ = "" Then
	title$ = dialogCaption$
	caption1$ = "Bitte geben Sie Laufwerk und Verzeichnis der " + AppName + "-Quelldateien ein."
	caption2$ = "Installation von:"
	defaultDrive$ = "A:"
	defaultText$ = "A:\"

	ShowPathDialog title$, caption1$, caption2$, defaultDrive$, defaultText$, SourcePath$, outButton$

	If outButton$ = "exit" Then GoTo ErrorSetup
    Else
	If Right$(SourcePath$, 1) <> "\" Then
	    SourcePath$ = SourcePath$ + "\"
	End If
    End If


    '--------------------
    ' Get Destination Path
    '--------------------
    title$ = dialogCaption$
    caption1$ = "Wenn Sie " & AppName & " in einem anderen Laufwerk oder Verzeichnis speichern wollen, geben Sie bitte den Pfad ein."
    caption2$ = "Installation in:"
    defaultDrive$ = "C:"
    defaultText$ = APPDIR

    ShowPathDialog title$, caption1$, caption2$, defaultDrive$, defaultText$, destPath$, outButton$

    If outButton$ = "exit" Then GoTo ErrorSetup
    
    '-----------------------------------------
    ' Dim disk space variables as Long Integers
    '-----------------------------------------
    Dim winSpaceFree As Long
    Dim sourceSpaceFree As Long
    Dim destSpaceFree As Long
    Dim totalNeeded As Long

    '---------------------------------------------------------
    ' If the Windows \SYSTEM directory is a subdirectory
    ' of the Windows directory, the proper place for
    ' installation of .VBXs and shared .DLLs is the
    ' Windows \SYSTEM directory.
    '
    ' If the Windows \SYSTEM directory is *not* a subdirectory
    ' of the Windows directory, then the user is running a
    ' shared version of Windows, and the proper place for
    ' installation of .VBXs and shared .DLLs is the
    ' Windows directory.
    '---------------------------------------------------------
    If InStr(winSysDir$, winDir$) = 0 Then
	winSysDir$ = winDir$
    End If

    
    '---------------------------------
    ' Get Drive Letters of directories
    '---------------------------------
    destDrive$ = UCase$(Left$(destPath$, 1))
    sourceDrive$ = UCase$(Left$(SourcePath$, 1))

    '---------------------------------
    ' Compute free disk space variables
    '---------------------------------
    winSpaceFree = GetDiskSpaceFree(winDrive$)
    destSpaceFree = GetDiskSpaceFree(destDrive$)
    
    '-----------------------------------------
    ' Check for enough disk space.
    '
    ' Some components are being installed into the
    ' Windows\SYSTEM directory.
    '
    ' So if the main destination path is on a
    ' different drive than the drive with
    ' the Windows \SYSTEM directory, we have to
    ' check both drives.
    '
    ' An example of this is when the user is installing
    ' the main product to drive D:, but the Windows
    ' directory is on drive c:
    ' -----------------------------------------
    totalNeeded = WINSYSNEEDED + OTHERNEEDED
    
    If winDrive$ = destDrive$ Then
	If destSpaceFree < totalNeeded Then
	    MsgBox "Zu wenig freier Speicherplatz auf Laufwerk " + destDrive$ + ":" + CRLF + "Ca. " + Str$(totalNeeded - destSpaceFree) + " zustzliche Bytes werden bentigt.", 16, dialogCaption$
	    GoTo ErrorSetup
	End If
    Else
	If winSpaceFree < WINSYSNEEDED Then
	    MsgBox "Zu wenig freier Speicherplatz auf Laufwerk " + winDrive$ + ":" + CRLF + "Ca. " + Str$(WINSYSNEEDED - winSpaceFree) + " zustzliche Bytes werden bentigt.", 16, dialogCaption$
	    GoTo ErrorSetup
	End If
	If destSpaceFree < OTHERNEEDED Then
	    MsgBox "Zu wenig freier Speicherplatz auf Laufwerk " + destDrive$ + ":" + CRLF + "Ca. " + Str$(OTHERNEEDED - destSpaceFree) + " zustzliche Bytes werden bentigt."", 16, dialogCaption$"
	    GoTo ErrorSetup
	End If
	
    End If

    '----------------------------
    ' Create destination directory
    '----------------------------
    If Not CreatePath(destPath$) Then GoTo ErrorSetup
    

    '-----------------------------------------------------------
    ' Show Status Dialog -- This stays up while copying files
    ' It is required by the CopyFile routine
    '-----------------------------------------------------------
    ShowStatusDialog dialogCaption$, totalNeeded
    
    
    '-----------
    ' Copy Files
    '-----------

    ' Test to see if loan.exe is on the disk, if not then you know the user
    ' did not insert the first disk
    ' $$$ DiskStart
    If Not PromptForNextDisk(1, SourcePath$ + "UELBLIST.EX_") Then GoTo ErrorSetup
    If Not CopyFile(SourcePath$, destpath$, "UELBLIST.EX_", "UELBLIST.EXE") Then GoTo ErrorSetup
    If Not CopyFile(SourcePath$, destpath$, "UELBLIST.HL_", "UELBLIST.HLP") Then GoTo ErrorSetup
    If Not CopyFile(SourcePath$, winSysDir$, "SHARE.EX_", "SHARE.EXE") Then GoTo ErrorSetup
    If Not CopyFile(SourcePath$, winSysDir$, "CMDIALOG.VB_", "CMDIALOG.VBX") Then GoTo ErrorSetup
    If Not CopyFile(SourcePath$, winSysDir$, "MHGFRM.VB_", "MHGFRM.VBX") Then GoTo ErrorSetup
    If Not CopyFile(SourcePath$, winSysDir$, "MHGLBL.VB_", "MHGLBL.VBX") Then GoTo ErrorSetup
    If Not CopyFile(SourcePath$, winSysDir$, "MHGMUL.VB_", "MHGMUL.VBX") Then GoTo ErrorSetup
    If Not CopyFile(SourcePath$, winSysDir$, "MSAES110.DL_", "MSAES110.DLL") Then GoTo ErrorSetup
    If Not PromptForNextDisk(2, SourcePath$ + "MSAJT110.DL_") Then GoTo ErrorSetup
    If Not CopyFile(SourcePath$, winSysDir$, "MSAJT110.DL_", "MSAJT110.DLL") Then GoTo ErrorSetup
    If Not CopyFile(SourcePath$, winSysDir$, "THREED.VB_", "THREED.VBX") Then GoTo ErrorSetup
    ' $$$ DiskEnd

    ' If you have more than one distribution disk, call PromptForNextDisk after
    ' you have installed all the files from the previous disk. This line tests to
    ' see if foo.da_ is on disk 2. If not, you know the user has not inserted disk 2.
    ' The call to PromptForNextDisk is commented out, since loan.exe can be installed
    ' from a single distribution disk.
    
    ' If Not PromptForNextDisk(2, SourcePath$ + "foo.da_") Then GoTo ErrorSetup
    ' If Not CopyFile(SourcePath$, destPath$, "foo.da_", "foo.dat", 0) Then GoTo ErrorSetup

    '--------------------------------------------------
    ' File Copying is over, so unload the status dialog
    '--------------------------------------------------
    Unload StatusDlg

    '-----------------------------------------------------------
    ' Show static message while working on DDE to Program Manager
    '-----------------------------------------------------------
    ShowStaticMessageDialog dialogCaption$, "Erstelle Programmgruppe im Programm-Manager..."


    '--------------------------------------
    ' Create program manager group and icon
    '--------------------------------------
    ' $$$ ProgManStart
    CreateProgManGroup Setup1, "UelbList", "UelbList.GRP"
    CreateProgManItem Setup1, destPath$ + "UELBLIST.EXE", "UeLB - Listenkonvertierer"
    CreateProgManItem Setup1, destPath$ + "UELBLIST.HLP", "Infos zum UeLB - Listenkonverter"
    ' $$$ ProgManEnd
    '-------------------------------------------------
    ' Since SETUP.EXE copies your setup program to the Windows
    ' directory, it is possible for your user to
    ' execute this program directly.
    '
    ' As a usability feature, you may wish to insert code
    ' here to install a program manager icon that executes
    ' your setup program in the windows drive.  This
    ' allows th user to re-run setup at a later time to
    ' install options that were not installed the first
    ' time.
    '-------------------------------------------------

    ' $$$ INIStart
    x% = WritePrivateProfileString("Pfade", "Arbeitsverzeichnis", destpath$, "UELBLIST.INI")
    ' $$$ INIEnd

    '-------------------
    ' Hide Static Message
    '-------------------
    MessageDlg.Hide
    

    '--------------------------------------------------------------
    ' If OLE2.DLL already exists, then ignore the OLE 2 flag.
    ' Otherwise, if we are installing an application that uses
    ' OLE 2.0, we need to register the OLE 2 DLL's via REGEDIT.EXE.
    '
    ' Do not copy OLE dlls unless you check the versions and assure
    ' that the versions you plan to install postdate the ones on
    ' the users machine.
    '
    '
    ' The data access engine and OLE 2.0 need to have SHARE.EXE
    ' loaded. Check AUTOEXEC.BAT and add if needed.  NOTE: If
    ' running Window For WorkGroup, then do not add SHARE.  WFW
    ' use its own sharing mechanism, VSHARE.386.
    '----------------------------------------------------------
    If fDataAccess% Or fOLE2% And Not FileExists(winSysDir$ + "\" + "OLE2.DLL") Then
	ret$ = Space$(255)
	x% = GetPrivateProfileString("BOOT", "NETWORK.DRV", "", ret$, Len(ret$), "SYSTEM.INI")
	If x% Then ret$ = Left(ret$, x%)
	If InStr(1, UCase$(ret$), "WFWNET.DRV") = 0 Then
	    AddShareIfNeeded winSysDir$, "SHARE.EXE"
	End If
    End If

    '----------------------------
    ' Need to register OLE 2.0 dlls
    '----------------------------
    If fOLE2% And Not FileExists(winSysDir$ + "\" + "OLE2.DLL") Then
	x% = Shell("regedit /s ole2.reg")
    End If

    '-------------------------------------------------------
    ' Do not change this if statement.  Used by Setup Wizard
    '-------------------------------------------------------
    If fODBC% Then
	CreateProgManItem Setup1, destPath$ + "ODBCADM.EXE", "ODBC Administrator"
	MsgBox "Before you can run a Visual Basic ODBC application using the SQL Server driver, you must first update the ODBC catalog of stored procedures.  These procedures are provided in the INSTCAT.SQL file.  Typically, the system administrator for SQL Server should install these procedures, using the SQL Server ISQL utility."
    End If

    '-------------------------------------------------------
    ' Do not change this if statement.  Used by Setup Wizard
    '-------------------------------------------------------
    If fBtrieve% Then
	' See notes in Appendix C
	retstr$ = String$(255, 32)
	x% = GetPrivateProfileString%("BTRIEVE", "OPTIONS", "1", retstr$, Len(retstr$), "WIN.INI")
	If x% <= 1 Then
	    x% = WritePrivateProfileString%("BTRIEVE", "OPTIONS", "/m:64 /p:4096 /b:16 /f:20 /l:40 /n:12 /t:" + destPath$ + "BTRIEVE.TRN", "WIN.INI")
	End If
    End If

    '------------------
    ' Show Final message
    '------------------
    MsgBox "Die Installation von " + AppName + " wurde erfolgreich beendet.", 48, dialogCaption$
   
ExitSetup:
    Setup1.Hide
    RestoreProgMan         'Show the program manager
    End
    Exit Sub

ErrorSetup:
    MsgBox AppName + " ist nicht vollstndig installiert. Bitte wiederholen Sie das Setup-Programm, bevor Sie " + AppName + " starten.", 48, dialogCaption$
    ChDrive winDrive$   ' Set back to hard disk
    ChDir Left$(winDir$, Len(winDir$) - 1)
    End
    Exit Sub
    
End Sub

Sub Form_Paint ()
    DrawBackground
End Sub

'---------------------------------------------------------------
' Sets the form's caption, Paints 3-D Background Text, Shows Form
'---------------------------------------------------------------
Sub ShowMainForm (Caption$)
    Screen.MousePointer = 11
    Setup1.Caption = Caption$
    Setup1.Move 0, 0, Screen.Width, Screen.Height
    Setup1.Show
    Setup1.Refresh

    Setup1.ScaleMode = 2
    Setup1.FontSize = 24
    Setup1.FontBold = True
    Setup1.FontItalic = True
    
    DrawBackground
End Sub

Sub ShowPathDialog (title$, caption1$, caption2$, defaultDrive$, defaultText$, SourcePath$, outButton$)
	Screen.MousePointer = 11
	Load PathDlg
	PathDlg.Caption = title$
	PathDlg.Label1.Caption = caption1$
	PathDlg.Label2.Caption = caption2$
	PathDlg.inDrive.Tag = defaultDrive$
	PathDlg.Text1.Text = defaultText$
	PathDlg.Text1.SelStart = 0
	PathDlg.Text1.SelLength = Len(defaultText$)
	If Left$(defaultText$, 1) = "A" Or Left$(defaultText$, 1) = "B" Then
	    PathDlg.diskpict.Visible = True
	    PathDlg.hddpict.Visible = False
	Else
	    PathDlg.diskpict.Visible = False
	    PathDlg.hddpict.Visible = True
	End If
	CenterForm PathDlg
	DoEvents
	Screen.MousePointer = 0
	
	PathDlg.Show 1
	
	SourcePath$ = PathDlg.outPath.Tag
	outButton$ = PathDlg.outButton.Tag
	Unload PathDlg
End Sub

Sub ShowStaticMessageDialog (title$, Caption$)

    Load MessageDlg
    CenterForm MessageDlg
    MessageDlg.Caption = title$
    MessageDlg.Label.Caption = Caption$
    MessageDlg.Show
    MessageDlg.Refresh

End Sub

Sub ShowStatusDialog (title$, totalBytes As Long)

    Load StatusDlg
    StatusDlg.Caption = title$
    StatusDlg.total.Tag = Str$(totalBytes)
    CenterForm StatusDlg
    StatusDlg.Show

End Sub

