BEGIN {
  pi = 4.0 * atan2(1, 1)
  CONVFMT = "%.10g"
  OFMT = "%.10g"
  tol = 0.00005
}
function abs(a) {
  return (a > 0 ? a : -a)
}
/^Ambient[ \t]+[Ll]ight[ \t]+[Cc]olor/ {
  r = substr($4, 5)
  g = substr($5, 7)
  b = substr($6, 6)
  print "ambient", r, g, b
  next
}
/^Background[ \t]+[Ss]olid[ \t]+[Cc]olor/ {
  r = substr($4, 5)
  g = substr($5, 7)
  b = substr($6, 6)
  print "background", r, g, b
  bg = 1
  next
}
/^Named[ \t]+[Oo]bject/ {
  if (ft != 0 && f != ft) {
    print "Error: too few triangles" >"/dev/stderr"
    ft = 0
    exit
  }
  if (ft != 0) {
    for (i = 0; i < ft; i++) {
      i1 = v1[i]
      if (y[i1] == "R") i1 = x[i1]
      i2 = v2[i]
      if (y[i2] == "R") i2 = x[i2]
      i3 = v3[i]
      if (y[i3] == "R") i3 = x[i3]
      if (i1 == i2 || i1 == i3 || i2 == i3) {
        fdg++
        continue
      }
      s = m[i]
      if (i in fs) {
        if (abs(nx[i1]) < tol && abs(ny[i1]) < tol && abs(nz[i1]) < tol) {
          fdg++
          continue
        }
        if (abs(nx[i2]) < tol && abs(ny[i2]) < tol && abs(nz[i2]) < tol) {
          fdg++
          continue
        }
        if (abs(nx[i3]) < tol && abs(ny[i3]) < tol && abs(nz[i3]) < tol) {
          fdg++
          continue
        }
        print "triangle normal", s, \
          x[i1], y[i1], z[i1], nx[i1], ny[i1], nz[i1], \
          x[i2], y[i2], z[i2], nx[i2], ny[i2], nz[i2], \
          x[i3], y[i3], z[i3], nx[i3], ny[i3], nz[i3]
      } else
        print "triangle", s, x[i1], y[i1], z[i1], \
          x[i2], y[i2], z[i2], x[i3], y[i3], z[i3]
    }
    for (i in x) delete x[i]
    for (i in y) delete y[i]
    for (i in z) delete z[i]
    for (i in nx) delete nx[i]
    for (i in ny) delete ny[i]
    for (i in nz) delete nz[i]
    for (i in v1) delete v1[i]
    for (i in v2) delete v2[i]
    for (i in v3) delete v3[i]
    for (i in fs) delete fs[i]
    for (i in m) delete m[i]
  }
  oname = $3
  otype = 0
  ft = 0
  print ";", oname
  next
}
/^Tri-mesh/ {
  if (otype != 0) {
    print "Error: bad object" >"/dev/stderr"
    exit
  }
  otype = 1
  v = 0
  f = 0
  vt = $3
  ft = $5
  next
}
/^Vertex[ \t]+[0-9]+/ {
  if (otype != 1) {
    print "Error: bad vertex" >"/dev/stderr"
    exit
  }
  for (vr = 0; vr < v; vr++) {
    if (abs(x[vr] - $4) < tol && \
        abs(y[vr] - $6) < tol && \
        abs(z[vr] - $8) < tol) break
  }
  if (vr != v) {
    vdg++
    x[v] = vr
    y[v] = "R"
    z[v] = ""
    v++
    if (v > vt) {
      print "Error: too many vertices" >"/dev/stderr"
      exit
    }
    next
  }
  x[v] = $4
  y[v] = $6
  z[v] = $8
  v++
  if (v > vt) {
    print "Error: too many vertices" >"/dev/stderr"
    exit
  }
  next
}
/^Face[ \t]+[Ll]ist/ {
  if (v != vt) {
    print "Error: too few vertices" >"/dev/stderr"
    exit
  }
  next
}
/^Face[ \t]+[0-9]+/ {
  v1[f] = $4
  v2[f] = $6
  v3[f] = $8
  if (NF <= 9) s = "DEFAULT"
  if (NF > 9) s = $10
  for (i = 11; i <= NF; i++) s = s""$i
  if (!(s in mlist)) {
    mlist[s] = ""
    print "#define", s, "surface matte white data"
  }
  m[f] = s
  f++
  if (f > ft) {
    print "Error: too many triangles" >"/dev/stderr"
    ft = 0
    exit
  }
  next
}
/^Smoothing/ {
  fs[f - 1] = ""
  i1 = v1[f - 1]
  if (y[i1] == "R") i1 = x[i1]
  p1x = x[i1]
  p1y = y[i1]
  p1z = z[i1]
  i2 = v2[f - 1]
  if (y[i2] == "R") i2 = x[i2]
  p2x = x[i2] - p1x
  p2y = y[i2] - p1y
  p2z = z[i2] - p1z
  i3 = v3[f - 1]
  if (y[i3] == "R") i3 = x[i3]
  p3x = x[i3] - p1x
  p3y = y[i3] - p1y
  p3z = z[i3] - p1z
  p1x = p2y * p3z - p2z * p3y
  p1y = p2z * p3x - p2x * p3z
  p1z = p2x * p3y - p2y * p3x
  t = sqrt(p1x * p1x + p1y * p1y + p1z * p1z)
  if (t < tol) {
    f--
    ft--
    next
  }
  p1x /= t
  p1y /= t
  p1z /= t
  if (!(i1 in nx)) {
    nx[i1] = 0
    ny[i1] = 0
    nz[i1] = 0
  }
  nx[i1] += p1x
  ny[i1] += p1y
  nz[i1] += p1z
  if (!(i2 in nx)) {
    nx[i2] = 0
    ny[i2] = 0
    nz[i2] = 0
  }
  nx[i2] += p1x
  ny[i2] += p1y
  nz[i2] += p1z
  if (!(i3 in nx)) {
    nx[i3] = 0
    ny[i3] = 0
    nz[i3] = 0
  }
  nx[i3] += p1x
  ny[i3] += p1y
  nz[i3] += p1z
  next
}
/^Direct[ \t]+[Ll]ight/ {
  getline
  px = $3
  py = $5
  pz = $7
  ltype = 1
  getline
  while ($1 != "Light") {
    if ($1 == "Spotlight") {
      ltype = 2
      sx = $4 - px
      sy = $6 - py
      sz = $8 - pz
    }
    if ($1 == "Falloff") {
      f = $3
    }
    getline
  }
  r = substr($3, 5)
  g = substr($4, 7)
  b = substr($5, 6)
  if (ltype == 1) print "light point", px, py, pz, r, g, b
  if (ltype == 2) print "light spot", px, py, pz, sx, sy, sz, \
    r, g, b, f / 2, 2
  next
}
/^Camera/ {
  if (NF > 1) {
    i = 1
    fd = ""
    t = substr($2, 2, 1)
    while (t != "m") {
      fd = fd""t
      t = substr($2, 2 + i, 1)
      i++
    }
    printf "fov %.6g ;%.10g mm\n", atan2(46.0, fd) * 90 / pi, fd
  }
  getline
  px = $3
  py = $5
  pz = $7
  print "eye", px, py, pz
  getline
  px = $3
  py = $5
  pz = $7
  print "look", px, py, pz
  getline
  print "up 0 0 1"
  next
}
END {
  if (ft != 0 && f != ft) {
    print "Error: too few triangles" >"/dev/stderr"
    exit
  }
  if (ft != 0) {
    for (i = 0; i < ft; i++) {
      i1 = v1[i]
      if (y[i1] == "R") i1 = x[i1]
      i2 = v2[i]
      if (y[i2] == "R") i2 = x[i2]
      i3 = v3[i]
      if (y[i3] == "R") i3 = x[i3]
      if (i1 == i2 || i1 == i3 || i2 == i3) {
        fdg++
        continue
      }
      s = m[i]
      if (i in fs) {
        if (abs(nx[i1]) < tol && abs(ny[i1]) < tol && abs(nz[i1]) < tol) {
          fdg++
          continue
        }
        if (abs(nx[i2]) < tol && abs(ny[i2]) < tol && abs(nz[i2]) < tol) {
          fdg++
          continue
        }
        if (abs(nx[i3]) < tol && abs(ny[i3]) < tol && abs(nz[i3]) < tol) {
          fdg++
          continue
        }
        print "triangle normal", s, \
          x[i1], y[i1], z[i1], nx[i1], ny[i1], nz[i1], \
          x[i2], y[i2], z[i2], nx[i2], ny[i2], nz[i2], \
          x[i3], y[i3], z[i3], nx[i3], ny[i3], nz[i3]
       } else
        print "triangle", s, x[i1], y[i1], z[i1], \
          x[i2], y[i2], z[i2], x[i3], y[i3], z[i3]
    }
  }
  if (!bg) print "background black"
  if (vdg > 0) \
    print "Warning: bad vertices -", vdg >"/dev/stderr"
  if (fdg > 0) \
    print "Warning: bad triangles -", fdg >"/dev/stderr"
}
