BEGIN {
  OFMT = "%.8g"
  print "#define S1 surface matte red"
  print "#define S2 surface matte green"
  print "#define S3 surface matte yellow"
  print "#define S4 surface matte blue"
  print "#define S5 surface matte magenta"
  print "#define S6 surface matte cyan"
  print "#define S7 surface matte white"
  print "#define S8 surface matte orange"
  print "#define S9 surface matte grey"
  print "#define S10 surface matte ligth_blue"
  print "#define S11 surface metal steel_blue mono 0.9 0.9"
  print "#define S12 surface matte lavender"
  print "#define S13 surface matte brown"
  print "#define S14 surface metal gold mono 0.5 0.5"
  print "#define S15 surface matte misty_rose"
  print "#define S16 surface matte spring_green"
  xmin = 1000000.0
  xmax = -xmin
  ymin = 1000000.0
  ymax = -ymin
  zmin = 1000000.0
  zmax = -zmin
}
NF == 1 {
  ok = 1
  v = 1
  next
}
NF == 7 {
  if (!ok) next
  if (v >= 2 && $1 == lx1 && $2 == ly1 && $3 == lz1) {
    ok = 0
    dgn++
    next
  }
  if (v >= 3 && $1 == lx2 && $2 == ly2 && $3 == lz2) {
    ok = 0
    dgn++
    next
  }
  if ($1 < xmin) xmin = $1
  if ($1 > xmax) xmax = $1
  if ($2 < ymin) ymin = $2
  if ($2 > ymax) ymax = $2
  if ($3 < zmin) zmin = $3
  if ($3 > zmax) zmax = $3
  sx += $1
  sy += $2
  sz += $3
  sn++
  if (v == 1) {
    v = 2
    lx1 = $1
    ly1 = $2
    lz1 = $3
    nx1 = $4
    ny1 = $5
    nz1 = $6
    sf1 = $7
    next
  }
  if ( v == 2) {
    v = 3
    lx2 = $1
    ly2 = $2
    lz2 = $3
    nx2 = $4
    ny2 = $5
    nz2 = $6
    sf2 = $7
    next
  }
  print "triangle general"
  print lx1, ly1, lz1, nx1, ny1, nz1
  print lx2, ly2, lz2, nx2, ny2, nz2
  print $1, $2, $3, $4, $5, $6
  print "S" sf1, "S" sf2, "S" $7
  next
}
{
  # print "error: bad line", NR >"/dev/stderr"
  next
}
END {
  s = xmax - xmin
  if (ymax - ymin > s) s = ymax - ymin
  if (zmax - zmin > s) s = zmax - zmin
  sx /= sn
  sy /= sn
  sz /= sn
  print "eye", sx + 1.5 * s, sy + s * 0.5, sz + s
  print "at", sx, sy, sz
  print "background black"
  print "light point", sx, sy + s, sz
  print "light point", sx + 1.5 * s, sy, sz + s
  # if (dgn) \
  #   print "warning:", dgn, "degenerate triangle(s)" >"/dev/stderr"
}
