/*
		AD GRAPHICS MODULE
		ANIMATION SAMPLE
    
    DEMONSTRATES	- USE OF AFTER DARK SOUND
                	- OVERLAPPING ANIMATION
    
		BY BILL STEWART
		AUG/93
*/
#include "module.h"
#include "anim.h"
#include <mmsystem.h>
#include "ad_snd.h"

/*
* 	SYSTEM GLOBALS
*/
extern  HANDLE  hLibInst;   //  HANDLE TO THIS MODULE (DLL)
extern  HDC  hDC;           //  MODULE DISPLAY CONTEXT
extern  LPSYSTEM lpSystem;  //  POINTER TO AD SYSTEM PARAM BLOCK
extern  LPMODULE lpModule;  //  POINTER TO MODULE'S PARAMETERS

/*
*   ANIM GLOBALS
*/
HBITMAP	hBMShow[2][2], hBMOld[2][2], hBMMix, hBMOldMix;
HDC			hDCShow[2][2], hDCMix;
HSOUND 	hIgniteSnd;
char 		szIgniteResName[] = "IGNITE";
BOOL		bSndAsync = FALSE, bAllowSnd = TRUE;
POINT		ptSzBM[2], ptLoc[2];
int			iDelay;
RECT		rObj[2], rInter;
BITMAP	BM;
	
/*
*  	MODULE ABOUT TO GO TO SLEEP (PULL DOWN DLOGS, ETC.)
*/
int DoPreInitialize ()
{
  return NOERROR;
}

/*
*  	MODULE INITIALIZATION ROUTINE
*/
int DoInitialize ()
{ 
	int			i,j;
	
	iDelay = 100-lpModule->iControlValue[0];
	
	//	SETUP SOUND STUFF
	bSndAsync = adwSoundAsyncCap ();
  if (bSndAsync)
  {
		//  OPEN SOUND DEVICE
		adwOpenSound ();

		//	PREPARE SND
		hIgniteSnd = adwLoadSoundResource (hLibInst, szIgniteResName);
		adwSetSoundMode (hIgniteSnd, ADWSOUND_ASYNC);
	}

  //	LOAD BITMAPS
  hBMShow[0][0] = LoadBitmap (hLibInst, "LOGO");
  hBMShow[1][0] = LoadBitmap (hLibInst, "SDI");
  
  //	GET MASKS   
  for (i=0; i<2; i++)
  {
		GetObject (hBMShow[i][0], sizeof (BITMAP), &BM);
		ptSzBM[i].x = BM.bmWidth;
		ptSzBM[i].y = BM.bmHeight;
		
  	hBMShow[i][1] = GetMask (0, hBMShow[i][0]);   
  	for (j=0; j<2; j++)        
  	{
	  	hDCShow[i][j] = CreateCompatibleDC (hDC);
			hBMOld[i][j] = SelectObject (hDCShow[i][j], hBMShow[i][j]); 
		}
	} 
	
	//	MAKE MIXING AREA
	hBMMix = CreateCompatibleBitmap (hDC, max(ptSzBM[0].x,ptSzBM[1].x),
		max(ptSzBM[0].y,ptSzBM[1].y));
	hDCMix = CreateCompatibleDC (hDC);
	hBMOldMix = SelectObject (hDCMix, hBMMix);
	
	//	INITIAL POSITIONS
	ptLoc[0].x = -ptSzBM[0].x;
  ptLoc[0].y = lpModule->ptRgnSize.y/2-8;
  ptLoc[1].x = lpModule->ptRgnSize.x;
  ptLoc[1].y = lpModule->ptRgnSize.y/2-8;     
  
	return NOERROR;
}

/*
* 	MODULE SCREEN BLANKING ROUTINE
*/
int DoBlank ()
{
  PatBlt (hDC, 0,0, lpModule->ptRgnSize.x, lpModule->ptRgnSize.y, BLACKNESS);

	return NOERROR;
}

/*
*   MODULE GRAPHICS ROUTINE
*/
int DoDrawFrame ()
{ 
	static	int	iFrameCount;
	int		i, j;
	
	//	DELAY MECHANISM
	iFrameCount++;
	if (iFrameCount < iDelay)
		return NOERROR;
	
	iFrameCount = 0;
	
	//	DETERMINE RECTS
	for (i=0; i<2; i++)
	{
		rObj[i].left = ptLoc[i].x;
		rObj[i].top = ptLoc[i].y;    
		rObj[i].right = ptLoc[i].x+ptSzBM[i].x;
		rObj[i].bottom = ptLoc[i].y+ptSzBM[i].y;     
	}
		
	//	DRAW BITMAPS    
	for (i=0; i<2; i++)   
	{ 
		//	INTERSECT? THEN SPECIAL DRAW
		if (lpModule->iControlValue[2] && IntersectRect (&rInter, &rObj[0], &rObj[1]))
		{ 
			//	IF CAN PLAY SND, DO IT
			if (bAllowSnd)
			{
				adwPlaySound (hIgniteSnd);
				bAllowSnd = FALSE;
			}
					
			//	BUILD MIXED IMAGE
			PatBlt (hDCMix, 0,0, ptSzBM[i].x,ptSzBM[i].y, BLACKNESS); 
		  for (j=0; j<2; j++)
		  {
		  	BitBlt (hDCMix, ptLoc[j].x-ptLoc[i].x,ptLoc[j].y-ptLoc[i].y, ptSzBM[j].x,ptSzBM[j].y, 
		  		hDCShow[j][1], 0,0, SRCAND);
		    BitBlt (hDCMix, ptLoc[j].x-ptLoc[i].x,ptLoc[j].y-ptLoc[i].y, ptSzBM[j].x,ptSzBM[j].y, 
		    	hDCShow[j][0], 0,0, SRCPAINT);   
		  }
		  BitBlt (hDC, ptLoc[i].x,ptLoc[i].y, ptSzBM[i].x,ptSzBM[i].y, hDCMix, 0,0, SRCCOPY);
		}   
		//	NO INTERSECTION, SO DO SIMPLE DRAW
		else
		{
			BitBlt (hDC, ptLoc[i].x,ptLoc[i].y, ptSzBM[i].x,ptSzBM[i].y, hDCShow[i][0], 0,0, SRCCOPY);
  		bAllowSnd = TRUE;
  	}
  }
  
  //	MOVE LOCATIONS
  ptLoc[0].x+=2;
  if (ptLoc[0].x > lpModule->ptRgnSize.x)
  	ptLoc[0].x = -ptSzBM[0].x;	
  ptLoc[1].x-=1;
  if (ptLoc[1].x < -ptSzBM[1].x)
  	ptLoc[1].x = lpModule->ptRgnSize.x;
	return NOERROR;
}

/*
*   CLOSE MODULE, FREE USED MEMORY, ETC..
*/
int DoClose ()
{  
	int	i,j;
	
	// CLOSE AND FREE SOUND RESOURCES
	if (bSndAsync)
	{
		adwCloseSound (ADWSOUND_FLUSH);
		adwFreeSound (hIgniteSnd);
	}
  
  //	DELETE DCs, BITMAPS
  for (i=0; i<2; i++)
  {
  	for (j=0; j<2; j++)
  	{
  		SelectObject (hDCShow[i][j], hBMOld[i][j]);
  		DeleteObject (hBMShow[i][j]);
  		DeleteDC (hDCShow[i][j]);
  	}
  }
  
  SelectObject (hDCMix, hBMOldMix);
  DeleteObject (hBMMix);
  DeleteDC (hDCMix);
  
  return NOERROR;
}

/*
*   MODULE IS SELECTED
*/
int  DoSelected ()
{
	bSndAsync = adwSoundAsyncCap ();
	lpModule->bWantSnd = bSndAsync;

	return NOERROR;
}

/*
*   MODULE'S ABOUT INFO SELECTED
*/
int  DoAbout ()
{
	return NOERROR;
}

/*
*   BUTTON CLICKED ON A MODULE CONTROL
*/
int  DoButtonMessage (iControl)
int iControl;
{
	switch (iControl)
	{
		case 0: 
			iDelay = 100-lpModule->iControlValue[0];
			break;

		case 1:
			break;

		case 2:
			break;

		case 3:
			break;
	}
	return NOERROR;
}

/*
*  	MAKE B&W MASK FOR SPECIFIED BITMAP
*/
HBITMAP	FAR PASCAL GetMask	(hPalMas, hBMInput)
HPALETTE	hPalMas;
HBITMAP	hBMInput;
{
	HDC	hDCTemp[2];
	HBITMAP	hBMMask, hBMOld[2];
	BITMAP	bmInput;
	HPALETTE	hPalTemp;
	DWORD		dwCol;
	int			i;

	//	GET SIZE NEEDED & CREATE MASK BITMAP
	GetObject (hBMInput, sizeof (BITMAP), (LPSTR) &bmInput);
	hBMMask = CreateBitmap (bmInput.bmWidth, bmInput.bmHeight, 1, 1, NULL);

	//	MAKE SOME DCs
	for (i=0; i<2; i++)
		hDCTemp[i] = CreateCompatibleDC (hDC);

	hBMOld[0] = SelectObject (hDCTemp[0], hBMInput);
	hBMOld[1] = SelectObject (hDCTemp[1], hBMMask);

	if (hPalMas)
		hPalTemp = SelectPalette (hDCTemp[0], hPalMas, FALSE);

  //	MAKE MONOCHROME COPY
  dwCol = SetBkColor (hDCTemp[0], 0L);
	BitBlt (hDCTemp[1], 0, 0, bmInput.bmWidth, bmInput.bmHeight,
		hDCTemp[0], 0, 0, SRCCOPY);
  SetBkColor (hDCTemp[0], dwCol);

	//	DELETE DCs
	if (hPalTemp)
		SelectPalette (hDCTemp[0], hPalTemp, FALSE);
	for (i=0; i<2; i++)
	{
  	SelectObject (hDCTemp[i], hBMOld[i]);
  	DeleteDC (hDCTemp[i]);
	}
	return hBMMask;
}
