$! vmsunpack.com -- unpack NetHack's *.tar.Z.uu archive packages	[pr]
$!		into individual source files, creating subdirectories
$!		as needed.  The current directory must hold the input
$!		packages and will become the 'top' of Nethack source tree.
$!		For VMS, the input files should be named *.TAR_Z_UU.
$!
$! Site-specific setup--define appropriate commands for unpacking operations.
$	uudecode   := $rpr:uudecode
$	uncompress := $rpr:lzdcmp -b
$	untar      := $rpr:tar2vms xv "!"
$	tar_setup  := define/user_mode TAPE
$! [Nothing below this line should need to be changed.]
$!
$! Operation (make sure that all archive packages are named correctly):
$!	uudecode   SOMETHING.tar_Z_uu -> SOMETHING.tar_Z
$!	uncompress SOMETHING.tar_Z    -> SOMETHING.tar
$!	tar_setup  SOMETHING.tar      -> preparation for poor tar2vms interface
$!	untar      SOMETHING.tar      -> individual files extracted from archive
$!	delete SOMETHING.tar;,SOMETHING.tar_Z;
$!	  note: original .tar_Z_uu file kept; it should be deleted manually.
$!
$ ARCHIVES1="Top Dat1 Dat2 Dat3 Dat4 Doc1 Doc2 Doc3 Incl1 Incl2 Incl3 Incl4 "-
	   +"Util1 Util2"
$ ARCHIVES2="Src1 Src2 Src3 Src4 Src5 Src6 Src7 Src8 Src9 Src10 "-
	   +"Src11 Src12 Src13 Src14 Src15 Src16 Src17 Src18 Src19 Src20 "-
	   +"Src21 Src22 Src23 Src24 Src25 Src26 Src27 Src28"
$ ARCHIVES3="Amiga1 Amiga2 Amiga3 Amiga4 Amiga5 Amiga6 Amiga7 AmiSpl Atari "-
	   +"Mac1 Mac2 Mac3 Mac4 Mac5 Mac6 Msdos1 Msdos2 Msdos3"
$ ARCHIVES4="NT Os2 Shr1 Shr2 Shr3 Snd1 Snd2 Snd3 Snd4 Snd5 Unx1 Unx2 "-
	   +"Vms1 Vms2 Vms3 Tty X1 X2 X3"
$ all = f$edit(ARCHIVES1+" "+ARCHIVES2+" "+ARCHIVES3+" "+ARCHIVES4,"COMPRESS")
$ kits = "Top   |Dat   |Doc   |Incl  |Util  |Src   |Amiga |AmiSpl|Atari |"-
       + "Mac   |Msdos |NT    |Os2   |Shr   |Snd   |Unx   |Vms   |Tty   |"-
       + "X     |"
$ dirs = "[],[.dat],[.doc],[.include],[.util],[.src],"-
       + "[.sys.amiga],[.sys.amiga.splitter],[.sys.atari],"-
       + "[.sys.mac],[.sys.msdos],[.sys.winnt],[.sys.os2],"-
       + "[.sys.share],[.sys.share.sounds],[.sys.unix],[.sys.vms],"-
       + "[.win.tty],[.win.X11]"
$! VMS can live without these:
$ skippable = "Amiga |AmiSpl|Atari |Mac   |Msdos |NT    |Os2   |Snd   |"-
       + "Unx   |X     |"
$!
$ if f$parse("[.sys]").eqs."" then  create/dir [.sys]/log
$ if f$parse("[.win]").eqs."" then  create/dir [.win]/log
$!
$! First handle some miscellaneous files --what a nuisance :-(
$ if f$search("shr.termcap_uu").nes.""
$ then	if f$parse("[.sys.share]").eqs."" then  create/dir [.sys.share]/log
$	rename/new_vers shr.termcap_uu [.sys.share]termcap.uu
$ endif
$ if f$search("mac.*_hqx").nes.""
$ then	if f$parse("[.sys.mac]").eqs."" then  create/dir [.sys.mac]/log
$	if f$search("mac.nhproj_hqx").nes."" then -
	rename/new_vers mac.nhproj_hqx [.sys.mac]NHproj.hqx
$	if f$search("mac.nhsound_hqx").nes."" then -
	rename/new_vers mac.nhsound_hqx [.sys.mac]NHsound.hqx
$ endif
$ if f$search("cpp%.shr").nes.""
$ then	if f$parse("[.sys.unix]").eqs."" then  create/dir [.sys.unix]/log
$	rename/new_vers cpp%.shr [.sys.unix]*.*
$ endif
$! [note: the above files aren't needed for the VMS port.]
$!
$ topdir = f$directory()
$ kitsiz = f$length(f$element(0,"|",kits))+1
$ kits = "|" + f$edit(kits,"UPCASE")
$ k = 0 !count of archive files skipped
$ i = 0 !loop index for archive substring
$loop:
$	f = f$element(i," ",all)
$	if f.eqs."" .or. f.eqs." " then  goto done
$	d = f - "0" - "1" - "2" - "3" - "4" - "5" - "6" - "7" - "8" - "9" -
	      - "0" - "1" - "2" - "3" - "4" - "5" - "6" - "7" - "8" - "9"
$   if f$search("''f'.tar").nes."" then  goto detar
$   if f$search("''f'.tar_Z").nes."" then  goto decompress
$   if f$search("''f'.tar_Z_uu").nes."" then -
	uudecode 'f'.tar_Z_uu 'f'.tar_Z
$decompress:
$   if f$search("''f'.tar_Z").nes."" then -
	uncompress 'f'.tar_Z 'f'.tar
$   if f$search("''f'.tar").nes."" then  goto detar
$!
$!     an expected file wasn't found--that's OK in _some_ instances
$	msg_fmt = "!/ Missing archive file !AS skipped.!/"
$	if f$locate("|"+d,"|"+skippable).ge.f$length(skippable) then -
		msg_fmt = "!/% Expected archive file !AS is missing!!!/"
$	write sys$output f$fao(msg_fmt,"''f'.tar_Z_uu")
$	k = k + 1
$	goto skip
$!
$detar:
$	p = f$locate(f$edit("|"+d,"UPCASE"),kits) / kitsiz
$	d = f$element(p,",",dirs)
$	set default 'd'
$	if f$parse("[]").eqs."" then  create/dir []/log
$	write sys$output "Unpacking ''f'.tar into ''d'..."
$	f = topdir + f
$	tar_setup 'f'.tar	!define/user TAPE 'f'.tar
$	untar 'f'.tar		!tar2vms xv
$!
$	if f$search("''f'.tar_Z_uu").nes."" -
	 .or. f$search("''f'.tar_Z").nes."" then  delete 'f'.tar;
$	if f$search("''f'.tar_Z_uu").nes."" -
	.and. f$search("''f'.tar_Z").nes."" then  delete 'f'.tar_Z;
$	set default 'topdir'
$skip:
$	i = i + 1
$	goto loop
$done:
$	msg_fmt = "!/ Unpacking completed."
$	if k.gt.0 then -
		msg_fmt = msg_fmt + "  !SL archive package!%S skipped.!/"
$	write sys$output f$fao(msg_fmt,k)
$ exit
