(************************************************)
(* 						*)
(*	 SuperVGA 65536 BGI driver defines	*)
(*		Copyright (c) 1993		*)
(*	    Jordan Hargraphix Software		*)
(*						*)
(************************************************)

(* These are the currently supported modes *)
const
  SVGA320x200x65536	= 0;	(* 320x200x32768 HiColor VGA *)
  SVGA640x350x65536	= 1;	(* 640x350x32768 HiColor VGA *)
  SVGA640x400x65536	= 2;	(* 640x400x32768 HiColor VGA *)
  SVGA640x480x65536	= 3;	(* 640x480x32768 HiColor VGA *)
  SVGA800x600x65536	= 4;	(* 800x600x32768 HiColor VGA *)

function RGB(R,G,B : Word) : Word;
begin
  RGB := ((R and 31)SHL 11) OR ((G and 31)SHL 5) OR (B and 31);
end;

function RealDrawColor(Color : Word) : Word;
begin
  if (GetMaxColor > 256) then
    SetRgbPalette(1024,(Color SHR 11) AND 31,(Color SHR 5) AND 31,Color AND 31);
  RealDrawColor := Color;
end;

function RealFillColor(Color : Word) : Word;
begin
  if (GetMaxColor > 256) then
    SetRgbPalette(1025,(Color SHR 11) AND 31,(Color SHR 5)AND 31,Color AND 31);
  RealFillColor := Color;
end;

function RealColor(Color : Word) : Word;
begin
  if (GetMaxColor > 256) then
    SetRgbPalette(1026,(Color SHR 10) AND 31,(Color SHR 5)AND 31,Color AND 31);
  RealColor := Color;
end;
