/******************************************************************\
*                                                                  *
*		   w       w                oooo                           *
*		   w       w  iii  n   n   o    o   n   n  eeee            *
*		   w       w   i   nn  n  o      o  nn  n  e               *
*		   w   w   w   i   n n n  o      o  n n n  eee             *
*	  	    w w w w    i   n  nn   o    o   n  nn  e               *
*	 	     w   w    iii  n   n    oooo    n   n  eeee            *
*								   								   *
*     C o m m a n d   L a n g u a g e   I n t e r p r e t e r      *
*								   								   *
*								   								   *
*	Written by Lucien Cinc                                         *
*	Copyright (c) 1992, 1993                                       *
*																   *
*	This library allows programs to preform I/O functions that     *
*	intract with the main WinOne window. Some programs will only   *
*	need to be modified to include this library to compile,   	   *
*	however this will NOT generally be the case. When a program    *
*	uses the FILE streams to write to stdin or stdout, the   	   *
*	output will most likely end up writing to the desktop window.  *
*                                                                  *
*	For example:-                                                  *
*                                                                  *
*		fputc(c, stdout) or putc(c)                                *
*                                                                  *
*	will not write to the main WinOne window, but will still	   *	
*	compile, even though it will not produce the desired result.   *
*	Programs should NOT use any f... stream functions, because     *
*	they do NOT allow windows to multi-task when used inside a     *
*	windows program, that is, functions that use FILE *stream	   *
*	(eg. fopen, fread, fwrite, fclose, fprintf, etc...).		   *
*                                                                  *
*	The I/O functions provided in this library attempt to mimic    *
*	the standard I/O functions as accurately as possible. There    *
*	are also many functions in this library that greatly		   *	
*	simplifies the task of programming commands.				   *
*																   *
*	The entry function main does not include argc and argv         *
*	arguments, these arguments are implemented as functions.       *
*	The arg... functions provided in this library greatly          *
*	simplify the processing of command line arguments.             *
*                                                                  *
*	A module definition file (ie. .DEF file) needs to be           *
*	created. WinOne uses the DESCRIPTION field in the .DEF file	   *	
*	to determine whether a program is an external command. For     *
*	example, consider the following sample .DEF file :-            *
*                                                                  *
*		NAME   			XXXX                                       *
*		DESCRIPTION		'WinOne Command XXXX - Copyright etc...'   *
*		EXETYPE			WINDOWS                                    *
*		CODE			PRELOAD MOVEABLE                           *
*		DATA			PRELOAD MOVEABLE MULTIPLE                  *
*		HEAPSIZE		37888                                      *
*		STACKSIZE		6144                                       *
*                                                                  *
*	The DESCRIPTION field must start with 'WinOne Command'. This   *	
*	string is case sensitive. The 'XXXX' part of this field is     *
*	not currently checked, but will be in latter releases of       *
*	WinOne, so please include it, in capital letters. The rest     *
*	of the string is ignored.         							   *
*                                                                  *
*	The library is compiled using the MEDIUM memory model. This	   *	
*	allows both FAR and NEAR pointers to be used, so compile       *
*	your programs using the MEDIUM memory model. 				   *	
*                                                                  *
*	A sample program :-                                   		   *
*                                                                  *
*		#include "woio.h"                                          *
*                                                                  *
*		void main(void)                                            *
*		{                                                          *
*			printf("Hello, World\n");                              *
*		}                                                          *
*                                                                  *
*																   *
*																   *	
*	Note: When typing this file out from the WinOne prompt, use    *
*		  the /4 switch, since I set tabs to be only 4 space       *
*		  characters. For example :-                               *
*                                                                  *
*				type woio.h /4                                     *
*                                                                  *
\******************************************************************/

#ifndef __WOIO_H
#define __WOIO_H

#include <windows.h>

/*
	include stdio.h here so that the macros putchar
	and getchar	can be removed!
*/

#include <stdio.h>

#ifdef putchar
#undef putchar
#endif	/* putchar */

#ifdef getchar
#undef getchar
#endif	/* getchar */

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#define BLACK			(char )128   /* text colours */
#define	RED     		(char )129
#define GREEN			(char )130
#define BLUE			(char )131
#define YELLOW 			(char )132
#define MAGENTA			(char )133
#define CYAN			(char )134
#define WHITE			(char )135
#define LIGHTGRAY		(char )136
#define LIGHTRED		(char )137
#define LIGHTGREEN		(char )138
#define LIGHTBLUE		(char )139
#define BROWN			(char )140
#define LIGHTMAGENTA	(char )141
#define LIGHTCYAN		(char )142
#define DARKGRAY		(char )143

/*******************************\
*								*
*	    Control Functions		*
*								*
\*******************************/

void more(BOOL flag);					/* buffered screen output */
BOOL isbreak(void);						/* ^C pressed check */

/*******************************\
*								*
*	 Screen Output Functions	*
*								*
\*******************************/

int  printf(const char *fmt, ...);  	/* printf formated output */
int  puts(const char *s);				/* string output + CR-LF */
int  putchar(const int c);				/* character output	*/
int  putch(int c);						/* character output	*/
void perror(const char *msg);			/* display an error message	*/
void textcolor(int col);				/* set the text colour */

void clrscr(void);						/* clear the screen */
void clreol(void);						/* clear till end of line */
void gotoxy(int x, int y);				/* position cursor on screen */
int  wherex(void);						/* location of caret (horizontal) */
int  wherey(void);						/* location of caret (vertical) */

int scrwidth(void);						/* screen width in characters */
int scrheight(void);					/* screen height in character */

/*******************************\
*								*
*	     Input Functions		*
*								*
\*******************************/

int  scanf(const char *fmt, ...);		/* scanf formated input	*/
char *gets(char *s);					/* get a string	*/
int  getchar(void);						/* get a character */
int  getch(void);						/* get a character no echo */

/*******************************\
*								*
*	 Command Line Functions		*
*								*
\*******************************/

int  argc(void);						/* number of arguments */
char *argv(int index);				 	/* get an argument */
int  argn(void);						/* number of switches */
char *args(void);						/* get all switches */

char *argpath(int index);				/* get path argument */
char *argabs(int index);				/* get absolute path argument */
char *argtail(void);					/* get command line tail */
char *argstr(int index);				/* get command line string */
int  argnstr(void);						/* number of command line strings */
BOOL isargstr(int index);				/* is an argument a string */

/*******************************\
*								*
*	   Status Bar Functions		*
*								*
\*******************************/

void limit(unsigned long upper);		/* status bar upper limit */
void inc(unsigned long value);			/* status bar increment by value */
void empty(void);						/* empty status bar */

/*******************************\
*								*
*	 	 File Functions			*
*								*
\*******************************/

#define ATT_RHSDA 	(unsigned int )(FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_DIREC|FA_ARCH)
#define ATT_RHSA 	(unsigned int )(FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_ARCH)

int fillfile(char *path, unsigned int attr);	/* block file fill */
BOOL getfile(int index, struct ffblk *pff);		/* get file ffblk */
char *getfilepath(int index);     				/* get file path, may not be a fully qualified path */
char *getfilename(int index);					/* get file name */
char *padfilename(char *path);                  /* pad a filename for displaying */

/*******************************\
*								*
*	 	 Path Functions			*
*								*
\*******************************/

int fillpath(char *path);				/* block path fill */
int fillpathall(void);					/* block path fill for all drives */
void freepaths(void);					/* free paths */
char *getpath(int index);				/* get a path */
int totalfiles(void);					/* total number of files in paths */

/*******************************\
*								*
*   Unix conversion functions   *
*								*
\*******************************/

char *unixpath(char *path);				/* convert dos path to unix */
char *unixcmd(char *cmd);				/* convert dos command to unix */
int isunix(void);						/* unix mode flag */
char *todospath(char *path);			/* convert unix path to dos */
char *todoscmd(char *cmd);				/* convert unix command to dos */

/*******************************\
*								*
*    Environment Functions		*
*								*
\*******************************/

char *getenvironment(char *name);		/* get WinOne environment variable */
int putenvironment(char *name);			/* set WinOne environment variable */

/*******************************\
*								*
*       Global Variables	    *
*								*
\*******************************/

extern char *arg_v[];			/* argv */
extern int arg_c;				/* argc */

extern int main(void);	/* program entry point */

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif	/* __WOIO_H */
