/*
   Cx interface.
   Copyright (c) 1990-1994 Eugene Nelson, Four Lakes Computing.
*/

#ifndef __CX__
#define __CX__
/*-------------------------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif

#ifdef CXANSI
   typedef unsigned char *CXBUFF;
   #define CXCALL
   #define CXFAR16
#elif CX32BIT
   typedef unsigned char *CXBUFF;
   #define CXCALL __far16 pascal
   #define CXFAR16 __far16
#else
   typedef unsigned char far *CXBUFF;
   #define CXCALL far pascal
   #define CXFAR16
#endif


typedef unsigned short     CXINT;
typedef long               CXLNG;

#define CXINTSIZE          (sizeof(CXINT))

#define CX_ERR_INVALID     (65535u - 0)
#define CX_ERR_METHOD      (65535u - 1)
#define CX_ERR_BUFFSIZE    (65535u - 2)
#define CX_ERR_TEMPSIZE    (65535u - 3)

#define CX_METHOD1         (1)
#define CX_METHOD2         (2)
#define CX_METHOD3         (3)
#define CX_METHODC         (4)
#define CX_METHODD         (5)

#define CX_MAX_BUFFER      (65000u)
#define CX_SLOP            (300)

#define CX_C_MINTEMP       (18 * 1024)
#define CX_C_MAXTEMP       (65500u)
#define CX_D_MINTEMP       (7 * 1024)


#ifndef NOPROTO
   CXINT CXCALL CX_COMPRESS(
         CXINT    method,
         CXBUFF   CXFAR16 obuff,
         CXINT    osize, 
         CXBUFF   CXFAR16 ibuff,
         CXINT    isize,
         CXBUFF   CXFAR16 tbuff,
         CXINT    tsize);

   CXINT CXCALL CX_DECOMPRESS(
         CXBUFF   CXFAR16 obuff,
         CXINT    osize, 
         CXBUFF   CXFAR16 ibuff,
         CXINT    isize,
         CXBUFF   CXFAR16 tbuff,
         CXINT    tsize);

   CXINT CXCALL CX_CRC(
         CXBUFF   CXFAR16 buff,
         CXINT    bytes);
#endif

#ifdef __cplusplus
}
#endif
/*-------------------------------------------------------------------------*/
#endif
