@echo off
if "%1" == "" goto :usage
del cxf.exe

if "%1" == "bc" goto :BC
if "%1" == "bcpp" goto :BCPP
if "%1" == "bcwin" goto :BCWIN
if "%1" == "bcdll" goto :BCDLL
if "%1" == "mc" goto :MC
if "%1" == "mcpp" goto :MCPP
if "%1" == "mcwin" goto :MCWIN
if "%1" == "mcdll" goto :MCDLL
if "%1" == "zc" goto :ZC
if "%1" == "tp" goto :TP

:usage
echo ------------------------------------------------------------------
echo This batch file creates CXF.EXE.
echo YOU MUST RUN OCM.EXE FIRST TO EXTRACT OBJECT CODE.
echo ------------------------------------------------------------------
echo mcxf bc    -  Borland C/C++      MS-DOS   -  using CX.OBJ
echo mcxf bcpp  -  bc and force CPP   MS-DOS   -  using CX.OBJ
echo mcxf mc    -  Microsoft C        MS-DOS   -  using CX.OBJ
echo mcxf mcpp  -  mc and force CPP   MS-DOS   -  using CX.OBJ
echo mcxf zc    -  Zortech C/C++      MS-DOS   -  using CX.OBJ
echo mcxf tp    -  Turbo Pascal       MS-DOS   -  using CX.OBJ
echo mcxf bcwin -  Borland C/C++      Windows  -  using CX.OBJ
echo mcxf bcdll -  Borland C/C++      Windows  -  using CXWIN.DLL
echo mcxf mcwin -  Microsoft C/C++    Windows  -  using CX.OBJ
echo mcxf mcdll -  Microsoft C/C++    Windows  -  using CXWIN.DLL
echo ------------------------------------------------------------------
echo When using a C/C++ compiler:
echo    set CXINC=include directory (no backslash, like c:\msvc\include)
echo    set CXLIB=library directory (no backslash, like c:\msvc\lib)
echo ------------------------------------------------------------------
goto :end


:BC
bcc -v -I%CXINC% -L%CXLIB% -w -mc -O2 cxf.c cx.obj
goto :end

:BCPP
bcc -v -I%CXINC% -L%CXLIB% -w -mc -O2 -P cxf.c cx.obj
goto :end

:BCWIN
bcc -v -I%CXINC% -L%CXLIB% -w -mc -O2 -WS -DNOKBHIT cxf.c cx.obj winio.obj
rc cxf.exe
goto :end

:BCDLL
bcc -v -I%CXINC% -L%CXLIB% -w -mc -O2 -WS -DNOKBHIT cxf.c cxwin.lib winio.obj
rc cxf.exe
goto :end

:MC
set lib=%CXLIB%
cl -Zi -I%CXINC% -W3 -AC -O2 -Gs cxf.c cx.obj
goto :end

:MCPP
set lib=%CXLIB%
cl -Zi -I%CXINC% -W3 -AC -O2 -Gs -Tpcxf.c cx.obj
goto :end

:MCWIN
set lib=%CXLIB%
cl -Zi -I%CXINC% -W3 -AC -O2 -Gs -Mq -DNOKBHIT cxf.c cx.obj
goto :end

:MCDLL
set lib=%CXLIB%
cl -Zi -I%CXINC% -W3 -AC -O2 -Gs -Mq -DNOKBHIT cxf.c cxwin.lib
goto :end

:ZC
ztc -c -ml -I%CXINC%
blink cxf cx,,,%CXLIB%
goto :end

:TP
tpc  cx
tpc  cxsub
tpc  /V cxf
goto :end

:end
