/* This program demonstrates the use of the functions in TIMER.C.  */
/* By Jim Dos.  This program is released to the public domain and */
/* may be used in your own programs.  Leave me a note if you find  */
/* it helpful!                                                     */
/* On CompuServe: Jim Dose' 76346,2061                             */
/* On AOL:        JimDose                                          */

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include "timer.h"

void main( void )
{
    struct   time t;
    unsigned long OurCount;

    /* Init timer to 1000 ticks per second.  This function must */
    /* be called before the time will operate.                  */

    InitTimer( 1000 );

    /* Loop until a key is pressed. */

    while( !kbhit() )
    {
        /* These next two lines are from Borland C's on-line help */
        /* for the gettime() function.  They are not required for */
        /* use of the routines in TIMER.C, but are only included  */
        /* to demonstrate that the internal clock still works.    */

        /* Get the current time */

        gettime(&t);
        printf( "The current time is: %2d:%02d:%02d.%02d",
                t.ti_hour, t.ti_min, t.ti_sec, t.ti_hund );

        /* Get the value of the counter from our function. */

        OurCount = GetCounter();
        printf( "\tTimer: %lu\n", OurCount );
    }

    /* Clear the key that was pressed. */

    getch();

    /* This time, we'll set the rate to 100 ticks per second.   */
    /* Use SetClockRate() whenever you want to change the speed */
    /* of the timer after it has been initialized.              */

    SetClockRate( 100 );

    /* The SetCounter() function allows us to set the timer to */
    /* whatever value we want.  In this case, to zero.         */

    SetCounter( 0 );

    while( !kbhit() )
    {
        /* Get the current time */

        gettime(&t);
        printf( "The current time is: %2d:%02d:%02d.%02d",
                t.ti_hour, t.ti_min, t.ti_sec, t.ti_hund );

        /* Get the value of the counter from our function. */

        OurCount = GetCounter();
        printf( "\tTimer: %lu\n", OurCount );
    }

    /* Clear the key that was pressed. */

    getch();

    /* Before we exit, we MUST call RestoreTimer().  This returns   */
    /* the interrupt back to normal.  Failure to call this function */
    /* when you're done could cause your program to crash!          */

    RestoreTimer();
}
