/* TIMER.C - These routines demonstrate redirection of Interrupt 8 */
/* for use in programs where high-resolution timing is critical.   */
/* By Jim Dos.  This program is released to the public domain and */
/* may be used in your own programs.  Leave me a note if you find  */
/* it helpful!                                                     */
/* On CompuServe: Jim Dose' 76346,2061                             */
/* On AOL:        JimDose                                          */

#include <dos.h>
#include "timer.h"

#define  FALSE   0
#define  TRUE    ( !FALSE )

static   void interrupt ( *OldInt8Handler )( void );
static   char           TimerInstalled = FALSE;
static   long           ServiceTimerRate = 0x10000L;
static   volatile long  ServiceTimerCount = 0;

static   volatile unsigned long Counter = 0;

void Set8253Rate( int speed )
{
    if ( TimerInstalled )
    {
        ServiceTimerRate = speed ? speed : 0x10000L;
        outportb( 0x43, 0x36 );
        outportb( 0x40, speed );
        outportb( 0x40, speed >> 8 );
    }
}

void SetClockRate( int TicksPerSecond )
{
    Set8253Rate( (int)( 1192030L / TicksPerSecond ) );
}

static void interrupt NewInt8Handler( void )
{
    ServiceTimerCount += ServiceTimerRate;
    Counter++;

/*  Here would be a good place to put a call to a function */
/*  to play music in the background.                       */

    if ( ServiceTimerCount > 0xffff )
    {
        ServiceTimerCount &= 0xffff;
        OldInt8Handler();               /* Keep system clock happy */
    }
    outportb( 0x20, 0x20 );             /* Issue End of interrupt */
}

void InitTimer( int TicksPerSecond )
{
    if ( !TimerInstalled )
    {
        ServiceTimerRate = 0x10000L;
        ServiceTimerCount = 0;
        Counter = 0;
        OldInt8Handler = getvect( 8 );
        setvect( 8, NewInt8Handler );
        TimerInstalled = TRUE;
    }
    SetClockRate( TicksPerSecond );
}

void RestoreTimer( void )
{
    if ( TimerInstalled )
    {
        Set8253Rate( 0 );
        setvect( 8, OldInt8Handler );
        TimerInstalled = FALSE;
    }
}

unsigned long GetCounter( void )
{
    return( Counter );
}

void SetCounter( unsigned long count )
{
    Counter = count;
}
