//lRegen_FileHeading
//lRegen_FileHeading

     /********************************************************************
      *
      *   Source File:  leapfrog.c                                        
      *   Author:       Ray Cirincione                                    
      *   Module:       Source for leapfrog application                   
      *   Program Desc: LeapFrog dialogs                                                                
      *   Date:         Mon Dec 06 16:06:11 1993                          
      *
      ********************************************************************/

#include "LeapFrog.h"

//lRegen_Variables
//lRegen_Variables

LRESULT CALLBACK __export MainWndProc(HWND, UINT, WPARAM, LPARAM);
#pragma argsused

int PASCAL WinMain(HINSTANCE hInstance,      // Application Instance Handle
                   HINSTANCE hPrevInstance,  // Previous Instance Handle
                   LPSTR  lpszCmdLine,       // Pointer to Command Line
                   int    nCmdShow)          // Show Window Option
{
   //lRegen_BeginFunction
   //lRegen_BeginFunction

   MSG      msg;
   HWND     hWndMain;

   HMODULE hBorLibrary;

   HMODULE hWinControl;

   WNDCLASS wndclass;
   
hBorLibrary = LoadLibrary("bwcc.dll");
   if((UINT)hBorLibrary <= 32)
      MessageBox(NULL, "Unable to load Borland Controls", "System Error", MB_OK | MB_ICONHAND);
   
hWinControl = LoadLibrary("Winctl.dll");
   if((UINT)hWinControl <= 32)
      MessageBox(NULL, "Unable to load WinControl Library", "System Error", MB_OK | MB_ICONHAND);
   hInst = hInstance;

   lstrcpy(szAppName, "leapfrog");

   if(!hPrevInstance)
   {
      wndclass.style           = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc     = MainWndProc;
      wndclass.cbClsExtra      = 0;
      wndclass.cbWndExtra      = 0;
      wndclass.hInstance       = hInstance;
      wndclass.hCursor         = LoadCursor(NULL, IDC_ARROW);
      wndclass.hIcon           = NULL;
      wndclass.hbrBackground   = CreateSolidBrush(GetSysColor(COLOR_WINDOW));
      wndclass.lpszMenuName    = "leapfrog";
      wndclass.lpszClassName   = szAppName;

      if(!RegisterClass(&wndclass))
         return FALSE;
   }

   //lRegen_InitView
   //lRegen_InitView

   if(!(hWndMain = CreateWindow(szAppName,
                       "LeapFroging Dialogs Example",
                       WS_OVERLAPPEDWINDOW,
                       CW_USEDEFAULT, 0,
                       CW_USEDEFAULT, 0,
                       NULL, (HMENU)NULL, hInstance, NULL)))
        return FALSE;

   //lRegen_MainWnd
   hMain=hWndMain;		// ************** this is added
   //lRegen_MainWnd

   ShowWindow(hWndMain, nCmdShow);
   UpdateWindow(hWndMain);

   while(GetMessage(&msg, NULL, 0, 0))
          {
             TranslateMessage(&msg);
             DispatchMessage(&msg);
          }

   if((UINT)hBorLibrary > 32)
      FreeLibrary(hBorLibrary);

   if((UINT)hWinControl > 32)
      FreeLibrary(hWinControl);

   //lRegen_AppTerm
   //lRegen_AppTerm
   return msg.wParam;
}

LRESULT CALLBACK __export MainWndProc(HWND hWnd, UINT wMessage, WPARAM wParam, LPARAM lParam)
{

   //lRegen_WindowProcVariables
   //lRegen_WindowProcVariables

   switch(wMessage)
   {
      //lRegen_WndProc
      //lRegen_WndProc

      case WM_CREATE :
         //Regen_WM_CREATE
         //Regen_WM_CREATE
         return TRUE;

      case WM_COMMAND :
         if(!LOWORD(lParam))
         {                             // Process Menu Commands
            switch(wParam)          // Determine which Menu ID
            {
            case IDM1_DIALOGBOX :
               //lRegen_Start_DIALOGBOX
               //lRegen_Start_DIALOGBOX
               if(fnFirst(hWnd, 0, NULL))
               {
               }
               //Regen_End_DIALOGBOX
               //Regen_End_DIALOGBOX
               break;
            case IDM1_THIRDDIALOG :
               //lRegen_Start_THIRDDIALOG
               //lRegen_Start_THIRDDIALOG
               if(fnThird(hWnd, 0, NULL))
               {
               }
               //Regen_End_THIRDDIALOG
               //Regen_End_THIRDDIALOG
               break;

            }
         }
         else
         {
            //Regen_CustomCommand
            //Regen_CustomCommand

            switch(wParam)
            {
            }
         }
         break;

      case WM_DESTROY :

         //lRegen_WM_DESTROY
         //lRegen_WM_DESTROY

         PostQuitMessage(0);
         break;

      default :
         return DefWindowProc(hWnd, wMessage, wParam, lParam);
   }
   return DefWindowProc(hWnd, wMessage, wParam, lParam);
}

//Regen_CustomCode
//Regen_CustomCode
