#include <dos.h>
#include <conio.h>
#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <alloc.h>
#include <graphics.h>
#define EXTCDECL extern
#include "goh.c"


#define VIDEO 0x10
#define CONSOLE 0x21


/*
	title	'some IBM screen and keyboard interrupts'
; screen is int 010h
; keyboard is int 016h
	name	dos
;
;video interrupt 010h
;
; ah=0  set mode
;	    alpha modes
;	        al=0  =>  40X25 BW
;		al=1  =>  40X25 clr
;		al=2  =>  80X25 BW
;		al=3  =>  80X25 clr
;	    graphic modes
;		al=4  =>  320X200 clr
;		al=5  =>  320X200 BW
;		al=6  =>  640X200 BW
;		al=7  =>  80X25 ??? internal mode
;
; ah=1 set cursor type
;		ch = bits 4-0 = start line for cursor
;		cl = bits 4-0 = end line for cursor
;
; ah=2 set cursor posn
;		(dh,dl)=(row,col) (0,0) is upper left
;		bh = page number (0 for graphics)
;
; ah=3 read cursor
;		returned in (dh,dl)?
;		bh = 0 for graphics
;
; ah=4 read light pen position
;		ah=0 on exit  =>  light pen sw not pressed
;		ah=1  =>  valid light pen values
;			(dh,dl) = (row,col) of character position
;			ch = raster line (0-199)
;			bx = pixel column (0-319)
;
; ah=5 select display page (alpha only)
;		al = new page value = 0-7 for modes 0,1
;				    = 0-3 for modes 2,3
;
; ah=6 scroll up
;		no doc
;
; ah=7 scroll down
;		no doc
;
; ah=8 read attribute/char at current cursor
;		bh = page (alpha only)
;		al = char on exit
;		ah = attribute on exit (alpha only)
;
; ah=9 write attribute/char at cursor
;		bh = page (alpha only)
;		cx = # of chars to write
;		al = char to write
;		bl = attribute(alpha)/colour(graphics)
;			bit 7 => XOR if on
;
; ah=10 write char only at cursor
; 		bh = page (alpha)
;		cx = count of chars
;		al = char to write
;
; ah=11 set colour palette
;		bh = palette colour ID being set (0-127)
;		bl = colour value to be used with that colour ID
;			(320X200 graphics only)
;		colour (ID=0) selects background colour (0-15)
;		colour (ID=1) slects palette: 0 => grn(1)/red(2)/yel(3)
;					      1 => cya(1)/mag(2)/wht(3)
;		in alpha modes the value set for palette colour zero
;		indicates border colour to be used (0-31) where 16-31
;		selects high-intensity set
;
; ah=12 write dot (see ah=13 read dot)
;		see read dot for reg set-up
;
; ah=13 read dot (return in al)
; 	returns	dx = row 0-199
;		cx = col 0-639
;		al = dot value to write (1,2,4 bits depending on mode)
;			bit 7 = 1  => XOR into memory
;		ds = data segment
;		es = video memory (0b800h)
*/


void scr_cursoff()
{
 union REGS regs;
 regs.h.ah = 1;
 regs.x.cx = 0xf00;
 int86(VIDEO, &regs, &regs);
}

void scr_curson()
{
 union REGS regs;
 regs.h.ah = 1;
 regs.x.cx = 0xc0d;
 int86(VIDEO, &regs, &regs);
}

void scr_mark(code, attr)  /* attr=7 for normal, 112 for inverse video */
int code;
int attr;
{
 union REGS regs;
 regs.x.ax = code;
 regs.x.bx = attr;
 regs.x.cx = 1;
 regs.h.bh = 0;
 regs.h.ah = 9;
 int86(VIDEO, &regs, &regs);
}

void scr_rowcol(row,col)
int row;
int col;
{
 union REGS regs;
 regs.h.dh = row;
 regs.h.dl = col;
 regs.h.bh = 0;
 regs.h.ah = 2;
 int86(VIDEO, &regs, &regs);
}

int scr_sinp()
{
 union REGS regs;
 int value;
 regs.h.bh = 0;
 regs.h.ah = 8;
 int86(VIDEO, &regs, &regs);
 return(regs.x.ax);
}

void scr_co(ascii)   /* put char on screen and move cursor */
int ascii;
{
 union REGS regs;
 regs.h.al = ascii;
 regs.h.bh = 0;
 regs.h.ah = 14;
 int86(VIDEO, &regs, &regs);
}

int scr_csts()   /* keyboard status returns 0 if no key ... ascii otherwise */
{
 union REGS regs;
 regs.h.dl = 0xff;
 regs.h.ah = 6;       /* keyboard status direct console i/o */
 int86(CONSOLE, &regs, &regs);
 regs.h.ah = 0;
 return(regs.x.ax);
}




/* a bit of grafix for BGI */

/* get Borland graphics memory allocation from far heap */
void far *far _graphgetmem(unsigned size)
{
 return(farmalloc(size));
}

void far _graphfreemem(void far *ptr, unsigned size)
{
 farfree(ptr);
 size = size; /* this is only to get rid of warning message */
}

void opengraph()   /* call this in main before any malloc's */
{                  /* call Borland closegraph at end of prog */
 int driver, mode, error;
 setgraphbufsize(100);
 driver = 0;
 initgraph(&driver, &mode, ""); /* .BGI file must be in directory */
 settextstyle(2, 0, 0);  /* with LITT.CHR small font in directory */
}

void iprintf(const char *format , int arg)
{
 /* printf one int in graphics mode */
 char buffer[100];
 sprintf(buffer, format, arg);
 outtext(buffer);
}

void dprintf(const char *format , double arg)
{ /* printf one double (or float) in graphics mode */
 char buffer[100];
 sprintf(buffer, format, arg);
 outtext(buffer);
}


/* zplt,zymbol,... positioning is written for Hercules 719 X 347 */
/* device independence is attained by rescaling using hercx, hercy */
/* therefore call ONLY the 'z' routines for positioning */
/* (or rescale by ratio to Hercules as in hercx, hercy) */
/* (0,0) in 'z' system is at lower left of screen, Cartesian style */

unsigned hercx(x)
{  /* translates from Hercules x to whatever x available */
 long xx;
 if (getmaxx() != 719) {
  xx = x;
  xx *= getmaxx();
  xx /= 719;
  x = xx;
 }
 return(x);
}

unsigned hercy(y)
{  /* translates from Hercules y */
 long yy;
 yy = 347 - y;
 if (getmaxy() != 347) {
  yy *= getmaxy();
  yy /= 347;
 }
 y = yy;
 return(y);
}

void zplt(x, y, ipen) /* ipen=0 means pen up, =1,2 for pen down */
int x, y, ipen;   /* ipen=1,2 means thin,thick line width */
{
 x = hercx(x);
 y = hercy(y);
 if (!ipen) moveto(x, y);
 else lineto(x, y);
}

unsigned zget(x, y)
int x, y;
{
 x = hercx(x);
 y = hercy(y);
 return(getpixel(x, y));
}

void zput(x, y, pixval)
int x, y, pixval;
{
 x = hercx(x);
 y = hercy(y);
 putpixel(x, y, pixval);
}

void zymbol(x, y, string) /* puts text to screen at x,y */
int x, y;
char *string;
{
 x = hercx(x);
 y = hercy(y);
 moveto(x, y);
 outtext(string);
 moveto(x+1, y);
 outtext(string);
}

void zline(x1, y1, x2, y2)
int x1, y1, x2, y2;
{
 x1 = hercx(x1);
 y1 = hercy(y1);
 x2 = hercx(x2);
 y2 = hercy(y2);
 /* setlinestyle(4, 0xffff, 1);*/
 setlinestyle(0,0,1);
 line(x1, y1, x2, y2);
}

void zfillquad(x1, y1, x2, y2, x3, y3, x4, y4)
int x1, y1, x2, y2, x3, y3, x4, y4;
{
 int numpoints, poly[10];
 numpoints = 5;
 poly[0] = hercx(x1);
 poly[1] = hercy(y1);
 poly[2] = hercx(x2);
 poly[3] = hercy(y2);
 poly[4] = hercx(x3);
 poly[5] = hercy(y3);
 poly[6] = hercx(x4);
 poly[7] = hercy(y4);
 poly[8] = hercx(x1);
 poly[9] = hercy(y1);
 setlinestyle(4, 0, 1);
 fillpoly(numpoints, poly);
 setlinestyle(0, 0, 1);
}

void zfillrect(x1, y1, x2, y2)
int x1, y1, x2, y2;
{
 int numpoints, poly[10];
 numpoints = 5;
 poly[0] = hercx(x1);
 poly[1] = hercy(y1);
 poly[2] = hercx(x2);
 poly[3] = hercy(y1);
 poly[4] = hercx(x2);
 poly[5] = hercy(y2);
 poly[6] = hercx(x1);
 poly[7] = hercy(y2);
 poly[8] = hercx(x1);
 poly[9] = hercy(y1);
 setlinestyle(4, 0, 1);
 fillpoly(numpoints, poly);
 setlinestyle(0, 0, 1);
}

void zfillpoly(numpoints, poly)   /* note poly is altered */
int numpoints, poly[];
{
 int i;
 for (i=0; i<=numpoints-1; ++i) {
  poly[i+i] = hercx(poly[i+i]);
  poly[i+i+1] = hercy(poly[i+i+1]);
 }
 fillpoly(numpoints, poly);
 moveto(poly[0], poly[1]);
 for (i=1; i<=numpoints-1; ++i) lineto(poly[i+i], poly[i+i+1]);
}

void zfillellipse(x, y, xradius, yradius)
int x, y, xradius, yradius;
{
 x = hercx(x);
 y = hercy(y);
 xradius = hercx(xradius);
 yradius *= getmaxy();
 yradius /= 347;
 fillellipse(x, y, xradius, yradius);
}

/*
void paws()
{
 int huh;
 zymbol(600, 15, "press a key ");
 huh = getch();
 iprintf("OK", 0);
 if (huh == 3) {
  restorecrtmode();
  _exit(0);
 }
}
*/

void gauzefill()
{
 int i;
 char upattern[8] = {0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55};
 setfillpattern(upattern,0);
}

void blackfill()
{
 int i;
 char upattern[8] = {0, 0, 0, 0, 0, 0, 0, 0};
 setfillpattern(upattern,0);
}

void whitefill()
{
 int i;
 char upattern[8] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
 setfillpattern(upattern,0);
}

void newplt()
{
 blackfill();
 zfillrect(0, 0, 719, 347);
 setcolor(BLACK);
 zplt(0, 0, 0);
 zplt(719, 0, 1);
 zplt(719,347, 1);
 zplt(0, 347, 1);
 zplt(0, 0, 1);
 setcolor(WHITE);
 zplt(0, 0, 0);
 zplt(719, 0, 1);
 zplt(719,347, 1);
 zplt(0, 347, 1);
 zplt(0, 0, 1);
}

void newgauze()
{
 gauzefill();
 zfillrect(0, 0, 719, 347);
 setcolor(BLACK);
 zplt(0, 0, 0);
 zplt(719, 0, 1);
 zplt(719,347, 1);
 zplt(0, 347, 1);
 zplt(0, 0, 1);
 setcolor(WHITE);
 zplt(0, 0, 0);
 zplt(719, 0, 1);
 zplt(719,347, 1);
 zplt(0, 347, 1);
 zplt(0, 0, 1);
}




