// Program : TCOLTXT.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Fri 01/14/94 20:18:19
// Note    : Hereby declared public domain
// Compiler: Borland C++ 3.1
//
// NOTE: If compiling this *without* the changes to the TV library described
//       in COLUPDT.DOC, be sure that UNMODIFIED_TURBO_VISION is #defined
//       in TVCOLR.H!
//
// Member functions for the TColorText class.  Demonstrates the use of the
// concepts described in TVCOLR.DOC.
//
// TColorText is derived from TStaticText.  It adds the ability to use
// color for the data displayed.  One of five color types can be used.
//
//      1. Normal Color Text (just like TStaticText)
//      2. Information Color Text
//      3. Notification Color Text
//      4. Warning Color Text
//      5. Error Color Text
//
// This makes use of TVCOLR.H so the colors are modifiable via a
// TColorDialog object.
//

#include <ctype.h>
#include <string.h>

#define Uses_TDrawBuffer
#define Uses_TStaticText
#define Uses_TStreamableClass
#define Uses_TVCOLR             // Use this if you modified the TV.H file.
#define Uses_ipstream
#define Uses_opstream
#include <tv.h>

__link( RStaticText)

#if !defined(cpDefSize)
// Use this if you choose not to modify the Turbo Vision files.
#include <tvcolr.h>
#endif

#include <tcoltxt.h>        // The TColorText header file.

// ****************************************************************************
// Create a character array where each element is a color index.
// This forms the palette for the object.

char cpColorText[] = { '\x06', cCTxtInfoColor, cCTxtNotifyColor,
                               cCTxtWarnColor, cCTxtErrorColor };

// ****************************************************************************
// Make it streamable.
//
const char * const near TColorText::name = "TColorText";

TStreamableClass RColorText(TColorText::name, TColorText::build,
    __DELTA(TColorText));

void TColorText::write(opstream &os)
{
    TStaticText::write(os);
    os << ColorType;
}

void *TColorText::read(ipstream &is)
{
    TStaticText::read(is);
    is >> ColorType;
    return this;
}

TStreamable *TColorText::build()
{
    return new TColorText( streamableInit );
}

// ****************************************************************************
TPalette& TColorText::getPalette() const
{
    // Note the lack of a "- 1" after the sizeof().  There is no NULL on
    // this type of palette because it is a simple array, not a string.
    // Don't account for one!
    static TPalette palette( cpColorText, sizeof( cpColorText) );
    return palette;
}

void TColorText::draw()
{
    TDrawBuffer b;
    Boolean center = False;

    uchar color = getColor(1 + ColorType);        // Get the right color.
    int startPos, wrapPos, len, pos, curLine;
    char s[256];

    getText(s);
    len = strlen(s);
    pos = curLine = 0;

    // Draw each line.
    while(curLine < size.y)
    {
        b.moveChar(0, ' ', color, size.x);

        // Fill in line if not at the end of the string.
        if(pos < len)
        {
            // Center the line?
            if(s[pos] == '\003')
            {
                center = True;
                ++pos;
            }

            startPos = pos;

            // Find end of line.
            do
            {
               wrapPos = pos;

               while(pos < len && s[pos] == ' ')
                   ++pos;

               while(pos < len && s[pos] != ' ' && s[pos] != '\n')
                   ++pos;

            } while(pos < len && pos < startPos + size.x && s[pos] != '\n');

            // Word wrap the text?
            if(pos > startPos + size.x)
                if(wrapPos > startPos)
                    pos = wrapPos;
                else
                    pos = startPos + size.x;

            if(center)
               wrapPos = (size.x - pos + startPos) / 2 ;
            else
               wrapPos = 0;

            b.moveBuf(wrapPos, &s[startPos], color, (pos - startPos));

            // Skip trailing blanks.
            while((pos < len) && (s[pos] == ' '))
                pos++;

            // If line ended in a line feed, skip it and turn
            // off centering.
            if(pos < len && s[pos] == '\n')
            {
                center = False;
                pos++;
            }
        }
        writeLine(0, curLine++, size.x, 1, b);
    }
}
