/* SMBLIB.H */

#ifndef _SMBLIB_H
#define _SMBLIB_H

#include <io.h>
#include <dir.h>
#include <time.h>
#include <alloc.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#define GLOBAL extern	/* turn smbvars.c files into header */

#include "smbvars.c"

int 	smb_open();
int 	smb_open_da(int retry_time);
int 	smb_open_ha(int retry_time);
int 	smb_create(ulong max_crcs, ulong max_msgs, ushort max_age
				  ,int retry_time);
int 	smb_trunchdr(int retry_time);
int 	smb_locksmbhdr(int retry_time);
int 	smb_getstatus(smbstatus_t *hdr);
int 	smb_putstatus(smbstatus_t hdr);
int 	smb_unlocksmbhdr();
int 	smb_getmsghdroff(smbmsg_t *msg);
int 	smb_getmsghdrlen(smbmsg_t msg);
long	smb_getmsgdatlen(smbmsg_t msg);
int 	smb_lockmsghdr(smbmsg_t msg, int retry_time);
int 	smb_getmsghdr(smbmsg_t *msg);
int 	smb_unlockmsghdr(smbmsg_t msg);
int 	smb_addcrc(ulong max_crcs, ulong crc, int retry_time);
int 	smb_hfield(smbmsg_t *msg, ushort type, ushort length, void *data);
int 	smb_dfield(smbmsg_t *msg, ushort type, ulong length);
int 	smb_addmsghdr(smbmsg_t *msg, smbstatus_t *status, int fast
				,int retry_time);
int 	smb_putmsghdr(smbmsg_t msg);
void	smb_freemsgmem(smbmsg_t msg);
long	smb_hdrblocks(ulong length);
long	smb_datblocks(ulong length);
long	smb_allochdr(ulong length);
long	smb_fallochdr(ulong length);
long	smb_allocdat(ulong length, ushort headers);
long	smb_fallocdat(ulong length, ushort headers);
int 	smb_incdat(ulong offset, ulong length, ushort headers);
int 	smb_freemsg(smbmsg_t msg);
int 	smb_freemsgdat(ulong offset, ulong length, ushort headers);
int 	smb_freemsghdr(ulong offset, ulong length);

#endif /* Don't add anything after this #endif statement */
