/* VIDSHOW.C, sample C program to show the simplest way to play */
/* back a .VDO file from within a program.	Simply include VPLAY.H */
/* and link to VPLAY.LIB */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>

#include "vplay.h"    // Include video play header.


char far * far fmalloc(long int size);
void far ffree(char far *tmp);

unsigned char far * far memalloc(long int siz)
{
		return(farmalloc(siz));  // DOS far memory allocation functions
}

void far memfree(char far *memory)
{
		farfree(memory);
}


void main(int argc,char **argv)
{
	int xloc=0,yloc=0;
	char far *buff;
	char fname[80];

	if ( argc != 2 )
	{
		printf("Usage: VIDPLAY <FNAME>\n");
		printf("Where:\n");
		printf("  FNAME is a file name with the assumed extension of .VDO.\n");
		printf("  VIDPLAY plays back video files compressed with VIDCMP.\n");
		exit(1);
	}

	VDOVidOn();

	strcpy(fname,argv[1]);
	strcat(fname,".VDO");

	if ( SetVDO(fname, NOFADE, MCGA1 ) ) // If VDO file is available.
	{

		do
		{
			PlayVDOFrame(xloc,yloc,FULLSIZE,VIDSCREEN);
		} while ( !kbhit() );

		CloseVDO();
	}

	VDOVidOff();
}

