;  TEST8015.ASM - Test file for 8051 disassembler
;
;  18-Jun-93 BY JOHN HARTMAN
;  22-Jul-93 JLH fix AJMPs to all pages
;  17-Sep-93 JLH test subroutine call and return
;
;  EQUATES FOR ADDRESS MODES
        .equ    NN,H'12         ;IMMEDIATE 8
        .equ    MM,H'56
        .equ    NNNN,H'1234     ;IMMEDIATE 16

        .org     H'F000

LLLL:   NOP                     ; 00
        AJMP     LLLL + H'000   ; 01
        LJMP     LLLL           ; 02
        RR      A               ; 03
        INC     A               ; 04
        INC     NN              ; 05
        INC     @R0             ; 06
        INC     @R1             ; 07
        INC     R0              ; 08
        INC     R1              ; 09
        INC     R2              ; 0A
        INC     R3              ; 0B
        INC     R4              ; 0C
        INC     R5              ; 0D
        INC     R6              ; 0E
        INC     R7              ; 0F

        JBC     NN,LLLL         ; 10
        ACALL   LLLL + H'000    ; 11
        LCALL   LLLL            ; 12
        RRC     A               ; 13
        DEC     A               ; 14
        DEC     NN              ; 15
        DEC     @R0             ; 16
        DEC     @R1             ; 17
        DEC     R0              ; 18
        DEC     R1              ; 19
        DEC     R2              ; 1A
        DEC     R3              ; 1B
        DEC     R4              ; 1C
        DEC     R5              ; 1D
        DEC     R6              ; 1E
        DEC     R7              ; 1F

        JB      NN,LLLL         ; 20
        AJMP    LLLL + H'100    ; 21
        RET                     ; 22
        RL      A               ; 23
        ADD     A,#NN           ; 24
        ADD     A,NN            ; 25
        ADD     A,@R0           ; 26
        ADD     A,@R1           ; 27
        ADD     A,R0            ; 28
        ADD     A,R1            ; 29
        ADD     A,R2            ; 2A
        ADD     A,R3            ; 2B
        ADD     A,R4            ; 2C
        ADD     A,R5            ; 2D
        ADD     A,R6            ; 2E
        ADD     A,R7            ; 2F

        JNB     NN,LLLL         ; 30
        ACALL   LLLL + H'100    ; 31
        RETI                    ; 32
        RLC      A              ; 33
        ADDC     A,#NN          ; 34
        ADDC     A,NN           ; 35
        ADDC     A,@R0          ; 36
        ADDC     A,@R1          ; 37
        ADDC     A,R0           ; 38
        ADDC     A,R1           ; 39
        ADDC     A,R2           ; 3A
        ADDC     A,R3           ; 3B
        ADDC     A,R4           ; 3C
        ADDC     A,R5           ; 3D
        ADDC     A,R6           ; 3E
        ADDC     A,R7           ; 3F

        JC      LLLL            ; 40
        AJMP    LLLL + H'200    ; 41
        ORL     NN,A            ; 42
        ORL     NN,#MM          ; 43
        ORL     A,#NN           ; 44
        ORL     A,NN            ; 45
        ORL     A,@R0           ; 46
        ORL     A,@R1           ; 47
        ORL     A,R0            ; 48
        ORL     A,R1            ; 49
        ORL     A,R2            ; 4A
        ORL     A,R3            ; 4B
        ORL     A,R4            ; 4C
        ORL     A,R5            ; 4D
        ORL     A,R6            ; 4E
        ORL     A,R7            ; 4F

        JNC     LLLL            ; 50
        ACALL   LLLL + H'200    ; 51
        ANL     NN,A            ; 52
        ANL     NN,#MM          ; 53
        ANL     A,#NN           ; 54
        ANL     A,NN            ; 55
        ANL     A,@R0           ; 56
        ANL     A,@R1           ; 57
        ANL     A,R0            ; 58
        ANL     A,R1            ; 59
        ANL     A,R2            ; 5A
        ANL     A,R3            ; 5B
        ANL     A,R4            ; 5C
LLL2:   ANL     A,R5            ; 5D
        ANL     A,R6            ; 5E
        ANL     A,R7            ; 5F

        JZ      LLL2            ; 60
        AJMP    LLLL + H'300    ; 61
        XRL     NN,A            ; 62
        XRL     NN,#MM          ; 63
        XRL     A,#NN           ; 64
        XRL     A,NN            ; 65
        XRL     A,@R0           ; 66
        XRL     A,@R1           ; 67
        XRL     A,R0            ; 68
        XRL     A,R1            ; 69
        XRL     A,R2            ; 6A
        XRL     A,R3            ; 6B
        XRL     A,R4            ; 6C
        XRL     A,R5            ; 6D
        XRL     A,R6            ; 6E
        XRL     A,R7            ; 6F

        JNZ     LLL2            ; 70
        ACALL   LLLL + H'300    ; 71
        ORL     C,NN            ; 72
        JMP     @A+DPTR         ; 73
        MOV     A,#NN           ; 74
        MOV     NN,#MM          ; 75
        MOV     @R0,#NN         ; 76
        MOV     @R1,#NN         ; 77
        MOV     R0,#NN          ; 78
        MOV     R1,#NN          ; 79
        MOV     R2,#NN          ; 7A
        MOV     R3,#NN          ; 7B
        MOV     R4,#NN          ; 7C
        MOV     R5,#NN          ; 7D
        MOV     R6,#NN          ; 7E
        MOV     R7,#NN          ; 7F

        SJMP    LLL2            ; 80
        AJMP    LLLL + H'400    ; 81
        ANL     C,NN            ; 82
        MOVC    A,@A+PC         ; 83
        DIV     AB              ; 84
        MOV     NN,MM           ; 85
        MOV     NN,@R0          ; 86
        MOV     NN,@R1          ; 87
        MOV     NN,R0           ; 88
        MOV     NN,R1           ; 89
        MOV     NN,R2           ; 8A
        MOV     NN,R3           ; 8B
        MOV     NN,R4           ; 8C
        MOV     NN,R5           ; 8D
        MOV     NN,R6           ; 8E
        MOV     NN,R7           ; 8F

        MOV     DPTR,#NNNN      ; 90
        ACALL   LLLL + H'400    ; 91
        MOV     NN,C            ; 92
        MOVC    A,@A+DPTR       ; 93
        SUBB    A,#NN           ; 94
        SUBB    A,NN            ; 95
        SUBB    A,@R0           ; 96
        SUBB    A,@R1           ; 97
        SUBB    A,R0            ; 98
        SUBB    A,R1            ; 99
        SUBB    A,R2            ; 9A
        SUBB    A,R3            ; 9B
        SUBB    A,R4            ; 9C
        SUBB    A,R5            ; 9D
        SUBB    A,R6            ; 9E
        SUBB    A,R7            ; 9F

        ORL     C,/NN           ; A0
        AJMP    LLLL + H'500    ; A1
        MOV     C,NN            ; A2
        INC     DPTR            ; A3
        MUL     AB              ; A4
;       un_OP                   ; A5
        MOV     @R0,NN          ; A6
        MOV     @R1,NN          ; A7
        MOV     R0,NN           ; A8
        MOV     R1,NN           ; A9
        MOV     R2,NN           ; AA
        MOV     R3,NN           ; AB
        MOV     R4,NN           ; AC
        MOV     R5,NN           ; AD
        MOV     R6,NN           ; AE
        MOV     R7,NN           ; AF

LLL3:   ANL     C,/NN           ; B0
        ACALL   LLLL + H'500    ; B1
        CPL     NN              ; B2
        CPL     C               ; B3
        CJNE    A,#NN,LLL3      ; B4
        CJNE    A,NN,LLL3       ; B5
        CJNE    @R0,#NN,LLL3    ; B6
        CJNE    @R1,#NN,LLL3    ; B7
        CJNE    R0,#NN,LLL3     ; B8
        CJNE    R1,#NN,LLL3     ; B9
        CJNE    R2,#NN,LLL3     ; BA
        CJNE    R3,#NN,LLL3     ; BB
        CJNE    R4,#NN,LLL3     ; BC
        CJNE    R5,#NN,LLL3     ; BD
        CJNE    R6,#NN,LLL3     ; BE
        CJNE    R7,#NN,LLL3     ; BF

        PUSH    NN              ; C0
        AJMP    LLLL + H'600    ; C1
        CLR     NN              ; C2
        CLR     C               ; C3
        SWAP    A               ; C4
        XCH     A,NN            ; C5
        XCH     A,@R0           ; C6
        XCH     A,@R1           ; C7
        XCH     A,R0            ; C8
        XCH     A,R1            ; C9
        XCH     A,R2            ; CA
        XCH     A,R3            ; CB
        XCH     A,R4            ; CC
        XCH     A,R5            ; CD
        XCH     A,R6            ; CE
        XCH     A,R7            ; CF

        POP     NN              ; D0
        ACALL   LLLL + H'600    ; D1
        SETB    NN              ; D2
        SETB    C               ; D3
        DA      A               ; D4
        DJNZ    NN,LLL3         ; D5
        XCHD    A,@R0           ; D6
        XCHD    A,@R1           ; D7
        DJNZ    R0,LLL3         ; D8
        DJNZ    R1,LLL3         ; D9
        DJNZ    R2,LLL3         ; DA
        DJNZ    R3,LLL3         ; DB
        DJNZ    R4,LLL3         ; DC
        DJNZ    R5,LLL3         ; DD
        DJNZ    R6,LLL3         ; DE
        DJNZ    R7,LLL3         ; DF

        MOVX    A,@DPTR         ; E0
        AJMP    LLLL + H'700    ; E1
        MOVX    A,@R0           ; E2
        MOVX    A,@R1           ; E3
        CLR     A               ; E4
        MOV     A,NN            ; E5
        MOV     A,@R0           ; E6
        MOV     A,@R1           ; E7
        MOV     A,R0            ; E8
        MOV     A,R1            ; E9
        MOV     A,R2            ; EA
        MOV     A,R3            ; EB
        MOV     A,R4            ; EC
        MOV     A,R5            ; ED
        MOV     A,R6            ; EE
        MOV     A,R7            ; EF

        MOVX    @DPTR,A         ; F0
        ACALL   LLLL + H'700    ; F1
        MOVX    @R0,A           ; F2
        MOVX    @R1,A           ; F3
        CPL     A               ; F4
        MOV     NN,A            ; F5
        MOV     @R0,A           ; F6
        MOV     @R1,A           ; F7
        MOV     R0,A            ; F8
        MOV     R1,A            ; F9
        MOV     R2,A            ; FA
        MOV     R3,A            ; FB
        MOV     R4,A            ; FC
        MOV     R5,A            ; FD
        MOV     R6,A            ; FE
        MOV     R7,A            ; FF


;  Test SFR equates
	MOV	A,P0        	; 80
	MOV	A,SP  		; 81
        MOV     A,DPL 		; 82
        MOV     A,DPH 		; 83
	MOV	A,H'84  	; 84
	MOV	A,H'85  	; 85
	MOV	A,H'86  	; 86
	MOV	A,H'87  	; 87
        MOV     A,TCON		; 88
        MOV     A,TMOD		; 89
        MOV     A,TL0 		; 8A
        MOV     A,TL1 		; 8B
        MOV     A,TH0 		; 8C
        MOV     A,TH1		; 8D
	MOV	A,H'8E  	; 8E
	MOV	A,H'8F  	; 8F

        MOV     A,P1  		; 90
	MOV	A,H'91  	; 91
	MOV	A,H'92  	; 92
	MOV	A,H'93  	; 93
	MOV	A,H'94  	; 94
	MOV	A,H'95  	; 95
	MOV	A,H'96  	; 96
	MOV	A,H'97  	; 97
        MOV     A,SCON  	; 98
        MOV     A,SBUF  	; 99
	MOV	A,H'9A  	; 9A
	MOV	A,H'9B  	; 9B
	MOV	A,H'9C  	; 9C
	MOV	A,H'9D  	; 9D
	MOV	A,H'9E  	; 9E
	MOV	A,H'9F  	; 9F

        MOV     A,P2  		; A0
	MOV	A,H'A1  	; A1
	MOV	A,H'A2  	; A2
	MOV	A,H'A3  	; A3
	MOV	A,H'A4  	; A4
	MOV	A,H'A5  	; A5
	MOV	A,H'A6  	; A6
	MOV	A,H'A7  	; A7
        MOV     A,IE 	 	; A8
	MOV	A,H'A9  	; A9
	MOV	A,H'AA  	; AA
	MOV	A,H'AB  	; AB
	MOV	A,H'AC  	; AC
	MOV	A,H'AD  	; AD
	MOV	A,H'AE  	; AE
	MOV	A,H'AF  	; AF

        MOV     A,P3 	 	; B0
	MOV	A,H'B1  	; B1
	MOV	A,H'B2  	; B2
	MOV	A,H'B3  	; B3
	MOV	A,H'B4  	; B4
	MOV	A,H'B5  	; B5
	MOV	A,H'B6  	; B6
	MOV	A,H'B7  	; B7
        MOV     A,IP 	 	; B8
	MOV	A,H'B9  	; B9
	MOV	A,H'BA  	; BA
	MOV	A,H'BB  	; BB
	MOV	A,H'BC  	; BC
	MOV	A,H'BD  	; BD
	MOV	A,H'BE  	; BE
	MOV	A,H'BF  	; BF

	MOV	A,H'C0  	; C0
	MOV	A,H'C1  	; C1
	MOV	A,H'C2  	; C2
	MOV	A,H'C3  	; C3
	MOV	A,H'C4  	; C4
	MOV	A,H'C5  	; C5
	MOV	A,H'C6  	; C6
	MOV	A,H'C7  	; C7
        MOV     A,T2CON  	; C8
	MOV	A,H'C9  	; C9
        MOV     A,RCAP2L  	; CA
        MOV     A,RCAP2H  	; CB
        MOV     A,TL2  		; CC
        MOV     A,TH2 	 	; CD
	MOV	A,H'CE  	; CE
	MOV	A,H'CF  	; CF

        MOV     A,PSW	  	; D0
	MOV	A,H'D1  	; D1
	MOV	A,H'D2  	; D2
	MOV	A,H'D3  	; D3
	MOV	A,H'D4  	; D4
	MOV	A,H'D5  	; D5
	MOV	A,H'D6  	; D6
	MOV	A,H'D7  	; D7
	MOV	A,H'D8  	; D8
	MOV	A,H'D9  	; D9
	MOV	A,H'DA  	; DA
	MOV	A,H'DB  	; DB
	MOV	A,H'DC  	; DC
	MOV	A,H'DD  	; DD
	MOV	A,H'DE  	; DE
	MOV	A,H'DF  	; DF

        MOV     A,ACC	  	; E0
	MOV	A,H'E1  	; E1
	MOV	A,H'E2  	; E2
	MOV	A,H'E3  	; E3
	MOV	A,H'E4  	; E4
	MOV	A,H'E5  	; E5
	MOV	A,H'E6  	; E6
	MOV	A,H'E7  	; E7
	MOV	A,H'E8  	; E8
	MOV	A,H'E9  	; E9
	MOV	A,H'EA  	; EA
	MOV	A,H'EB  	; EB
	MOV	A,H'EC  	; EC
	MOV	A,H'ED  	; ED
	MOV	A,H'EE  	; EE
	MOV	A,H'EF  	; EF
	
        MOV     A,B  		; F0
	MOV	A,H'F1  	; F1
	MOV	A,H'F2  	; F2
	MOV	A,H'F3  	; F3
	MOV	A,H'F4  	; F4
	MOV	A,H'F5  	; F5
	MOV	A,H'F6  	; F6
	MOV	A,H'F7  	; F7
	MOV	A,H'F8  	; F8
	MOV	A,H'F9  	; F9
	MOV	A,H'FA  	; FA
	MOV	A,H'FB  	; FB
	MOV	A,H'FC  	; FC
	MOV	A,H'FD  	; FD
	MOV	A,H'FE  	; FE
	MOV	A,H'FF  	; FF


;  SFR bits
        MOV     C,P0.0      	; 80
        MOV     C,P0.1  	; 81
        MOV     C,P0.2 		; 82
        MOV     C,P0.3 		; 83
        MOV     C,P0.4  	; 84
        MOV     C,P0.5  	; 85
        MOV     C,P0.6  	; 86
        MOV     C,P0.7  	; 87
        MOV     C,IT0		; 88
        MOV     C,IE0		; 89
        MOV     C,IT1 		; 8A
        MOV     C,IE1 		; 8B
        MOV     C,TR0 		; 8C
        MOV     C,TF0		; 8D
        MOV     C,TR1  		; 8E
        MOV     C,TF1  		; 8F

        MOV     C,P1.0      	; 90
        MOV     C,P1.1      	; 91
        MOV     C,P1.2      	; 92
        MOV     C,P1.3      	; 93
        MOV     C,P1.4      	; 94
        MOV     C,P1.5      	; 95
        MOV     C,P1.6      	; 96
        MOV     C,P1.7      	; 97
        MOV     C,RI        	; 98
        MOV     C,TI	  	; 99
        MOV     C,RB8        	; 9A
        MOV     C,TB8		; 9B
        MOV     C,REN       	; 9C
        MOV     C,SM2       	; 9D
        MOV     C,SM1       	; 9E
        MOV     C,SM0       	; 9F

        MOV     C,P2.0      	; A0
        MOV     C,P2.1      	; A1
        MOV     C,P2.2      	; A2
        MOV     C,P2.3      	; A3
        MOV     C,P2.4      	; A4
        MOV     C,P2.5      	; A5
        MOV     C,P2.6      	; A6
        MOV     C,P2.7      	; A7
        MOV     C,EX0       	; A8
        MOV     C,ET0       	; A9
        MOV     C,EX1       	; AA
        MOV     C,ET1       	; AB
        MOV     C,ES        	; AC
        MOV     C,ET2       	; AD
	MOV	C,H'AE      	; AE
        MOV     C,EA        	; AF

        MOV     C,P3.0      	; B0
        MOV     C,P3.1      	; B1
        MOV     C,P3.2      	; B2
        MOV     C,P3.3      	; B3
        MOV     C,P3.4      	; B4
        MOV     C,P3.5      	; B5
        MOV     C,P3.6      	; B6
        MOV     C,P3.7      	; B7
        MOV     C,PX0       	; B8
        MOV     C,PT0       	; B9
        MOV     C,PX1       	; BA
        MOV     C,PT1       	; BB
        MOV     C,PS        	; BC
        MOV     C,PT2       	; BD
	MOV	C,H'BE  	; BE
	MOV	C,H'BF  	; BF

	MOV	C,H'C0  	; C0
	MOV	C,H'C1  	; C1
	MOV	C,H'C2  	; C2
	MOV	C,H'C3  	; C3
	MOV	C,H'C4  	; C4
	MOV	C,H'C5  	; C5
	MOV	C,H'C6  	; C6
	MOV	C,H'C7  	; C7

        MOV     C,CPRL2	  	; C8
        MOV     C,CT2      	; C9

        MOV     C,TR2       	; CA
        MOV     C,EXEN2     	; CB
        MOV     C,TCLK      	; CC
        MOV     C,RCLK      	; CD
        MOV     C,EXF2      	; CE
        MOV     C,TF2       	; CF

        MOV     C,P  		; D0
	MOV	C,H'D1  	; D1
        MOV     C,OV    	; D2
        MOV     C,RS0   	; D3
        MOV     C,RS1       	; D4
        MOV     C,F0        	; D5
        MOV     C,AC        	; D6
        MOV     C,CY        	; D7
	MOV	C,H'D8  	; D8
	MOV	C,H'D9  	; D9
	MOV	C,H'DA  	; DA
	MOV	C,H'DB  	; DB
	MOV	C,H'DC  	; DC
	MOV	C,H'DD  	; DD
	MOV	C,H'DE  	; DE
	MOV	C,H'DF  	; DF

        MOV     C,ACC.0     	; E0
        MOV     C,ACC.1     	; E1
        MOV     C,ACC.2     	; E2
        MOV     C,ACC.3     	; E3
        MOV     C,ACC.4     	; E4
        MOV     C,ACC.5     	; E5
        MOV     C,ACC.6     	; E6
        MOV     C,ACC.7     	; E7
	MOV	C,H'E8  	; E8
	MOV	C,H'E9  	; E9
	MOV	C,H'EA  	; EA
	MOV	C,H'EB  	; EB
	MOV	C,H'EC  	; EC
	MOV	C,H'ED  	; ED
	MOV	C,H'EE  	; EE
	MOV	C,H'EF  	; EF
	
        MOV     C,B.0       	; F0
        MOV     C,B.1       	; F1
        MOV     C,B.2       	; F2
        MOV     C,B.3       	; F3
        MOV     C,B.4       	; F4
        MOV     C,B.5       	; F5
        MOV     C,B.6       	; F6
        MOV     C,B.7       	; F7
	MOV	C,H'F8  	; F8
	MOV	C,H'F9  	; F9
	MOV	C,H'FA  	; FA
	MOV	C,H'FB  	; FB
	MOV	C,H'FC  	; FC
	MOV	C,H'FD  	; FD
	MOV	C,H'FE  	; FE
	MOV	C,H'FF  	; FF
;
;  Test subroutine call and return
	LCALL	QBAR
        NOP
        ACALL	QBAR
        NOP
        LCALL	ZBAR
        NOP
        ACALL	ZBAR
        NOP

QBAR:	INC	A
	INC	R0
        RET 

ZBAR:	INC	A
	INC	R0
        RETI

        .end	LLLL
