(**************************************************************************
PROGRAM NAME: CLEANUP.EXE

PURPOSE: Finds all drives and deletes any BAK, $$$, TMP, SYD or OLD files
         it finds. Also deletes files with file length of zero.

DATE CREATED: 9 MAY 1993
AUTHOR: Brian D. Catlin

COPYRIGHTS  This Program uses Libraries from Turbo Pascal 6.0,
  AND       CopyRight 1983, 1990 by Borland International, Inc.
TRADEMARKS  Turbo Pascal is a trademark of Borland International, Inc.
            CompuServe is a trademark of CompuServe Inc.
            Other Libraries used are from the disk supplied with
            the book "PC Magazine Turbo PASCAL 6.0 Techniques And Utilities",
            Copywrite 1991, by Ziff-Davis Press, and was authored by
            Neil J. Rubenking.

            This program is Copywrite 1993, by Brian D. Catlin. The author
            of this program shall not in any case be liable for any damages
            incurred with the use of this program. There are no explicit or
            implied warranties for this program.

            Released under the 'Stone Soup' Principle. If you make further
            enhancements to this program, please send me a copy of the source
            code at CompuServe address 76676,2041.

==========================================================================*)
{$M 16000 , 0, 16000}
PROGRAM CleanUp;

USES
   Crt, Printer, Dos, DosVer, ObjDD, ObjList, TypCds, ObjCds,
   HexWrite, ObjDpb;

TYPE
   DrvPtr     = ^DrvPtrRec;
   DrvPtrRec  = RECORD
                   DrvLet  : Char;
                   NextDrv : DrvPtr
                END;

VAR
   DrvFnd   : DrvPtr;

(**************************************************************************)

PROCEDURE Intro;

BEGIN
   ClrScr;
   WriteLn;
   WriteLn;
   Write('This program cleans up any installed disks by deleting ');
   WriteLn('*.BAK, *.TMP,');
   Write ('*.$$$, *.SYD and *.OLD files.  It also deletes files ');
   WriteLn('of zero length.');
   WriteLn
END;

(**************************************************************************)

PROCEDURE GetDrvs (VAR DrvFound : DrvPtr);

            {PURPOSE: To discover which drives exist and report
                      Them back to the main program
             INPUT:   Uninit'd pointer structure
             OUTPUT:  Pointer structure containing all valid drives}

VAR
   I       : Char;            
   Drive   : String;           
   Test    : File;
   Attr    : Word;
   NewNode : DrvPtr;
   C       : CdsObj;
   D       : DDobj;
   T       : DpbObj;
   N       : Byte;
   Name    : DirStr;

BEGIN
   DrvFound := NIL;                        {Initialize pointers}
   NewNode  := NIL;
   Requires(300);
   C.Init(L.GetCurDirArray);
   FOR N := L.GetLastDrive DOWNTO 1 DO
      BEGIN
         I := Chr(N+64);
         IF C.IsSubst(N) THEN
            WriteLn('Drive ', I, ': is SUBST''d -- DRIVE IGNORED')
         ELSE IF C.IsJoin(N) THEN
            WriteLn('Drive ', I, ': is JOINED -- DRIVE IGNORED')
         ELSE IF C.IsNetwork(N) THEN
            WriteLn('Drive ', I, ': is a NETWORK DRIVE -- DRIVE IGNORED')
         ELSE IF  D.IsCDRom THEN
            WriteLn('Drive ', I, ': is CDRom -- DRIVE IGNORED')
         ELSE
            BEGIN
               Drive := I + ':\IO.SYS';          {Create the test string}
               Assign(Test, Drive);
               GetFAttr(Test, Attr);             {Find out if the drive exists}
               IF DosError < 3 THEN              {If it does...}
                  BEGIN
                     New(NewNode);               {...Add it to the list}
                     NewNode^.DrvLet := I;
                     NewNode^.NextDrv := DrvFound;
                     DrvFound := NewNode
                  END
            END
      END
END;

(**************************************************************************)

PROCEDURE TrimLead (VAR S : ExtStr; C : Char);

            {PURPOSE: To trim leading characters from String array
             INPUT:   String Array S, Leading Character to Delete C
             OUTPUT:  Trimmed String array S}

VAR
   P  :  Byte;

BEGIN
   P := 1;
   WHILE (S[P] = C) AND (P <= LENGTH(S)) DO   {S is loger than P and }
      INC(P);                                 {S[P] = Char, step counter}
   CASE P OF
      0 : S[0] := #0;                         { string was full of C!}
      1 : ;                                   { string not found}
      ELSE
         MOVE(S[P], S[1], SUCC(Length(S) - P));  {Trim Char, move to next }
         DEC(S[0], PRED(P));                     {Reset length of string }
      END;
END;

(**************************************************************************)

PROCEDURE FindAndDie(FileSpec : String;
                     Attr     : Byte);

               {PURPOSE: To recurse through the directory structure,
                         Find the target files, and then delete them
                INPUT:   The general search string (must be *.* for
                         this procedure to work).  The file attribute
                         that will be looked at (as set, it looks at
                         all files).
                OUTPUT:  Messages to Screen, Target Files are deleted}

VAR
   DirEntry    : SearchRec;                   {Type from DOS Unit}
   DelString,
   FileName,
   ExpFileName,
   WhereIAm    : String;
   FPath       : PathStr;                     {TYPES for }
   FDir        : DirStr;                      {FSplit from }
   FName       : NameStr;                     {DOS }
   FExt        : ExtStr;                      {UNIT }
   DelFile     : File;
   Target      : Boolean;

BEGIN
   FindFirst(FileSpec, Attr, DirEntry);       {Get the first file}
   If DosError > 0 THEN Exit;                 {Any problems, LEAVE}
   WHILE DosError <> 18 DO                   {Still have files to go?}
      BEGIN
         Target := False;
         FileName := DirEntry.Name;
         ExpFileName := FExpand(DirEntry.Name);     {Set it up}
         FSplit(ExpFileName, FDir, FName, FExt);
         TrimLead(Fext , '.');
         IF ((DirEntry.Attr AND $10) = $10) AND  { See if it is a directory}
            NOT ((DirEntry.Name = '.') OR (DirEntry.Name = '..')) THEN
               BEGIN
                  GetDir(0, WhereIAm);     {If so, save and go there}
                  ChDir(DirEntry.Name);
                  FindAndDie(FileSpec, Attr);    {Recurse procedure}
                  ChDir(WhereIAm)                {Come Home}
               END
         ELSE
            IF ((FExt = '$$$') or (FExt = 'BAK') OR
                (FExt = 'SYD') OR (FExt = 'OLD') OR
                (FExt = 'TMP') OR
               ((DirEntry.Size = 0) AND NOT
               (((DirEntry.Attr AND $08) = $08) OR
               (DirEntry.Name = '.') OR (DirEntry.Name = '..'))))
               THEN
                  BEGIN
                     IF ((FExt = '$$$') or (FExt = 'BAK') OR
                         (FExt = 'SYD') OR (FExt = 'OLD') OR
                         (FExt = 'TMP')) THEN
                        Target := True;
                     IF Target THEN
                        Write('Target File:      ')
                     ELSE
                        Write('Zero Length File: ');
                     DelString := '/C DEL '+ DirEntry.Name;    {Set up and...}
                     Assign(DelFile, ExpFileName);
                     SetFAttr(DelFile, Archive);
                     SwapVectors;
                     Exec ('c:\dos\command.com ', DelString);  {Get rid of it}
                     SwapVectors;
                     WriteLn(ExpFileName); {Tell the world}
                  END;
         FindNext(DirEntry)                    {Get next file and loop}
      END
END;

(**************************************************************************)

PROCEDURE KillFiles(VAR DrivesFnd : DrvPtr);

              {PURPOSE: To control default drive setting, and set up
                        for procedure call to FindAndDie.
               INPUT:   Pointer structure of all available drives
               OUTPUT:  Passes setup to procedure, set user to original
                        directory and drive. }

VAR
   Home,
   DirRoot,
   FileSpec : String;
   Attr     : Byte;
   Current  : DrvPtr;

BEGIN
   GetDir(0,Home);                            {Save the home position}
   FileSpec := '*.*';
   Attr     := $3F;
   WriteLn('REASON            FILENAME AND PATH');
   WriteLn;
   REPEAT
      Current := DrivesFnd;                   {Run through the drives}
      DirRoot := DrivesFnd^.DrvLet + ':\';
      ChDir(DirRoot);
      FindAndDie(FileSpec, Attr);  {Find and kill the target files}
      DrivesFnd := DrivesFnd^.NextDrv;
      Dispose(Current)                      {Get rid of current pointer}
   UNTIL DrivesFnd = NIL;                   {Go to home position}
   ChDir(Home)
END;

(*========================================================================*)
BEGIN {Main Program}
   Intro;
   GetDrvs(DrvFnd);
   WriteLn;
   KillFiles(DrvFnd)
END.
