/*****************************************************************************
                               Public Domain
 ---------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : OS9 Format
 ---------------------------------------------------------------------------
   file-name	  : dpbvec.c
   date     	  : 06.05.1990
   last change	  : 21.11.1993
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

  Description : this function changes the interruptvector 0x1e depending 
  of the Argument to the local OS9 DPB or to the Original MS-DOS DPB
  It is neccesary before using this function to call this function one
  time with the parameter INIT to initialize the internal pointers.

  INIT - Initializes the internalm pointers
  OS9       sets DPB to local OS9 DPB
  MSDOS     sets DPB back to Original Vector

   inputs         : ----
   outputs        : ----
   return value   : ---- 

   history:		  : 
   Initial Version                                             06.05.90  WEW
   Adapted to OS9 Format                                       21.11.93 WEW
*****************************************************************************/
#include <dos.h>
#include "os9.h"
#include "mdos.h"

dpb os9_dpb;                   /* Disk Parameter Block for OS 9 */
void interrupt (*dos_dpb)();   /* Vektor to original Disk DPB */
void interrupt (*os9_dpb_ptr)();    /* Vektor to OS9 Disk DPB */

void dpbvec(merker)
short merker;
{
    short intr_num;             /* Number of Interupt which Vector points */
				                /* to DPB */
    intr_num=0x1e;              /* its int 1eh  */
    switch (merker)
    {
        case INIT:
             dos_dpb=getvect(intr_num); /* store Original dpb Vector */

             /* initialize local OS9 DPB */
	         os9_dpb.srt=0xdf;          /* Diskparameterblock for OS9 */
	         os9_dpb.hlt_nd=0x2;        /* initialize DISk */
	         os9_dpb.motor=0x25;
	         os9_dpb.bytes_per_sector=1;

             /* A T T E N T I O N : last_sector is important for format */
             /* routine of the BIOS. */
             /* read and write doesn't care so much about this value */
	         os9_dpb.last_sector=16;

	         os9_dpb.gap_lenght=0xe;
	         os9_dpb.data_lenght=0xff;
	         os9_dpb.format_gap_lenght=0x36;
	         os9_dpb.filler_byte=0xf6;
	         os9_dpb.head_settle_time=0xf;
	         os9_dpb.motor_start_time=0x8;

	         os9_dpb_ptr=(void interrupt (*)())&os9_dpb;
	         break;

        case OS9:
	         setvect(intr_num,os9_dpb_ptr);  /* switch vector to OS-9 dpb  */
	         break;
       case MSDOS:
	        setvect(intr_num,dos_dpb); /*switch back to Original dpb Vektor*/
	        break;
   }
}
