/*****************************************************************************
                               Public Domain
-----------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : OS9 Format
 -----------------------------------------------------------------------------
   file-name	  : formattrk.c
   date     	  : 21.11.1993
   last change	  : 21.11.1993
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

   description	  : Function to perform Format of one track via BIOS
  function 5 of int 13.

   inputs         : ----
   outputs        : error status
   return value   : ---- 

   history:		  : 
   Initial Version                                             21.11.93 WEW
*****************************************************************************/
#include <dos.h>
#include <bios.h>
#include <alloc.h>
#include <errno.h>
#include <math.h>
#include "mdos.h"
#include "prototyp.h"

extern drv_typ drv;


short format(drive,head,track,dpb_type)
short drive;
short head;
short track;
short dpb_type;
{

   unsigned char sects;
   short status;
   short retry;
   dpb huge *fmt_dpb;
   fmt_record *fmt_data;


   dpbvec(dpb_type);
   fmt_dpb=(dpb huge *)getvect(0x1e);

   setdisk(drive,&drv);
   if ((fmt_dpb->bytes_per_sector < SCODE128) ||
       (fmt_dpb->bytes_per_sector > SCODE1024))
   {
      dpbvec(MSDOS);
      return(EINVFMT);
   }

   fmt_data = (fmt_record *) calloc(fmt_dpb->last_sector,sizeof(fmt_record));
   if(fmt_data==NULL)
   {
      dpbvec(MSDOS);
      return( -1);
   }


   for(sects=0; sects<fmt_dpb->last_sector; sects++)
   {
      fmt_data[sects].track = (unsigned char)track;
      fmt_data[sects].head  = (unsigned char)head;
      fmt_data[sects].sects = (unsigned char)(sects + 1);
      fmt_data[sects].bps   = fmt_dpb->bytes_per_sector;
   }

   for(retry=0; retry<RETRIES; retry++)
   {
      status = biosdisk(5, drive, head, track, 1, 0, fmt_data);
      if(status==0) break;
      biosdisk(0, drive, 0, 0, 0, 0, 0);
   }
   dpbvec(MSDOS);

   free(fmt_data);

   if(retry == RETRIES)
      return( status);

   return( 0 );
}
