/*****************************************************************************
                               Public Domain
-----------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : OS9 Format
 -----------------------------------------------------------------------------
   file-name	  : rw_lsn.c
   date     	  : 08.06.1991
   last change	  : 20.11.1993
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

   description	  : Reads or writes one or more sectors from a OS9 Floppy
                    Disk.

   inputs         : Operation R/W,LSN,Sectorcnt,buffer
   outputs        : ----
   return value   : Error Status

   history:		  : 
   Initial Version                                             08.06.91 WEW
   Adapted to OS9 format Program                               20.11.93 WEW
*****************************************************************************/
#include <bios.h>
#include <stdlib.h>
#include <mem.h>
#include "os9.h"
#include "mdos.h"
#include "prototyp.h"

extern drv_typ drv;
extern short os9_type;

short rw_lsn(drive,operation,lsn,s_zahl,buffer)
short drive;
short operation;           /* read or write */
unsigned long lsn;       /* lsn of first sector to read or write */
unsigned long s_zahl;    /* how many sectors ?? */
void *buffer;            /* caller is responsible for enough buffer size */
{
    short sector;          /* Number of actual sector */
    short track;            /* actual track */
    short side;           /* actual side */
    static unsigned char buff[512]; /* buffer for one sector */
    void *buff_ptr;	/* pointer to storage area */
    short n,i;		/* sector counter and retry counter */
    short status;         /* status returned from int13 */

    dpbvec(OS9);	/* set DPB Vector to OS9 */

    (void huge *)buff_ptr=(void huge *)buffer; /*initialisation of buffer ptr */

    setdisk(drive,&drv);

    for (i=0;i<s_zahl;i++,lsn++)
    {
        sector=(short)((lsn % 16ul) + 1ul);

        track=(short) (lsn/16ul);

        side=track%2;
	    if (os9_type==X8W7)
	    {
            track/=2;                  /* Universal Format */
        }
        else
        {
            track=track/2+1;            /* Universal Format */
        }

        if (operation==WRITE)
        {
            movmem(buff_ptr,buff,256);
        }


        for (n=0;n<5;n++)          /* read or write with 5 retries */
        {
           status= biosdisk(operation,drive,side,track,sector,1,&buff[0]);
            if ((status!=0)&&(status!=0x11)) biosdisk(0,0,0,0,0,0,0);
            else break;
        }

        if ((status!=0)&&(status!=0x11)) 
        {
            dpbvec(MSDOS);
            return(status);
        }

        if (operation==READ)
        {
            movmem(buff,buff_ptr,256);   /* put data into buffer */
        }
        (char huge *)buff_ptr=(char huge *)buff_ptr+256;


    }
    dpbvec(MSDOS);		/* switch dpb Back to Original MS-DOS */
    return(FALSE);
}