/*****************************************************************************
                               Public Domain
-----------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : OS9 Format
 -----------------------------------------------------------------------------
   file-name	  : scan_des.c
   date     	  : 29.02.1992
   last change	  : 25.11.1993
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

   description	  : This function scan through the segmentlist of a
   Filedescriptor. All Cluster that are used by the current are marked
   as 'in use'in the allocation map. When the scaned file was a directory
   the functions delivers TRUE a return value otherwise FALSE.

   inputs         : ----
   outputs        : ----
   return value   : ---- 

   history:		  : 
   Initial Version                                             29.02.92  WEW
   Adappted to OS9 Format                                      25.11.93 WEW
*****************************************************************************/
#include "os9.h"
#include "prototyp.h"

short scan_des(des_lsn,desc,alloc,clu_size)
unsigned long des_lsn;
fildes *desc;
unsigned char *alloc;
unsigned long clu_size;
{
   fdseg  *fd_seg;
   int i;
   unsigned long lsn;
   unsigned long anz_sek;



   mark_bit(des_lsn,1,alloc,clu_size);        /* Mark bit for */
                                              /* Filedescriptor */

   fd_seg=&desc->fd_seg[0];
   for (i=0;i<48;i++)
   {
       lsn = fd_seg->addr[0] * 65536ul + fd_seg->addr[1]*256ul +
        fd_seg->addr[2];
       if (lsn == 0) break;    /* Abort when end of list is reached */

       anz_sek=fd_seg->size[0] * 256 + fd_seg->size[1]; /*sectorcount */
       /* Segmentlist has to filled to a full Cluster */
       mark_bit(lsn,anz_sek,alloc,clu_size);
       fd_seg++;
   }
   if ((desc->fd_att&0x80) != 0) return(TRUE);
   else return(FALSE);
}