/*****************************************************************************
                               Public Domain
-----------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : OS9- Format
 -----------------------------------------------------------------------------
   file-name	  : static.c
   date     	  : 20.11.1993
   last change	  : 20.11.1993
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

   description	  : This file contains the sector images of the ID Sector and
                    the Root Dir Filedescriptor for the Universal Format
                    and the 38w7/58w7 format.
                    I don't see any sense for the Universal format. It
                    seems to be equal to the 38w7 format just with the
                    difference that Track zero is not used. Maybe its for
                    compatibility with the first crude OS9 format with
                    single density Format on just track 0 .

   inputs         : ----
   outputs        : ----
   return value   : ---- 

   history:		  : 
   Initial Version                                             20.11.93  WEW
*****************************************************************************/
#include "os9.h"


ddsect id_sect38w7 =
{
    /* track 0 sector 1 for 38w7 or 58w7 format */
    0x00,0x0a,0x00,   /* Total number of sectors on media 2560 */
    0x10,             /* Track size in sectors */
    0x01,0x40,        /* Number of Bytes in allocation map 320 */
    0x00,0x01,        /* Number of sectors per bit (cluster size) in al map*/
    0x00,0x00,0x03,   /* LSN of Root directory File descriptor */
    0x00,0x00,        /* Owner Id */
    0xff,             /* Attributes */
    0x4c,0x96,        /* Disk ID */
    0x07,             /* Disk Format DS,DD,DT */
    0x00,0x10,        /* Sectors per Track == DD_TKS */
    0x00,0x00,        /* Reserved */
    0x00,0x00,0x00,   /* System Bootstrap LSN */
    0x00,0x00,        /* Size of System Bootstrap in sectors */
    0x5d,0x08,0x09,0x09,0x19, /* Creation Data */
    'P','C','-','O','S','9','-','F','o','r','m','a','t',' ',' ',
    0xa0,                     /* Volume name */
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,    /* Path descriptor OPtions ?????? */
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0x00,                               /* reserved */
    0x43,0x72,0x75,0x7a,                /* Media Integrity code */
    0,0,0,0,0,0,0,0,0,0,0,0,            /* not used */
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

ddsect id_sectuni =
{
    /* track 1 sector 1 for Universal format */
    0x00,0x09,0xe0,   /* 2528 */
    0x10,
    0x01,0x3c,
    0x00,0x01,
    0x00,0x00,0x03,
    0x00,0x00,
    0xff,
    0x5d,0xc1,
    0x07,
    0x00,0x10,
    0x00,0x00,
    0x00,0x00,0x00,
    0x00,0x00,
    0x5d,0x08,0x09,0x09,0x19,
    'P','C','-','O','S','9','-','F','o','r','m','a','t',' ',' ',
    0xa0,                     /* Volume name */
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0x00,
    0x43,0x72,0x75,0x7a,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

fildes root_dir =         /* is for Universal and x8w7 format identical */
{
    0xbf,                       /* File Attributes D S PE PW PR E W R */
    0x00,0x00,                  /* Owners User ID */
    0x5d,0x08,0x09,0x0c,0x09,   /* Date last MOdified Y M D H M */
    0x02,                       /* Link Count */
    0x00,0x00,0x00,0x40,        /* File Size in Bytes */
    0x5d,0x08,0x09,             /* Date created Y M D */
    0x00,0x00,0x04,  /* Seg 0  */  /* Start of Segment List */
    0x00,0x10,
    0x00,0x00,0x00,  /* Seg 1  */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 2  */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 3  */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 4  */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 5  */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 6  */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 7  */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 8  */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 9  */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 10 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 11 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 12 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 13 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 14 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 15 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 16 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 17 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 18 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 19 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 20 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 21 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 22 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 23 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 24 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 25 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 26 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 27 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 28 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 29 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 30 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 31 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 32 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 33 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 34 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 35 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 36 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 37 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 38 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 39 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 40 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 41 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 42 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 43 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 44 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 45 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 46 */
    0x00,0x00,
    0x00,0x00,0x00,  /* Seg 47 */
    0x00,0x00

};