		PAGE ,132
		TITLE Expanded Memory Access Routines

		.MODEL	LARGE,C

								PUBLIC  wEms_err
								PUBLIC  wEms_verify
								PUBLIC  wEms_alloc
								PUBLIC  wEms_map
								PUBLIC  wEms_free
								PUBLIC  wEms_getframe
								PUBLIC  wEms_pagecnt

		LOCALS	LL

								.DATA

emname		db	'EMMXXXX0'	; name of ems driver

wEms_err		dw	0

								.CODE

								SUBTTL wEms_verify
								PAGE +

wEms_verify	PROC	uses DS SI DI
		mov	ax, DGROUP
		mov	ds, ax

		mov	ax, 0  		; check if int vect 67 set up
		mov	es, ax
		mov	ax, es:[4*67h+2]
		or	ax, ax		; segment non zero ?
		jz	LL01		; if not
		mov	es, ax

		mov	di, 10		; offset to driver name
		mov	si, offset emname
		mov	cx, 8
		cld
		rep	cmpsb		; check driver name
		jne	LL01

		mov	ax, 1
		jmp	short LL02

LL01:		mov	ax, 0ffh	; no driver code
		mov	[wEms_err], ax
		xor	ax, ax		; zero ret code = bad
		
LL02:		ret

wEms_verify	ENDP
	

								SUBTTL wEms_alloc
                PAGE +

wEms_alloc	PROC	uses DS
		arg	pgcnt:word
		mov	ax, DGROUP
		mov	ds, ax

                mov	bx, [pgcnt]	; get number of pages to allocate
                mov	ah, 43H		; allocate space
                int	67H
								mov	byte ptr [wEms_err], ah
                or	ah, ah		; ah is zero if call succeeded
                jnz	LL01
		mov	ax, dx		; return handle
                jmp	short LL02
LL01:
                xor	ax, ax
LL02:
                ret
wEms_alloc	ENDP

								SUBTTL wEms_map
                PAGE +

wEms_map		PROC	uses DS
		arg	phys:word,handle:word,lpage:word
		mov	ax, DGROUP
		mov	ds, ax

		mov	ax, [phys]	; get phys page slot
		mov	dx, [handle]	; get handle number
		mov	bx, [lpage]	; get logical page number
                mov	ah, 44H		; map page
                int	67H
								mov	byte ptr [wEms_err], ah
                or	ah, ah		; see if ok
                jnz	LL01

                mov	ax, 1
                jmp	short LL02
LL01:
                xor	ax, ax
LL02:
                ret
wEms_map		ENDP
                
								SUBTTL wEms_free
                PAGE +

wEms_free	PROC
		arg	handle:word

                mov	dx, [handle]
                mov	ah, 45H
                int	67H
		xor	ax, ax

                ret
wEms_free	ENDP

								SUBTTL wEms_getframe
                PAGE +

wEms_getframe	PROC	uses DS		; sets AX to EMS page frame
		mov	ax, DGROUP
		mov	ds, ax

                mov	ah, 41H		; get frame seq
                int	67H
								mov	byte ptr [wEms_err], ah
                or	ah, ah		; ah is zero if call succeeded
                jnz	LL01
                mov	ax, bx		; return page frame in ax
                jmp	short LL02
LL01:
                xor	ax, ax
LL02:
                ret
wEms_getframe	ENDP

								SUBTTL wEms_pagecnt
                PAGE +

wEms_pagecnt	PROC	uses DS		; sets AX to EMS page frame
		mov	ax, DGROUP
		mov	ds, ax

								mov	ah, 42H		; get wEms page count
                int	67H
								mov	byte ptr [wEms_err], ah
                or	ah, ah		; see if ok
                jnz	LL01

                mov	ax, bx		; return page count
                jmp	short LL02
LL01:
                xor	ax, ax
LL02:
                ret
wEms_pagecnt	ENDP

                END
