/************************************************************************/
/*                                                                      */
/*                 Digitized Voice Programmer's Toolkit                 */
/*                 ------------------------------------                 */
/*                            version 3.0                               */
/*                                                                      */
/*              Copyright (c) 1988-1993, Farpoint Software              */
/*                                                                      */
/*                                                                      */
/*          Example of how to use FSSPEAK.EXE as a TSR program          */
/*                                                                      */
/************************************************************************/

/****** This program should be compiled using "Large" memory model. ******/

#include <stdlib.h>
#include <fcntl.h>
#include <stdio.h>
#include <stddef.h>
#include <malloc.h>
#include <process.h>
#include <dos.h>
#include <share.h>
#include <string.h>

/*-------------------------------------------------------------------*/

/* prototype for the FSSPEAK TSR entry point */

long (pascal __far *FSSPEAK_ENTRYPOINT)(int command, unsigned int parm2,
                               unsigned char __far *parm3, long parm4);

/*-------------------------------------------------------------------*/

/* name of the data file to be played */

char datafilename[] = "DEMO.VOI";

/* sample rate of the data file */

unsigned int samples_per_sec = 16572;  // default for DVPT

/* compression algorithm to be used; 0 = none, 1 = uLaw, 2 = ADPCM */

int compression = 0;

/*-------------------------------------------------------------------*/

void main(int argc, char **argv)

{
int destination;
long returncode;
int loadcode;
char arg2[10];
unsigned char __far *buffer;
int handle;
long size;
unsigned isize;

/* get the destination parameter from the command line */

if ( argc < 2 )         // no parameters...
    destination = -1;   // ... auto-locate
else
    {
    argv++;                             // point to 1st parameter
    if ( !stricmp(*argv, "LPT1") )
        destination = 1;
    else if ( !stricmp(*argv, "LPT2") )
        destination = 2;
    else if ( !stricmp(*argv, "LPT3") )
        destination = 3;
    else if ( !stricmp(*argv, "SPKR") )
        destination = 0;               // use internal speaker
    else
        destination = -1;              // invoke auto-locate if parameter
                                       //   is not interpretable
    }

/* Step 1 (required only once): Load TSR into memory. */

  /* create command line argument 2 */

sprintf(arg2, "%4.4X:%4.4X",
        (unsigned)(((long)(&FSSPEAK_ENTRYPOINT)) >> 16),
        (unsigned)(((long)(&FSSPEAK_ENTRYPOINT)) & 0xFFFF) );

  /* invoke the executable */

loadcode = _spawnl(_P_WAIT, "FSSPEAK.EXE", "FSSPEAK.EXE",
                     "/L", arg2, NULL);

  /* NOTE: Only the bottom 8 bits are used for TSR load spawn call! */

loadcode &= 0x00FF;

  /* test return code; see docs for complete explanation */

if ( loadcode != 0 )         // if not OK
    {
    printf("TSR load attempt returned %d.\n", loadcode);
    exit(1);
    }

/* Step 2: Set up the various operating parameters. */

printf("The following two calls will return -1 if FSSPEAK is the Standard Version.\n");
printf("Set rate returned %ld\n",
       FSSPEAK_ENTRYPOINT(1, samples_per_sec, NULL, 0L));
printf("Set compression returned %ld\n",
       FSSPEAK_ENTRYPOINT(2, compression, NULL, 0L));

    /* "set destination and calibrate" must be done last */

returncode = FSSPEAK_ENTRYPOINT(3, (unsigned int)destination, NULL, 0L);

    /* test return code; see docs for more detail */

if ( returncode != 0L )
    {
    printf("Calibration attempt returned %d.\n", (int)returncode);
    _spawnl(_P_WAIT, "FSSPEAK.EXE", "FSSPEAK.EXE", "/U", NULL);  // unload TSR
    exit(1);
    }

/* Step 3: Play the data through the internal speaker or LPT port.
           This can be done multiple times after a single calibration. */

buffer = _fmalloc(65504U);
if ( buffer == NULL )
    {
    printf("Unable to allocate memory.\n");
    _spawnl(_P_WAIT, "FSSPEAK.EXE", "FSSPEAK.EXE", "/U", NULL);  // unload TSR
    exit(1);
    }

/* >>>> NOTE: Skipping error checking to enhance code readability. <<<< */

printf("For simplicity, this program plays only the first 64k of the file.\n");

_dos_open(datafilename, _O_RDONLY|_SH_COMPAT, &handle);
_dos_read(handle, buffer, 65504U, &isize);
_dos_close(handle);
size = (long)isize;

if ( size <= 0L )
    {
    _ffree(buffer);
    printf("Data file read error.\n");
    _spawnl(_P_WAIT, "FSSPEAK.EXE", "FSSPEAK.EXE", "/U", NULL);  // unload TSR
    exit(1);
    }

FSSPEAK_ENTRYPOINT(4, 0, buffer, size);

_ffree(buffer);

/* Step 4: Unload the TSR from memory. */

_spawnl(_P_WAIT, "FSSPEAK.EXE", "FSSPEAK.EXE", "/U", NULL);

}
