/****************************************************************************

۰
۰
۰
۰                                                                     
۰                           
۰                                                   
۰                                             
۰                                                  
۰                                                   
۰                                   
۰                                                                     
۰ BOY! 
۰ SOFT!!! 
۰ Copy Right. Mxico 1993.


   ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ
ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͻ
       THIS SOFTWARE IS DISTRIBUTED FREE AND WITH *NO* WARRANTIES.        
    THIS SOFTWARE IS NOT GUARANTEED TO WORK UNDER ALL CIRCUNSTANCES.      
    I SHALL NOT BE RESPONSIBLE FOR ANY HARM OR DAMAGE CAUSED BY THIS      
     PROGRAMS. I APOLOGIZE FOR NOT DISTRIBUTING A BUG FREE SOFTWARE       
                 BUT THIS IS NOT A COMMERCIAL PACKAGE.                    
ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͼ
   ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ

ͻ                                                                 ͻ
                                                                         
ͼ
       WARNING:                                                       
       THERE ARE A LOT OF GRAMMATH AND SPELLING ERRORS BECAUSE MY     
       NATIVE LANGUAJE IS SPANISH NOT ENGLISH. BECAUSE OF THAT IT     
       IS VERY PROBABLY THAT SOME OF THE COMMENTS OR TEXT TALKS       
       ABOUT SOMETHING THAT I DID NOT WANT TO SAY EXACTLY OR ALMOST   
       IN THAT WAY. SO ANY CORRECTIONS ARE WELCOME.                   
       I AM NOT RESPONSIBLE OF HARM ,LOSE OR DAMAGE CAUSED BY THIS    
       ERRORS OR SOFTWARE BUGS (YOU ARE WARNED THAT BOTH MAY EXIST).  
ͻ
                                                                         
ͼ                                                                 ͼ

ͻ
ͻ
͹ W                                                                        
͹ A                          T H I S     S O F T W A R E     I S    N O T  
͹ R               G U A R A N T E E D     T O     W O R K    N O R    I T  
͹ N                             W I L L     W O R K    U N D E R    A L L  
͹ N                                            C I R C U N S T A N C E S.  
͹ ING !!!                                                                  
ͼ
ͼ
****************************************************************************/

/****************************************************************************
*                                                                           *
*                                                                           *
*    Program Name:      FDSKEY.C                                            *
*    Author:            Federico de la Mora Salazar                         *
*    Date:              June, 1993. (Mxico)                                *
*    Compiler(s):       Turbo C 2.0                                         *
*    Description:       This is a Terminate and Stay Resident (TSR) program.*
*                       At program start the function fdskey_int9h will be  *
*                       attached to interrupt 09h vector. After that the    *
*                       program will be left in memmory resident and the    *
*                       control will return to command.com or the program   *
*                       that run this program.                              *
*                       When a key is pressed the int 09h is called by the  *
*                       BIOS, this int is responsible for filling the       *
*                       keyboard buffer with the keys pressed in the        *
*                       keyboard, capture Ctrl-Alt-Del, Ctrl-Break and      *
*                       Sys-req key combinations and process them.          *
*                       If int 09h is called our program will capture it and*
*                       then it will produce a small beep with the          *
*                       PC speaker, after that the original int 09h will be *
*                       called to process the key.                          *
*                       May be you have read a lot of leave the registers   *
*                       just like you find them when your Interrupt Handler *
*                       was activated. You don't have to worry about it, the*
*                       reserved word interrupt (just for Turbo C) will     *
*                       cause the compiler to save all the registers and    *
*                       restore them before returning from the handler.     *
*                       interrupt will also replace the normal return from  *
*                       function instruction for a return from interrupt    *
*                       instruction (iret).                                 *
*                       THIS IS THE ALMOST THE SAME PROGRAM AS FDSBEEP.C    *
*                       HOWEVER THIS PROGRAM DOESN'T USE ANY OF THE         *
*                       FUNCTIONS OF THE TURBO C LIBRARIES.                 *
*    How to compile:                                                        *
*                                                                           *
*            make -ffdskey           (Edit this file for your own needs)    *
*                                                                           *
****************************************************************************/

#include <dos.h>

/****************************************************************************
************ GLOBAL VARIABLES AND CONSTANTS *********************************
****************************************************************************/

#if     !defined(TRUE)
#define TRUE         1
#define FALSE        0
#endif

#if     !defined(ON) || !defined(OFF)
#define ON           1
#define OFF          0
#endif

#define PORT_A  0x60

unsigned  _heaplen = 1;         /* Instructs C startup code to use the
				 * minimum heap size. */
unsigned  _stklen  = 0x100;     /* Set a small stack. */

char      fds_msg[] = "FDSKEY Resident!     Author: Federico de la Mora Salazar.\r\n$";

/****************************************************************************
************ FUNCTION PROTOTYPES ********************************************
****************************************************************************/
extern    void beep(void);
extern    int  fds_inport(int port);
void      _restorezero(void);
void      _setargv(void);
void      exit(void);
void      _setenvp(void);
void      interrupt     (*old_int09h) (void);
void      interrupt     fdsbeep_int9h(void);
unsigned  prog_size(void);
void      main(void);

/****************************************************************************
************ FUNCTIONS ******************************************************
****************************************************************************/

/****************************************************************************
* Function Name:        _setargv                                            *
* Parameters:           None                                                *
* Returns:              Nothing.                                            *
* Description:          Do-nothing _setargv function.                       *
****************************************************************************/
void _setargv(void)
{
		  return;
}

/****************************************************************************
* Function Name:        exit                                                *
* Parameters:           None                                                *
* Returns:              Nothing.                                            *
* Description:          Do-nothing exit function.                           *
****************************************************************************/
void exit(void)
{
		  return;
}

/****************************************************************************
* Function Name:        _setenvp                                            *
* Parameters:           None                                                *
* Returns:              Nothing.                                            *
* Description:          do-nothing _setenvp.                                *
****************************************************************************/
void _setenvp(void)
{
		  return;
}

/****************************************************************************
* Function Name:        fdsbeep_int9h                                       *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          New int 09h handler to capture keystrokes and       *
*                       produce a beep with every key pressed.              *
****************************************************************************/
void interrupt fdsbeep_int9h(void)
{

	int       scan;

	enable();               /* Turn the interrupts ON. */
	/* Read Port A (60h). The key scan code is
	* left there by the keyboard controller.
	* Equivalent to:
	* scan = inport(PORT_A);
	*/
	scan = fds_inport(PORT_A);
	/*
	 * If this is not a key release then produce the "beep". Obviously
	 * we only want to make a beep when a key is pressed not released.
	 * This is done because int 09h is called when a key is pressed and
	 * the again when it is released (if released then the bit 7 of the
	 * scan code is ON).
	 */
	if (!(scan & 0x80)) {
		beep();
	}
	/* Let the old int 0x09 do its stuff. */
	(*old_int09h) ();
	return;

}

/****************************************************************************
* Function Name:        prog_size                                           *
* Parameters:           None                                                *
* Returns:              Program's size in paragraphs (Chunks of 16 bytes).  *
* Description:          Looks for this program's MCB and reads the program's*
*                       size in paragraphs.                                 *
****************************************************************************/
unsigned  prog_size(void)
{

		  return peek(_psp - 1, 3);     /* The Program Segment Prefix
						 * (psp)  contains
						 * information created by DOS
						 * when the program was
						 * loaded in to memory to be
						 * excuted. One paragraph (16
						 * bytes) before the psp
						 * there are a Memory Control
						 * Block created by DOS to
						 * asignate memory to this
						 * program, the 3rd byte of
						 * it contains the number of
						 * bytes reserved for this
						 * program in paragraphs. */
	/*
	 * Note: The operation _psp-1 is substracting a complete paragraph,
	 * from _psp because _psp contains a segment or paragraph address.
	 */
}

/****************************************************************************
* Function Name:        main                                                *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          C's main function.                                  *
****************************************************************************/
void      main(void)
{
	unsigned        saved_DS;

	saved_DS = _DS;
	/*
	 * The C startup code in c0.asm save some interrupt vectors used by
	 * the signal functions. However a TSR must save and restore this
	 * vectors by itself to continue using those functions. fdskey.c
	 * doesn't use any signal function but it must let the interrupt
	 * vectors unchanged except for the int 09h. For this reason the
	 * program would call the _restorezero() function defined in c0.asm
	 * (take a look on that file on the turbo C directory, it's very
	 * interesting) if it becomes resident without using the keep()
	 * function.
	 * fdsclic2 becomes resident calling DOS function 31h bypassing
	 * the keep() function so we must call _restorezero().
	 */
	_restorezero();

	/*
	 * Save the original vector of the interrupt 09h to be called just
	 * after the beep is produced.
	 * Equivalent to:       old_int09h = getvect(0x09);
	 */
	_AX = 0x3509;
	geninterrupt(0x21);
	old_int09h = MK_FP(_ES,_BX);

	/*
	 * Store our new int 09h vector to be called each time an int 09h is
	 * generated.
	 * Equivalent to:       setvect(0x09, fdsbeep_int9h);
	 */
	 _DS = (unsigned) ((unsigned long)(fdsbeep_int9h) >> 16);
	 _DX = (unsigned) fdsbeep_int9h;
	 _AX = 0x2509;
	 geninterrupt(0x21);
	 _DS = saved_DS;

	/*
	 * The next instructions will release the memory used by this
	 * program's enviroment. It's safe to do so and the freed memory can
	 * be reused by another program's enviroment. _ES = enviroment
	 * segment. _AH = 0x49 (DOS function: Free memory block). The offset
	 * 2Ch of the Program Segment Prefix contains (psp) the Enviroment
	 * segment address.
	 */
	_ES = peek(_psp, 0x2C);
	_AH = 0x49;
	geninterrupt(0x21);

	/* Print Title.*/
	_DX = (unsigned) fds_msg;
	_AX = 0x0900;
	geninterrupt(0x21);

	/*
	 * keep() terminates the program leaving it resident in memory. It
	 * will return 3 to the calling program or to the DOS ERRORLEVEL
	 * variable.
	 * This lines are equivalent to ...
	 *                 keep(3, prog_size());
	 */
	_DX = prog_size();
	_AX = 0x3103;
	geninterrupt(0x21);
	return;
}

