/****************************************************************************

۰
۰
۰
۰                                                                     
۰                           
۰                                                   
۰                                             
۰                                                  
۰                                                   
۰                                   
۰                                                                     
۰ BOY! 
۰ SOFT!!! 
۰ Copy Right. Mxico 1993.


   ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ
ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͻ
       THIS SOFTWARE IS DISTRIBUTED FREE AND WITH *NO* WARRANTIES.        
    THIS SOFTWARE IS NOT GUARANTEED TO WORK UNDER ALL CIRCUNSTANCES.      
    I SHALL NOT BE RESPONSIBLE FOR ANY HARM OR DAMAGE CAUSED BY THIS      
     PROGRAMS. I APOLOGIZE FOR NOT DISTRIBUTING A BUG FREE SOFTWARE       
                 BUT THIS IS NOT A COMMERCIAL PACKAGE.                    
ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͼ
   ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ

ͻ                                                                 ͻ
                                                                         
ͼ
       WARNING:                                                       
       THERE ARE A LOT OF GRAMMATH AND SPELLING ERRORS BECAUSE MY     
       NATIVE LANGUAJE IS SPANISH NOT ENGLISH. BECAUSE OF THAT IT     
       IS VERY PROBABLY THAT SOME OF THE COMMENTS OR TEXT TALKS       
       ABOUT SOMETHING THAT I DID NOT WANT TO SAY EXACTLY OR ALMOST   
       IN THAT WAY. SO ANY CORRECTIONS ARE WELCOME.                   
       I AM NOT RESPONSIBLE OF HARM ,LOSE OR DAMAGE CAUSED BY THIS    
       ERRORS OR SOFTWARE BUGS (YOU ARE WARNED THAT BOTH MAY EXIST).  
ͻ
                                                                         
ͼ                                                                 ͼ

ͻ
ͻ
͹ W                                                                        
͹ A                          T H I S     S O F T W A R E     I S    N O T  
͹ R               G U A R A N T E E D     T O     W O R K    N O R    I T  
͹ N                             W I L L     W O R K    U N D E R    A L L  
͹ N                                            C I R C U N S T A N C E S.  
͹ ING !!!                                                                  
ͼ
ͼ
****************************************************************************/

/****************************************************************************
*                                                                           *
*                                                                           *
*    Program Name:      FDSLABEL.C                                          *
*    Author:            Federico de la Mora Salazar                         *
*    Date:              June, 1993. (Mxico)                                *
*    Compiler(s):       Turbo C 2.0                                         *
*    Description:       fds_label.C born as a simple clone of the DOS       *
*                       external command "label". It's amazing that non of  *
*                       the DOS versions and clones include a function to   *
*                       directly work with the volume label. Instead of it  *
*                       a program that creates or modifies a disk label must*
*                       use the old FCB file system.                        *
*                       The label has it's own entry on the root directory  *
*                       and it's distinguished from other files with the    *
*                       label attribute. See the program's comments for more*
*                       information about this.                             *
*                       The actual fdslabel.c does more than change the disk*
*                       label, it reports information about the disk using  *
*                       three diferent methods for it.                      *
*                       fds_label uses fds_crt.c for writing directly to the*
*                       screen and to interface with the video BIOS,        *
*                       err_hand.c is used to capture DOS errors.           *
*                       fdslabel has some fancy elements, press F1 for a    *
*                       help box, press Ctrl or Alt alone to see possible   *
*                       key combinations at the bottom of the screen.       *
*                       If you want to work with another drive press        *
*                       Ctrl + drive letter. (e.g. Ctrl-C for dive C).      *
*    How to compile:                                                        *
*                                                                           *
*            tcc -1 -G -O -Z -N- -f -a- -k -w -v -r -ms fdslabel.c          *
*            make -ffdslabel         (Edit this file for your own needs)    *
*                                                                           *
****************************************************************************/


#include <dir.h>
#include <time.h>
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include "err_hand.c"

/****************************************************************************
************ GLOBAL VARIABLES AND CONSTANTS *********************************
****************************************************************************/

#define DELETE  0x13
#define CREAT   0x16
#define TRUE  1
#define FALSE 0

unsigned  _stklen = 16384;
unsigned  _heaplen = 0;

union  REGS rin, rout;
struct SREGS srin;

struct dfree diskfree;
struct fatinfo fat_info;
struct xfcb fdsxfcb;
struct text_info conio_info;
int    old_vid_page, vidmode, width;

char      temp_drv[] = "C:";
char      dta[128];
char      label[12];

char      line25_buf[160];
int       X, Y, old_disk, label_exist, quit, toggle;
int       label_delete_flag;
time_t    timet;
char     *timestr;

struct bpb {			/* Bios Parameter Block (data in boot sector
				 * or sector 0). */

	char      instruction[3];
	char      systemID[8];
	int       bytes_per_sector;
	char      sectors_per_cluster;
	int       sectors_reserved_area;
	char      FATcopies;
	int       root_entries;
	int       number_of_sectors;
	char      media_descriptor;
	int       sectors_per_FAT;
	int       sectors_per_track;
	int       number_of_heads;

	/*
	 * If (number_of_sectors == 0) then the disk was formatted with DOS
	 * 3.31 or later and a large partition is being used
	 */

	union {
		int       hidden_sectors_i;
		long      hidden_sectors_l;
	}         h_sect;

	/*
	 * The next vars exist only in DOS 3.31 and later.
	 */

	long      number_of_sectors_long;
	char      physical_drive;
	char      reserved;
	char      signature_byte;
	long      serial_number;
	char      volume_label[11];

	/* You may modified the nest buffer to see the Partition Table.    */
	char      dummy[512 - 54];
}         bootsector;

/****************************************************************************
************ FUNCTION PROTOTYPES ********************************************
****************************************************************************/

void interrupt new_int1Bh(void);
int       ctrlbreak_hit(void);
void      ctrlbreak_reset(void);
unsigned  bootread(struct bpb * boot);
int       void_cbrk(void);
int       alpha2drvnum(char drive);
int       label_delete(void);
int       label_creat(char *label);
void      label_find(char *label);
void      beep(void);
void      set_working_label(void);
char     *edit_line(char *line, int maxlen);
void      draw_background(void);
void      process_label(char *label);
void      print_help(void);
void      help_F1(void);
int       isvalid_drive(char *drive);
void      checkDOSversion(void);
void      boot(void);
void      fat(void);
void      disk_info(void);
void      do_label(void);
void      copy_right(void);
void      drive(void);
void      fds_getfatd(struct fatinfo * fat_info);
void      process_argv(int argc, char *argv[]);
void      do_exit(void);

static void interrupt(*old_int1Bh) (void);

/****************************************************************************
************ MACROS *********************************************************
****************************************************************************/

/****************************************************************************
* MACRO Name:           delete                                              *
* Parameters:           target:         String to modified.                 *
*                       position:       Which char to delete.               *
* Returns:              A pointer to the place that were occupied by the    *
*                       deleted character.                                  *
* Description:          Deletes a character from target at the specified    *
*                       position.                                           *
***************************************************************************/
#define delete(string, position) strcpy(string+position-1, string+position)


/****************************************************************************
************ FUNCTIONS ******************************************************
****************************************************************************/

/****************************************************************************
* Function Name:        new_int1Bh                                          *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          New int 1Bh handler to avoid our program to be      *
*                       affected by a Ctrl-Break.                           *
****************************************************************************/
void interrupt new_int1Bh(void)
{
	          return;
}

/****************************************************************************
* Function Name:        ctrlbreak_hit                                       *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          If a Ctrl-Break combination is detected by the BIOS *
*                       interrupt 09h, a flag is set in the BIOS area and a *
*                       int 1Bh is executed. If Ctrl-Break is pressed whe   *
*                       bioskey() is waiting for a key it will return a key *
*                       with scan code of zero. This function check for the *
*                       flag set by the BIOS to detect if Ctrl-Break was    *
*                       pressed.                                            *
****************************************************************************/
int       ctrlbreak_hit(void)
{
	/*
	 * If Ctrl-Break was pressed then the BIOS has set to *1* the bit
	 * seven of the byte at 0040:0071
	 */
	          return ((int) *((char far *) 0x0471)) & 0x80;
}

/****************************************************************************
* Function Name:        ctrlbreak_reset                                     *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          Turns of the Ctrl-Break flag set by the BIOS.       *
*                       See ctrlbreak_hit() for more information.           *
****************************************************************************/
void      ctrlbreak_reset(void)
{
	/*
	 * If Ctrl-Break was pressed then the BIOS has set to *1* the bit
	 * seven of the byte at 0040:0071. The default Ctrl-Break Handler
	 * resets that bit to *0*, so we have to do the work.
	 */
	disable();
	(*((char far *) 0x0471)) = (*((char far *) 0x0471)) & 0x7F;
	enable();
	return;
}

/****************************************************************************
* Function Name:        bootread                                            *
* Parameters:           Struct of type bpb passed by reference.             *
* Returns:              Nothing                                             *
* Description:          Reads the current drive boot sector to fill the     *
*                       structure passed by reference.                      *
****************************************************************************/
unsigned  bootread(struct bpb * boot)
{
	union REGS r_in, r_out;
	struct SREGS sregs;
	struct control_packet {
		unsigned long sector;
		unsigned int nsec;
		char far *buffer;
	}         pc;
	char      dir_buf[64];

	/*
	 * Cheap Trick: Call DOS function "Get current directory" to force
	 * DOS to know the disk media format. When fdslabel.c uses this
	 * function it's not neccesary to do this call but if you used it in
	 * some other circunstance this is going to be a real need.
	 */

	r_in.h.ah = 0x47;
	r_in.h.dl = 0x00;	/* Default Drive */
	segread(&sregs);
	sregs.ds = FP_SEG((void far *) &dir_buf);
	r_in.x.si = FP_OFF((void far *) &dir_buf);
	intdosx(&r_in, &r_out, &sregs);

	/*
	 * Call DOS int 0x25 to read sector. Note: DOS numbers sector
	 * starting at *0*, the BIOS begin numbering from *1*.
	 */

	if ((_osmajor >= 4) || ((_osmajor == 3) && (_osminor > 30))) {
		pc.sector = 0L;
		pc.nsec = 1;
		pc.buffer = (char far *) boot;
		segread(&sregs);
		sregs.ds = FP_SEG((void far *) &pc);
		r_in.x.bx = FP_OFF((void far *) &pc);
		r_in.x.cx = (-1);	/* Tell DOS that we are using DOS 4+
					 * extended int 25h */

	} else {
		r_in.x.cx = 1;	/* Number of sectors to read */
		r_in.x.dx = 0;	/* Sector to read */
		sregs.ds = FP_SEG((void far *) &boot);
		r_in.x.bx = FP_OFF((void far *) &boot);
	}
	r_in.h.al = getdisk();	/* Uses current drive */

	int86x(0x25, &r_in, &r_out, &sregs);	/* Absolute Sector Read. */
	/*
	 * DOS allways forgets in the stack the flags register after int 25h.
	 * If the calling program wants to get rid of them from the stack you
	 * need the assembler instruction: add sp,2; However this function
	 * uses int86x to call the interrupt and that ensures the stack to be
	 * left without those extra pair of bytes
	 */
	return r_out.x.cflag;	/* Error if carry flag set              */

}

/****************************************************************************
* Function Name:        void_cbrk                                           *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          Do-nothing DOS ctrl-break handler.                  *
****************************************************************************/
int       void_cbrk(void)
{
	          return -1;
}

/****************************************************************************
* Function Name:        alpha2drvnum                                        *
* Parameters:           Drive letter.                                       *
* Returns:              Drive number.                                       *
* Description:          Converts a drive letter to its corresponding drive  *
*                       number (Not case significant).                      *
*                       If the parameter is 'a' or 'A' the value returned is*
*                       *0*, for 'b' or 'B' is *1*, ...                     *
****************************************************************************/
int       alpha2drvnum(char drive)
{
	          return toupper(drive) - 'A';
}

/****************************************************************************
* Function Name:        label_delete                                        *
* Parameters:           None.                                               *
* Returns:              Nothing.                                            *
* Description:          Deletes the volume label entry in the root directory*
*                       of the current drive.                               *
* Note:                 This function uses the old file system based on     *
*                       "file control blocks" (fcb). These are obsolete     *
*                       functions however it is the only way to work with   *
*                       the volume label.                                   *
****************************************************************************/
int       label_delete(void)
{
	char far *old_dta;

	old_dta = getdta();
	setdta(dta);

	parsfnm("*.*", &fdsxfcb.xfcb_fcb, 0);
	fdsxfcb.xfcb_fcb.fcb_drive = 0x00;
	fdsxfcb.xfcb_flag = 0xFF;
	fdsxfcb.xfcb_attr = FA_LABEL;
	rin.h.ah = DELETE;
	segread(&srin);
	srin.ds = FP_SEG((void far *) &fdsxfcb);
	rin.x.dx = FP_OFF((void far *) &fdsxfcb);

	intdosx(&rin, &rout, &srin);
	setdta(old_dta);

	return rout.h.al;
}

/****************************************************************************
* Function Name:        label_creat                                         *
* Parameters:           New volume label name.                              *
* Returns:              Nothing.                                            *
* Description:          Creates a volume label entry in the root directory  *
*                       of the current drive with the name specified.       *
* Note:                 This function uses the old file system based on     *
*                       "file control blocks" (fcb). These are obsolete     *
*                       functions however it is the only way to work with   *
*                       the volume label.                                   *
****************************************************************************/
int       label_creat(char *label)
{
	char far *old_dta;

	old_dta = getdta();
	setdta(dta);

	parsfnm(label, &fdsxfcb.xfcb_fcb, 0);
	fdsxfcb.xfcb_flag = 0xFF;
	fdsxfcb.xfcb_attr = FA_LABEL;
	rin.h.ah = CREAT;
	segread(&srin);
	srin.ds = FP_SEG((void far *) &fdsxfcb);
	rin.x.dx = FP_OFF((void far *) &fdsxfcb);

	intdosx(&rin, &rout, &srin);
	setdta(old_dta);

	return rout.h.al;
}

/****************************************************************************
* Function Name:        label_find                                          *
* Parameters:           Buffer to store the Volume Label name to find.      *
* Returns:              Nothing.                                            *
* Description:          Searches the current disk for an entry with the     *
*                       volume label attribute.                             *
****************************************************************************/
void      label_find(char *label)
{
	int       l, x;
	struct ffblk fdsffblk;

	if (!findfirst("*.*", &fdsffblk, FA_LABEL)) {
		l = 0;
		for (x = 0; x < strlen(fdsffblk.ff_name); x++) {
			if (fdsffblk.ff_name[x] == '.')
				continue;
			else
				label[l++] = fdsffblk.ff_name[x];
		}
		label[l] = NULL;
	} else
		label[0] = NULL;
	return;
}

/****************************************************************************
* Function Name:        beep                                                *
* Parameters:           None.                                               *
* Returns:              Nothing.                                            *
* Description:          A more flexible way of beep the speaker without     *
*                       printing the char 0x07 to stdout.                   *
****************************************************************************/
void      beep(void)
{

	sound(400);
	delay(400);
	nosound();
	return;
}

/****************************************************************************
* Function Name:        set_working_label                                   *
* Parameters:           None.                                               *
* Returns:              Nothing.                                            *
* Description:          This is the main function of this program, its task *
*                       is to create each one of the boxes showed (copy     *
*                       right notice, boot sector, drive letter, fat info,  *
*                       disk info and label edit box). This is inside a loop*
*                       wich is repeated until the user enters a zero byte  *
*                       length label and then pressed Escape.               *
*                       It's very probably that we don't return to this     *
*                       point if the user instigates a quit command when    *
*                       editing  the label name.                            *
****************************************************************************/
void      set_working_label(void)
{

	do {
		copy_right();
		boot();
		drive();
		fat();
		disk_info();
		do_label();
	} while (strlen(label) || label_delete_flag);
	return;
}

/****************************************************************************
* Function Name:        edit_line                                           *
* Parameters:           line:   Line to edit (in this case the label name). *
*                       maxlen: Size of the buffer pointed by line.         *
* Returns:              line.                                               *
* Description:          edit_line() is used as a control center, it's main  *
*                       task is to edit the volume label name readed from   *
*                       the current disk. It's second task is to recognize  *
*                       quit and help keys and call the functions to handle *
*                       them.                                               *
*                       This function will never wait for a keystroke. The  *
*                       first thing it does is to check if a key was pressed*
*                       if not then it does a little of housekeeping (print *
*                       date and time constantly and detect if only Ctrl or *
*                       Alt keys were pressed).                             *
*                       When a keystroke is detected it will check for a    *
*                       Ctrl - Letter combination to cange drive, for a     *
*                       quit request or for the function key F1 to call     *
*                       help. If no one of those keys was pressed the it    *
*                       will check for a edit key (Delete, back space, home,*
*                       end and arrows). Finally if the caharacter is valid *
*                       for DOS naming conventions, it will be inserted in  *
*                       line.                                               *
****************************************************************************/
#define ENTER           0x1C0D
#define BACKSPACE       0x0E08
#define ESC             0x001B
#define TAB             0x0009
#define F1              59
#define ALT_X           45
#define ALT_F4          107
#define LEFT            75
#define RIGHT           77
#define HOME            71
#define END             79
#define DEL             83

char     *edit_line(char *line, int maxlen)
{
	struct CHAR {
		char      ascii, scan;
	};
	union CODE {
		struct CHAR c;
		int       n;
	}         s;
	int       x, y, position;

	label_delete_flag = FALSE;
	x = wherex();
	y = wherey();
	position = x;
	quit = FALSE;
	cprintf("%s", line);
	gotoxy(x, y);

	do {
		if (ctrlbreak_hit()) {
			bioskey(0);	/* When using bioskey() if you press
					 * Ctrl-Break (Ctrl and pause key),
					 * the function will return a scan
					 * code of *0*. If you are testing to
					 * see if a key was pressed with
					 * bioskey(1) the program will think
					 * that there are nothing on the
					 * keyboard buffer when there are a
					 * key with scan code 0 and an ascii
					 * value of *0* so we drop this key
					 * and set to zero the Ctrl-Break
					 * flag in the BIOS.
					 */
			ctrlbreak_reset();
		} else if (bioskey(1)) {
			s.n = bioskey(0);
			if (s.n == ENTER) {
				if (line[0] == NULL)
					label_delete_flag = TRUE;
				quit = TRUE;
			} else if (s.n == BACKSPACE)
				if (wherex() > x) {
					position--;
					delete(line, wherex() - x);
				} else
					beep();
			else if ((s.c.ascii >= 1) && (s.c.ascii <= 26)) {
			        /* Ctrl-Letter (Change Drive) */
				temp_drv[0] = (s.c.ascii - 1) + 'A';
				if (isvalid_drive(temp_drv)) {
					setdisk(alpha2drvnum(temp_drv[0]));
					set_working_label();
					return NULL;
				}
			} else
				switch (s.c.ascii) {
				case 0x00:
					switch (s.c.scan) {
					case F1:
						help_F1();
						break;
					case ALT_X:
						exit(1);
						break;
					case ALT_F4:
						exit(1);
						break;

					case LEFT:
						if (wherex() > x)
							position--;
						else
							beep();
						break;
					case RIGHT:
						if (wherex() < strlen(line) + x - 1)
							position++;
						else
							beep();
						break;
					case HOME:
						position = x;
						break;
					case END:
						if (strlen(line))
							position = strlen(line) + x - 1;
						else
							position = x;
						break;
					case DEL:
						if (strlen(line)) {
							delete(line, wherex() - x + 1);
							position = wherex();
						} else
							beep();
						break;
					default:
						beep();
					}
					break;
				case ESC:
					if (line[0] == NULL)
						quit = TRUE;
					else
						line[0] = NULL;
					position = x;
					break;
				case '\\':
				case '|':
				case '+':
				case '/':
				case '=':
				case '"':
				case '?':
				case '*':
				case '.':
				case ',':
				case ';':
				case ':':
				case '[':
				case ']':
				case TAB:
					beep();
					break;
				default:
					if (wherex() < x + maxlen) {
						putch(s.c.ascii);
						if (line[wherex() - x - 1])
							line[wherex() - x - 1] = s.c.ascii;
						else {
							line[wherex() - x - 1] = s.c.ascii;
							line[wherex() - x] = NULL;
						}
						position = wherex();
						if (position == maxlen + x)
							position--;
					} else
						beep();
				}

			if (!quit) {
				gotoxy(x, y);
				clreol();
				cprintf("%s", line);
				gotoxy(position, y);
			}
		} else {
			timet = time(NULL);
			timestr = ctime(&timet);
			timestr[strlen(timestr) - 1] = NULL;
			printstr(57, 1, (LIGHTGRAY << 4) | LIGHTBLUE, timestr);
			gettext(1, 25, 80, 25, line25_buf);
			toggle = bioskey(2);
			if (toggle & 0x04) {	/* Control Pressed */
				printstr(1, 25, (LIGHTGRAY << 4) | LIGHTGREEN, "      Ctrl - Letter:  ");
				printstr(23, 25, (LIGHTGRAY << 4) | LIGHTBLUE | BLINK, "Change Drive.   ");
				while ((bioskey(2) & 0x04) && !bioskey(1));
			} else if (toggle & 0x08) {	/* Alt Pressed */
				printstr(1, 25, (LIGHTGRAY << 4) | LIGHTGREEN, "      Alt - F4, Alt - X:  ");
				printstr(27, 25, (LIGHTGRAY << 4) | LIGHTBLUE | BLINK, " Quit         ");
				while ((bioskey(2) & 0x08) && !bioskey(1));
			}
			puttext(1, 25, 80, 25, line25_buf);
		}
	} while (!quit);

	return line;
}

/****************************************************************************
* Function Name:        draw_background                                     *
* Parameters:           None.                                               *
* Returns:              Nothing.                                            *
* Description:          Draws the desktop and prints the program name and   *
*                       some valid keys.                                    *
****************************************************************************/
void      draw_background(void)
{
	register int x;
	register int y;

	textbackground(LIGHTGRAY);
	clrscr();
	printstr(2, 1, (LIGHTGRAY << 4) | BLUE, "FDSLABEL. Creat, edit or delete a volume label.");
	for (x = 1; x <= conio_info.screenwidth; x++)
		for (y = 2; y <= conio_info.screenheight - 1; y++)
			dputch(x, y, (LIGHTGRAY << 4) | DARKGRAY, 0xB1);

	printstr( 2, conio_info.screenheight, (LIGHTGRAY << 4) | YELLOW, "Esc:");
	printstr( 7, conio_info.screenheight, (LIGHTGRAY << 4) | BLUE,   "Delete Line.");
	printstr(24, conio_info.screenheight, (LIGHTGRAY << 4) | YELLOW, "Enter:");
	printstr(31, conio_info.screenheight, (LIGHTGRAY << 4) | BLUE,   "Accepts.");
	printstr(44, conio_info.screenheight, (LIGHTGRAY << 4) | YELLOW, "Alt-X:");
	printstr(51, conio_info.screenheight, (LIGHTGRAY << 4) | BLUE,   "Quit.");
	printstr(61, conio_info.screenheight, (LIGHTGRAY << 4) | YELLOW, "F1:");
	printstr(65, conio_info.screenheight, (LIGHTGRAY << 4) | BLUE,   "Help.");

	return;
}

/****************************************************************************
* Function Name:        process_label                                       *
* Parameters:           New label name.                                     *
* Returns:              Nothing.                                            *
* Description:          Uses label to create, rename or delete the disk     *
*                       volume label.                                       *
*                       If the label exist the function deletes it, then if *
*                       the length of label is not zero it creates a new    *
*                       label with the name specified in label.             *
****************************************************************************/
void      process_label(char *label)
{
	int       l, x;
	char      temp[13];

	if (label_exist)
		label_delete();
	if (strlen(label)) {
		l = 0;
		for (x = 0; x < strlen(label); x++) {
			if (x == 8)
				temp[l++] = '.';
			temp[l++] = label[x];
		}
		temp[l] = NULL;
		label_creat(temp);
	}
	return;
}

/****************************************************************************
* Function Name:        print_help                                          *
* Parameters:           None.                                               *
* Returns:              Nothing.                                            *
* Description:          This function is called to print some help when     *
*                       invalid command line parameters are detected.       *
****************************************************************************/
void      print_help(void)
{

	          cprintf("Sintax:  FDSLABEL [D:]\n\r");
	cprintf("         [D:] Drive letter (Optional).\n\r");
	cprintf("If Drive Letter is omitted current drive will be used.\n\r");
	cprintf("The drive can be changed inside the program.\n\r");
	exit(1);
}


/****************************************************************************
* Function Name:        help_F1                                             *
* Parameters:           None.                                               *
* Returns:              Nothing.                                            *
* Description:          This function is called to print some help when     *
*                       the function key <F1> is pressed.                   *
*                       The screen will be saved and then restored to its   *
*                       previous state. This function uses <fds_crt.c> to   *
*                       write directly to the screen.                       *
****************************************************************************/
void      help_F1(void)
{
	struct text_info conio_F1;
	char     *v_buffer;

	if ((v_buffer = malloc(getvideo_screensize())) == NULL) {
		return;
	}
	gettextinfo(&conio_F1);
	gettext(2, 5, 79, 20, v_buffer);
	draw_box(2, 5, 79, 20, BLACK, LIGHTGRAY, "Help");

	textcolor(LIGHTBLUE);
	cprintf("  Command           Keys");

	textcolor(BLACK);
	gotoxy(15, 3);
	cprintf("Quit");
	textcolor(LIGHTCYAN);
	gotoxy(20, 3);
	cprintf("Alt-X, Esc Esc, Alt-F4.");

	textcolor(BLACK);
	gotoxy(7, 4);
	cprintf("Change Drive");
	textcolor(LIGHTCYAN);
	gotoxy(20, 4);
	cprintf("Ctrl & Drive Letter. (e.g. <Ctrl C> to select drive C).");

	textcolor(BLACK);
	gotoxy(3, 5);
	cprintf("Accept new label");
	textcolor(LIGHTCYAN);
	gotoxy(20, 5);
	cprintf("Enter, Return");

	textcolor(BLACK);
	gotoxy(10, 6);
	cprintf("Edit Keys");
	textcolor(LIGHTCYAN);
	gotoxy(20, 6);
	cprintf("Left and right arrows to move around.");
	gotoxy(20, 7);
	cprintf("Del to delete char at cursor position.");
	gotoxy(20, 8);
	cprintf("Back Space to delete previous char.");
	gotoxy(20, 9);
	cprintf("Esc deletes the whole line, if the line is clear");
	gotoxy(20, 10);
	cprintf("the program will quit.");
	gotoxy(20, 11);
	cprintf("To delete a label from disk press Esc and");
	gotoxy(20, 12);
	cprintf("then press Enter.");
	gotoxy(20, 13);
	cprintf("Ctrl break will be ignored.");

	gotoxy(61, 14);
	textcolor(LIGHTBLUE);
	cprintf("Press a key...");

	bioskey(0);
	puttext(2, 5, 79, 20, v_buffer);
	window(conio_F1.winleft, conio_F1.wintop,
	       conio_F1.winright, conio_F1.winbottom);
	textattr(conio_F1.attribute);
	gotoxy(conio_F1.curx, conio_F1.cury);

	free(v_buffer);
	return;
}

/****************************************************************************
* Function Name:        isvalid_drive                                       *
* Parameters:           String containing drive letter and ':'.             *
* Returns:              TRUE if a valid drive was specified and             *
*                       FALSE in other case.                                *
* Description:          Checks for a valid drive letter.                    *
****************************************************************************/
int       isvalid_drive(char *drive)
{
	union REGS r_in, r_out;

	r_in.h.ah = 0x36;
	r_in.h.dl = alpha2drvnum(drive[0]) + 1;
	intdos(&r_in, &r_out);
	if ((drive[1] == ':') && (drive[2] == NULL) && (r_out.x.ax != 0xFFFF))
		return TRUE;
	else
		return FALSE;
}

/****************************************************************************
* Function Name:        checkDOSversion                                     *
* Parameters:           None.                                               *
* Returns:              Nothing.                                            *
* Description:          Checks for a valid DOS version number, if it is an  *
*                       older version the program will be terminated.       *
****************************************************************************/
void      checkDOSversion(void)
{

	switch    (_osmajor) {
	case 20:
	case 10:	cprintf("This program uses fcb.\n\r");
			cprintf("OS/2 protect mode doesn't support them.\n\r");
	case  2:
			cprintf("This program was only tested with DOS 4, 5 and 6.\n\r");
			cprintf("System may crash.!!!\n\r");
			cprintf("Continue? (Y/N): ");
			if (toupper(getche()) != 'Y')
			exit(3);
			break;
	case  1:
			cprintf("This program calls functions NOT avalaible in this DOS version.\n\r");
			exit(3);
	}
	return;
}

/****************************************************************************
* Function Name:        boot                                                *
* Parameters:           None                                                *
* Returns:              Nothing.                                            *
* Description:          Draws the box to contain the information reported by*
*                       this function.                                      *
*                       It prints information about the default disk boot   *
*                       sector.                                             *
****************************************************************************/
void      boot(void)
{
	char      temp[32];

	draw_box(51, 3, 78, 23, YELLOW, BLUE, "Boot Sector");
	bootread(&bootsector);

	strncpy(temp, bootsector.systemID, 8);
	temp[8] = NULL;
	cprintf("\n System ID:  %s\n\r", temp);
	cprintf(" Bytes per Sector:%7d\n\r",      bootsector.bytes_per_sector);
	cprintf(" Sectors per Cluster:%4d\n\r",   bootsector.sectors_per_cluster);
	cprintf(" Sec. of Reserved Area:%2d\n\r", bootsector.sectors_reserved_area);
	cprintf(" FAT copies:%13d\n\r",   bootsector.FATcopies);
	cprintf(" Root entries:%11d\n\r", bootsector.root_entries);

	if (bootsector.number_of_sectors)
		cprintf(" # of Sectors:%11d\n\r", bootsector.number_of_sectors);
	else
		cprintf(" # of Sectors:%11ld\n\r", bootsector.number_of_sectors_long);

	cprintf(" Media Descriptor:%6Xh\n\r",  bootsector.media_descriptor);
	cprintf(" Sectors per FAT:%8d\n\r",    bootsector.sectors_per_FAT);
	cprintf(" Sectors per Track:%6d\n\r",  bootsector.sectors_per_track);
	cprintf(" # of Heads (Sides):%5d\n\r", bootsector.number_of_heads);

	if (!bootsector.number_of_sectors)
		cprintf(" Hidden Sectors:%9ld\n\r", bootsector.h_sect.hidden_sectors_l);
	else
		cprintf(" Hidden Sectors:%9d\n\r",  bootsector.h_sect.hidden_sectors_i);

	if (bootsector.signature_byte == 0x29) {
		cprintf(" Physical Drive:%9d\n\r",    bootsector.physical_drive);
		cprintf(" Signature byte:%8Xh\n\r",   bootsector.signature_byte);
		cprintf(" Serial Number:  %08lX\n\r", bootsector.serial_number);
		strncpy(temp, bootsector.volume_label, 11);
		temp[11] = NULL;
		cprintf(" Volume Label:\n\r        %s", temp);
	}
	return;
}

/****************************************************************************
* Function Name:        fat                                                 *
* Parameters:           None                                                *
* Returns:              Nothing.                                            *
* Description:          Draws the box to contain the information reported by*
*                       this function.                                      *
*                       It prints information about the FAT (explicity the  *
*                       FAT ID byte reported by DOS).                       *
****************************************************************************/
void      fat(void)
{

	draw_box(3, 3, 34, 12, YELLOW, BLUE, "Fat Info");
	fds_getfatd(&fat_info);
	gotoxy(1, 2);
	cprintf(" Sectors per cluster:%7d\n\r",  fat_info.fi_sclus);
	cprintf(" FAT id: %18Xh\n\r",            fat_info.fi_fatid);
	cprintf(" Number of clusters:%8u\n\r",
	                        (unsigned) fat_info.fi_nclus);
	cprintf(" Bytes per sector:%10d\n\r",    fat_info.fi_bysec);
	cprintf(" Bytes per Cluster: %8d\n\r",
	                        fat_info.fi_bysec*fat_info.fi_sclus);
	cprintf(" Disk Size: %13.2f Mb",
	                       ((float) fat_info.fi_bysec*fat_info.fi_sclus
			       *(unsigned) fat_info.fi_nclus) / 1024 / 1024);

	return;
}

/****************************************************************************
* Function Name:        disk_info                                           *
* Parameters:           None                                                *
* Returns:              Nothing.                                            *
* Description:          Draws the box to contain the information reported by*
*                       this function.                                      *
*                       It prints information about the disk size, space and*
*                       some derived data.                                  *
****************************************************************************/
void      disk_info(void)
{
	/*
	 * bytes per cluster = bytes per sector  * sectors per cluster; total
	 * free bytes  = bytes per cluster * avalaible clusters; disk size =
	 * bytes per cluster * number of clusters; % of free space   =
	 * (avalaible clusters * 100) / number of clusters;
	 */

	          draw_box(3, 14, 34, 23, YELLOW, BLUE, "Disk Space");

	/*
	 * The next function uses the dos function 0x36 to obtain the data
	 * that returns in the struct diskfree. The dos function is called
	 * with the dos interrupt 0x21.
	 */
	getdfree(0, &diskfree);
	gotoxy(1, 2);
	cprintf(" Available clusters:%8u\n\r",  diskfree.df_avail);
	cprintf(" Total clusters:%12u\n\r",     diskfree.df_total);
	cprintf(" Bytes per sector:%10u\n\r",   diskfree.df_bsec);
	cprintf(" Sectors per cluster:%7u\n\r", diskfree.df_sclus);
	cprintf(" Bytes per Cluster:%9lu\n\r",
	                        (long) diskfree.df_bsec*diskfree.df_sclus);
	cprintf(" Total Free Space:%7.2f Mb\n\r",
	                        ((float) diskfree.df_bsec*diskfree.df_sclus
	                        *diskfree.df_avail) / 1024 / 1024);
	cprintf(" Disk Size:%14.2f Mb\n\r",
	                        ((float) diskfree.df_bsec*diskfree.df_sclus
	                        *diskfree.df_total) / 1024 / 1024);
	cprintf(" Free Space:%15.2f%%",
	                        ((float) diskfree.df_avail*100)
	                        /diskfree.df_total);

	return;
}

/****************************************************************************
* Function Name:        do_label                                            *
* Parameters:           None                                                *
* Returns:              Nothing.                                            *
* Description:          Draws the box to contain the information reported by*
*                       this function.                                      *
*                       It's main task is to find the disk label and send it*
*                       to be edited and the processed.                     *
****************************************************************************/
void      do_label(void)
{

	draw_box(36, 13, 49, 15, LIGHTGRAY, BLUE, "Label");
	textcolor(WHITE);
	label_find(label);
	if (strlen(label) == 0)
		label_exist = FALSE;
	else
		label_exist = TRUE;
	edit_line(label, 11);
	if (strlen(label) || label_delete_flag)
		process_label(label);

	return;
}

/****************************************************************************
* Function Name:        copy_right                                          *
* Parameters:           None                                                *
* Returns:              Nothing.                                            *
* Description:          Draws the box to contain the information reported by*
*                       this function.                                      *
*                       It prints the author's name.                        *
****************************************************************************/
void      copy_right(void)
{

	draw_box(36, 4, 49, 10, LIGHTCYAN, MAGENTA, "Copy Right");
	textcolor(LIGHTGREEN);
	cprintf(" Written by\n\n\r");
	cprintf("  Federico\n\r");
	cprintf(" de la Mora\n\r");
	cprintf("  Salazar");

	return;
}

/****************************************************************************
* Function Name:        drive                                               *
* Parameters:           None                                                *
* Returns:              Nothing.                                            *
* Description:          Draws the box to contain the information reported by*
*                       this function.                                      *
*                       It prints the current drive letter.                 *
****************************************************************************/
void      drive(void)
{

	draw_box(37, 18, 48, 20, YELLOW, BLUE, "Drive");
	cprintf("%5c:", getdisk() + 'A');
	return;
}

/****************************************************************************
* Function Name:        fds_getfatd                                         *
* Parameters:           A struct defined in <dos.h> to keep disk information*
* Returns:              Nothing.                                            *
* Description:          Calls DOS function 1Bh to get the default drive     *
*                       information. This is an obsolete function that was  *
*                       replaced by func 0x36 (see getdfree()). However I   *
*                       include this function as an example and for         *
*                       comparation. fds_getfatd() has the same             *
*                       functionality that the compiler's function          *
*                       getfatd().                                          *
****************************************************************************/
void      fds_getfatd(struct fatinfo * fat_info)
{
	union REGS r_in, r_out;
	struct SREGS sregs;

	r_in.h.ah = 0x1B;	/* Dos function: Get deafult drive
				 * information. */
	segread(&sregs);
	intdosx(&r_in, &r_out, &sregs);	        /* int 0x21                */
	fat_info->fi_sclus = r_out.h.al;	/* Sectors per cluster     */
	fat_info->fi_bysec = r_out.x.cx;	/* Bytes per sector        */
	fat_info->fi_nclus = r_out.x.dx;	/* Total number of clusters*/
	fat_info->fi_fatid = peek(sregs.ds, r_out.x.bx);	/* FAT ID  */
	return;
}

/****************************************************************************
* Function Name:        process_argv                                        *
* Parameters:           The same as main.                                   *
* Returns:              Nothing.                                            *
* Description:          Parses argv and proceess the command line.          *
****************************************************************************/
void      process_argv(int argc, char *argv[])
{

	if        (argc > 2 ||
		            !strcmp(argv[1], "/?") ||
		            !strcmp(strupr(argv[1]), "?") ||
		            !strcmp(strupr(argv[1]), "/H") ||
		            !strcmp(strupr(argv[1]), "/HELP"))
		          print_help();
	else if (argc == 2 && isvalid_drive(argv[1]))
		setdisk(alpha2drvnum(argv[1][0]));	/* Drive A is 0 */

	return;
}

/****************************************************************************
* Function Name:        do_exit                                             *
* Parameters:           None.                                               *
* Returns:              Nothing.                                            *
* Description:          This function is called by the exit() function.     *
*                       It restore the original screen and hooked vectors.  *
****************************************************************************/
void      do_exit(void)
{

	setdisk(old_disk);
	setvideo_page_bios(old_vid_page);
	textmode(conio_old.currmode);
	puttext(1, 1, conio_old.screenwidth,
		conio_old.screenheight, video_buffer);
	gotoxy(conio_old.curx, conio_old.cury);
	free(video_buffer);
	ctrlbreak_reset();
	while (bioskey(1))
		bioskey(0);
	setvect(0x1B, old_int1Bh);
	return;
}

/****************************************************************************
* Function Name:        main                                                *
* Parameters:           argc:   Number of command line parameters.          *
*                       argv:   List of parameters.                         *
* Returns:              Nothing.                                            *
* Description:          Sets the new Ctrl-Break handler, the error handler  *
*                       and the Ctrl-C handler, then it calls some functions*
*                       to parse argv, check dosversion, set working drive  *
*                       and some other stuff. It's lat mission is call      *
*                       set_working_label() the heart of the program.       *
****************************************************************************/
void      main(int argc, char *argv[])
{


	directvideo = TRUE;	/* Instruct functions defined in
				 * <conio.h> to write directly to the
				 * video buffer instead of using the
				 * BIOS. */
	get_video_address();	/* Obtain the video buffer address to be used
				 * by the functions defined in <fds_crt.c>. */
	checkDOSversion();	/* This program makes calls not supported in
				 * OS/2 and older DOS versions. */

	/*
	 * If the file <err_hand.c> was include, then active the new
	 * "critical error handler (int 24h)".
	 */
#if        defined(ERR_HAND)
	harderr(err_handler);
#endif

	old_disk = getdisk();	/* Save original drive number because this
				 * programs changes to the drive to be
				 * modified. Drive A is 0, B is 1 and so on. */
	abort_allowed = TRUE;	/* Before altering anything dangerous it's
				 * safe for the error handler to abort */
	process_argv(argc, argv);	/* The new working disk will be set
					 * from this function, if the drive
					 * specified in the command line is
					 * not valid the default is the
					 * current drive. */
	abort_allowed = FALSE;	/* From this point aborting will be "very
				 * dangerous" for the error handler */
	old_int1Bh = getvect(0x1B);	/* Save the vector of the int 1Bh
					 * (Ctrl - Break). */
	setvect(0x1B, new_int1Bh);	/* Set our own int 1Bh handler     */

	ctrlbrk(void_cbrk);	/* Although DOS will never know if ^C was
				 * pressed is a good idea to change the
				 * default Ctrl-C handler to our "do-nothing"
				 * handler. */
	atexit(do_exit);	/* do_exit() will be called at exit()      */

	/* Getting prepared for using <conio.h> and <fds_crt.c>            */
	gettextinfo(&conio_old);

	/* Save original video page because this program works only
	 * with page 0.
	 */
        old_vid_page = getvideo_page_bios(&vidmode, &width);
        setvideo_page_bios(0);                  /* Change to video page 0. */

	textmode(C80);
	gettextinfo(&conio_info);

	if ((video_buffer = malloc(getvideo_screensize())) == NULL) {
		cprintf("\n\rNot enought memory!\n\r");
		beep();
		abort();	/* If we dont't abort know, do_exit() would
				 * write garbage. */
	}
	gettext(1, 1, conio_old.screenwidth,
		conio_old.screenheight, video_buffer);

	draw_background();	/* Prepare our desktop.                    */
	set_working_label();	/* Start working with the disk label.      */
	return;
}

