/****************************************************************************

۰
۰
۰
۰                                                                     
۰                           
۰                                                   
۰                                             
۰                                                  
۰                                                   
۰                                   
۰                                                                     
۰ BOY! 
۰ SOFT!!! 
۰ Copy Right. Mxico 1993.


   ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ
ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͻ
       THIS SOFTWARE IS DISTRIBUTED FREE AND WITH *NO* WARRANTIES.        
    THIS SOFTWARE IS NOT GUARANTEED TO WORK UNDER ALL CIRCUNSTANCES.      
    I SHALL NOT BE RESPONSIBLE FOR ANY HARM OR DAMAGE CAUSED BY THIS      
     PROGRAMS. I APOLOGIZE FOR NOT DISTRIBUTING A BUG FREE SOFTWARE       
                 BUT THIS IS NOT A COMMERCIAL PACKAGE.                    
ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͼ
   ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ

ͻ                                                                 ͻ
                                                                         
ͼ
       WARNING:                                                       
       THERE ARE A LOT OF GRAMMATH AND SPELLING ERRORS BECAUSE MY     
       NATIVE LANGUAJE IS SPANISH NOT ENGLISH. BECAUSE OF THAT IT     
       IS VERY PROBABLY THAT SOME OF THE COMMENTS OR TEXT TALKS       
       ABOUT SOMETHING THAT I DID NOT WANT TO SAY EXACTLY OR ALMOST   
       IN THAT WAY. SO ANY CORRECTIONS ARE WELCOME.                   
       I AM NOT RESPONSIBLE OF HARM ,LOSE OR DAMAGE CAUSED BY THIS    
       ERRORS OR SOFTWARE BUGS (YOU ARE WARNED THAT BOTH MAY EXIST).  
ͻ
                                                                         
ͼ                                                                 ͼ

ͻ
ͻ
͹ W                                                                        
͹ A                          T H I S     S O F T W A R E     I S    N O T  
͹ R               G U A R A N T E E D     T O     W O R K    N O R    I T  
͹ N                             W I L L     W O R K    U N D E R    A L L  
͹ N                                            C I R C U N S T A N C E S.  
͹ ING !!!                                                                  
ͼ
ͼ
****************************************************************************/

/****************************************************************************
*                                                                           *
*                                                                           *
*    Program Name:      FDS_SAV.C                                           *
*    Author:            Federico de la Mora Salazar                         *
*    Date:              June, 1993. (Mxico)                                *
*    Compiler(s):       Turbo C 2.0                                         *
*    Description:       This is a Terminate and Stay Resident (TSR) program.*
*                       At program start the function fdskey_int9h will be  *
*                       attached to interrupt 09h vector. After that the    *
*                       program will be left in memmory resident and the    *
*                       control will return to command.com or the program   *
*                       that run this program.                              *
*                       When a key is pressed the int 09h is called by the  *
*                       BIOS, this int is responsible for filling the       *
*                       keyboard buffer with the keys pressed in the        *
*                       keyboard, capture Ctrl-Alt-Del, Ctrl-Break and      *
*                       Sys-req key combinations and process them.          *
*                       If int 09h is called our program will capture it and*
*                       CHECK FOR OUR HOT KEY if it is found the the screen *
*                       will be cleared until a key is pressed.             *
*                       May be you have read a lot of leave the registers   *
*                       just like you find them when your Interrupt Handler *
*                       was activated. You don't have to worry about it, the*
*                       reserved word interrupt (just for Turbo C) will     *
*                       cause the compiler to save all the registers and    *
*                       restore them before returning from the handler.     *
*                       interrupt will also replace the normal return from  *
*                       function instruction for a return from interrupt    *
*                       instruction (iret).                                 *
*    How to compile:                                                        *
*                                                                           *
*            make -ffds_sav          (Edit this file for your own needs)    *
*                                                                           *
****************************************************************************/

#include <dos.h>
#include <stddef.h>

/****************************************************************************
************ GLOBAL VARIABLES AND CONSTANTS *********************************
****************************************************************************/

#if     !defined(TRUE)
#define TRUE         1
#define FALSE        0
#endif

#if     !defined(ON) || !defined(OFF)
#define ON           1
#define OFF          0
#endif

#define PORT_A  0x60
#define VIDEO_INT       0x10
#define KEYB_INT        0x16

unsigned  _heaplen = 1;         /* Instructs C startup code to use the
				 * minimum heap size. */
unsigned  _stklen  = 0x100;     /* Set a small stack. */

/*
 * The next line uses the preprocesor to redirect some library functions
 * to our own fds_ functions.
 */
#define bioskey         fds_bioskey
#define movedata        fds_movedata
#define wherex          fds_wherex
#define wherey          fds_wherey
#define gotoxy          fds_gotoxy
#define delay           fds_delay

char      vid_buf[4000];	/* Storage area to save the screen, only
				 * screens of 80 x 25. */
int       active_flag;		/* ON if our ISR is active, OFF if not. */

/* Before using any function that writes directly to the screen call the
 * function get_video_address(). This function will store the video address
 * in the next variable.*/
char far *vid_address;

char      fds_msg[] = "FDS_SAV Resident!     Author: Federico de la Mora Salazar.\r\n$";

/****************************************************************************
************ FUNCTION PROTOTYPES ********************************************
****************************************************************************/

void      _restorezero(void);
void      interrupt (*old_int09h) (void);
void 	  interrupt fds_sav_int9h(void);
void      save_scr(void);
void      get_video_address(void);
void      dputch(int x, int y, char attrib, char chr);
int       getvideo_width(void);
unsigned  prog_size(void);
int       getvideo_mode(void);
int       getvideo_memoffset(void);
void      setvideo_refresh_vga(int al);
void      fds_gotoxy(int x, int y);
int       fds_wherex(void);
int       fds_wherey(void);
int       fds_bioskey(int cmd);
void 	  interrupt null_int1Bh(void);
void      fds_movedata(unsigned srcseg, unsigned srcoff,
		       unsigned destseg, unsigned destoff,
		       size_t n);
void 	  fds_delay(unsigned milliseconds);
void      main(void);

/****************************************************************************
************ FUNCTIONS ******************************************************
****************************************************************************/

/****************************************************************************
* Function Name:        _setargv                                            *
* Parameters:           None                                                *
* Returns:              Nothing.                                            *
* Description:          Do-nothing _setargv function.                       *
****************************************************************************/
void _setargv(void)
{
		  return;
}

/****************************************************************************
* Function Name:        exit                                                *
* Parameters:           None                                                *
* Returns:              Nothing.                                            *
* Description:          Do-nothing exit function.                           *
****************************************************************************/
void exit(void)
{
		  return;
}

/****************************************************************************
* Function Name:        _setenvp                                            *
* Parameters:           None                                                *
* Returns:              Nothing.                                            *
* Description:          do-nothing _setenvp.                                *
****************************************************************************/
void _setenvp(void)
{
		  return;
}

/****************************************************************************
* Function Name:        fds_sav_int9h                                       *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          New int 09h handler to capture keystrokes and       *
*                       erase the screen                                    *
****************************************************************************/
void interrupt fds_sav_int9h(void)
{

	int       key, curx, cury;

	enable();		/* Turn the interrupts ON. */

	/*
	 * Let the old int 0x09 do its stuff. After the interrupts have been
	 * enable we must call the original int 09h to proceess the scan code
	 * of the key pressed so this code may use bioskey to avoid guessing
	 * the meaning of the scan codes.
	 */
	(*old_int09h) ();

	/*
	 * If already in this ISR (Interrupt Service Routine) then Quit!!!.
	 * It is very dangerous if this code is interrupted and then executed
	 * again.
	 */
	if (active_flag)
		return;

	/*
	 * We only do video mode 0x03 (Because we reserved only 4000 bytes
	 * for the video buffer). Note: This restriction can be safely remove
	 * for other 80 x 25 modes or even better you can increase the buffer
	 * size or allocate memory on the fly (previosly check for the dos
	 * busy flag, capture int 28h, save the dos error flag. It's complex
	 * but not impossible. Those are undocumented varibles and functions
	 * but in DOS 5.0 they were documented).
	 */
	if (getvideo_mode() != 3)
		return;

	/*
	 * The int 09h has already processed the key, now the bios can report
	 * the pressed key.
	 */
	key = bioskey(1) & 0xFF00;

	/*
	 * Check for our hot key: Ctrl - Left Shift - B :    Funny screen
	 * saver. Ctrl - Left Shift - C :    Clear the screen very quickly.
	 * The scan code of the 'B' key is 0x30. The scan code of the 'C' key
	 * is 0x2E. Keyboard Shift flags: Ctrl:	        0x04 Left Shift:
	 * 0x02
	 */
	if ((key == 0x3000) &&
	    (bioskey(2) & 0x02) && (bioskey(2) & 0x04)) {
		active_flag = ON;

		/* Remove key from buffer. */
		bioskey(0);

		/*
		 * Obtain the video address used to write directly to the
		 * screen.
		 */
		get_video_address();

		/* Save cursor position. */
		curx = wherex();
		cury = wherey();

		/* Turn the cursor off. Send it off the screen. */
		gotoxy(81, 26);

		/* Save screen. */
		movedata((unsigned) ((long) vid_address >> 16), getvideo_memoffset(),
			 FP_SEG(vid_buf), FP_OFF(vid_buf),
			 (size_t) 80 * 25 * 2);
		save_scr();

		/* Restore screen. */
		movedata(FP_SEG(vid_buf), FP_OFF(vid_buf),
		(unsigned) ((long) vid_address >> 16), getvideo_memoffset(),
			 (size_t) 80 * 25 * 2);

		/* Restore the cursor position. */
		gotoxy(curx, cury);
		/* Remove remaining keys from buffer. */
		while (bioskey(1))
			bioskey(0);
	} else if ((key == 0x2E00) &&
		   (bioskey(2) & 0x02) && (bioskey(2) & 0x04)) {
		active_flag = ON;
		/* Remove key from buffer. */
		bioskey(0);
		/*
		 * Turn the video refresh off, this will blank the screen.
		 */
		setvideo_refresh_vga(1);
		while (!bioskey(1));
		/*
		 * Turn the video refresh on, this will restore the screen.
		 */
		setvideo_refresh_vga(0);
		/* Remove remaining keys from buffer. */
		while (bioskey(1))
			bioskey(0);

	}
	active_flag = OFF;
	return;

}

/****************************************************************************
* Function Name:        save_scr                                            *
* Parameters:           None                                                *
* Description:          Clears with funny things the screen.                *
****************************************************************************/
void      save_scr(void)
{
	int       x, y, color;

	while (!bioskey(1)) {
		for (y = 1, color = 0; y <= 13; y++, color++) {
			for (x = 1; x <= 80; x++) {
				dputch(x, y, (color % 14) + 1, '');
				dputch(x, 26 - y, (color % 14) + 1, '');
			}
			delay(270);
			if (bioskey(1))
				return;
		}
		for (x = 1; x <= 40; x++) {
			for (y = 1; y <= 25; y++) {
				dputch(41 - x, y, 0, 0);
			}
			for (y = 1; y <= 25; y++) {
				dputch(40 + x, y, 0, 0);
			}
			delay(150);
			if (bioskey(1))
				return;
		}
	}
	return;
}

/****************************************************************************
* Function Name:        get_video_address                                   *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          Stores the video address of the current text mode   *
*                       in the variable vid_address.                        *
****************************************************************************/
void      get_video_address(void)
{
	int       vid_mode;

	vid_mode = *((char far *) 0x449);
	if (vid_mode == 0x07)
		vid_address = (char far *) 0xB0000000L;
	else
		vid_address = (char far *) 0xB8000000L;
	return;
}

/****************************************************************************
* Function Name:        dputch                                              *
* Parameters:           x:      column.                                     *
*                       y:      row.                                        *
*                       attrib: Character attribute.                        *
*                       chr:    character to be written.                    *
* Returns:              Nothing                                             *
* Description:          Call this function to write a chracter and a its    *
*                       color attribute directly to the screen. To avoid    *
*                       snow define CGA (look) the the definition of        *
*                       CHECK_SNOW at the beginning of this file.           *
****************************************************************************/
void      dputch(int x, int y, char attrib, char chr)
{
	char far *vid;

	x--;
	y--;
	vid = vid_address;
	vid += (x * 2) + (y * getvideo_width() * 2);
	*vid++ = chr;
	*vid = attrib;
	return;
}

/****************************************************************************
* Function Name:        getvideo_width                                      *
* Parameters:           None                                                *
* Returns:              Number of text columns.                             *
****************************************************************************/
int       getvideo_width(void)
{
	/* Number of text columns on the screen                                                                   */
	          return ((int) *((int far *) 0x044A));
}

/****************************************************************************
* Function Name:        prog_size                                           *
* Parameters:           None                                                *
* Returns:              Program's size in paragraphs (Chunks of 16 bytes).  *
* Description:          Looks for this program's MCB and reads the program's*
*                       size in paragraphs.                                 *
****************************************************************************/
unsigned  prog_size(void)
{

	          return peek(_psp - 1, 3);	/* The Program Segment Prefix
						 * (psp)  contains
						 * information created by DOS
						 * when the program was
						 * loaded in to memory to be
						 * excuted. One paragraph (16
						 * bytes) before the psp
						 * there are a Memory Control
						 * Block created by DOS to
						 * asignate memory to this
						 * program, the 3rd byte of
						 * it contains the number of
						 * bytes reserved for this
						 * program in paragraphs.
						 */
	/*
	 * Note: The operation _psp-1 is substracting a complete paragraph,
	 * from _psp because _psp contains a segment or paragraph address.
	 */
}

/****************************************************************************
* Function Name:        getvideo_mode                                       *
* Parameters:           None                                                *
* Returns:              Current video mode.                                 *
****************************************************************************/
int       getvideo_mode(void)
{
	/* Video mode currently being used by the BIOS. */
	          return ((int) *((char far *) 0x0449));
}

/****************************************************************************
* Function Name:        getvideo_memoffset                                  *
* Parameters:           None                                                *
* Returns:              Returns the offset address to the active page number*
****************************************************************************/
int       getvideo_memoffset(void)
{
	/* Offset in the video mem to the active page. */
	          return ((int) *((int far *) 0x044E));
}

/****************************************************************************
* Function Name:        setvideo_refresh_vga                                *
* Parameters:           al: (This parameter accepts one of two possible     *
*                            values)                                        *
*                          enable  = 0                                      *
*                          disable = 1                                      *
* Returns:              Nothing                                             *
* Description:          Enables or disables the screen refresh. The screen  *
*                       is constantly being updated by the BIOS. It reads   *
*                       from the video buffer the data that builds the      *
*                       display. If the refresh is turned off, the screen   *
*                       will be blank until you turn the refresh on, but the*
*                       writes to the video beffer will be faster.          *
****************************************************************************/
void      setvideo_refresh_vga(int al)
{

	_AL = al;	        /* Turn on or off video refresh on vga's. If
				 * off the screen will become blank until you
				 * turn in on. However writiting directly to
				 * the video buffer will be faster.
				 */
	/*
	 * al =         Enable   0 Disable  1
	 */
	_BL = 0x36;
	_AH = 0x12;		/* Rom BIOS function 0x12, subfunction 0x36:
				 * Enable/Disable video refresh. */
	geninterrupt(VIDEO_INT);
	return;
}

/****************************************************************************
* Function Name:        fds_gotoxy                                          *
* Parameters:           Same as gotoxy                                      *
* Returns:              Same as gotoxy                                      *
* Description:          A replacement for the library function gotoxy().    *
****************************************************************************/
void      fds_gotoxy(int x, int y)
{

	_AH = 0x02;	                /* Set cursor position. */
	_BH = peekb(0x0040, 0x0062);	/* Active video page.   */
	/*
	 * Screen coordinates start at (0,0).
	 */
	_DH = y - 1;		/* Row. */
	_DL = x - 1;		/* Column. */
	geninterrupt(VIDEO_INT);

	/*
	 * poke(0x0040, 0x0050 + (2*page), (x << 8) | y);
	 */
	return;
}

/****************************************************************************
* Function Name:        fds_wherex                                          *
* Parameters:           Same as wherex                                      *
* Returns:              Same as wherex                                      *
* Description:          A replacement for the library function wherex().    *
****************************************************************************/
int       fds_wherex(void)
{
	int       page;

	page = peekb(0x0040, 0x0062);
	return (peekb(0x0040, 0x0050 + (2 * page)) + 1);
}

/****************************************************************************
* Function Name:        fds_wherey                                          *
* Parameters:           Same as wherey                                      *
* Returns:              Same as wherey                                      *
* Description:          A replacement for the library function wherey().    *
****************************************************************************/
int       fds_wherey(void)
{
	int       page;

	page = peekb(0x0040, 0x0062);
	return (peekb(0x0040, 0x0051 + (2 * page)) + 1);
}

/****************************************************************************
* Function Name:        fds_bioskey                                         *
* Parameters:           Same as bioskey.                                    *
* Returns:              Same as bioskey.                                    *
* Description:          A replacement for the library function bioskey().   *
* Special Note:         The library function bioskey() returns 0 if the     *
*                       Ctrl - Break combination was pressed because that   *
*                       value was left by int 09h. In contrast fds_bioskey  *
*                       will return 0xFF if Ctrl - Break is pressed.        *
****************************************************************************/
int       fds_bioskey(int cmd)
{
#define peekl(a,b)	(*((long far*)MK_FP((a),(b))))
#define pokel(a,b,c)	(*((long far*)MK_FP((a),(b))) = (long)(c))
	int far  *head;
	int far  *tail;
	long      old_int1Bh;
	unsigned  ax;


	switch (cmd) {
	case 0:		/* Return key scancode from buffer and delete
				 * it from the buffer.  Wait for the next key
				 * if the buffer is empty. */

		/* Save original Ctrl-Break interrupt vector. */
		old_int1Bh = peekl(0, 0x6C);

		/* Set a null Ctrl-Break interrupt vector. */
		disable();
		pokel(0, 0x6C, (long) null_int1Bh);
		enable();

		_AH = 0x00;
		geninterrupt(0x16);
		ax = _AX;

		/* Restore original Ctrl-Break interrupt vector. */
		disable();
		pokel(0, 0x6C, old_int1Bh);
		enable();

		return ax;

	case 1:		/* Return key scancode from buffer, but do
				 * not delete it from the buffer. Return 0 if
				 * the buffer is empty. */
		head = (int far *) MK_FP(0x0040, peek(0x0040, 0x001A));
		tail = (int far *) MK_FP(0x0040, peek(0x0040, 0x001C));
		if (head == tail)
			return 0;
		else if( !(*head) )
		        return 0xFF;
		else
			return *head;

	case 2:		/* Return the BIOS shift state flags. */
		return (peekb(0x0040, 0x0017));

	default:
		return 0;

	}
}

/****************************************************************************
* Function Name:        null_int1Bh                                         *
* Parameters:           None.                                               *
* Returns:              Nothing.                                            *
* Description:          A null rutine to temporarily replace the handler for*
*                       the Ctrl - Break vector.                            *
****************************************************************************/
void interrupt null_int1Bh(void)
{
	          return;
}

/****************************************************************************
* Function Name:        fds_movedata                                        *
* Parameters:           Same as movedata                                    *
* Returns:              Same as movedata                                    *
* Description:          A replacement for the library function movedata().  *
****************************************************************************/
void      fds_movedata(unsigned srcseg, unsigned srcoff,
		               unsigned destseg, unsigned destoff, size_t n)
{
	char far *source;
	char far *target;

	source = MK_FP(srcseg, srcoff);
	target = MK_FP(destseg, destoff);
	while (n--)
		*(target++) = *(source++);
	return;
}

/****************************************************************************
* Function Name:        fds_delay                                           *
* Parameters:           Same as delay                                       *
* Returns:              Same as delay                                       *
* Description:          A replacement for the library function delay().     *
* Special Note:         This function is extremelly precise in comparation  *
*                       with the library function delay().0                 *
*                       This function has a resolution of 996 microseconds. *
****************************************************************************/
void fds_delay(unsigned milliseconds) {
     long microseconds;

	microseconds = (long) milliseconds * 1000L;
	_AH = 0x86;                                 /* Wait for an especified
	                                             * interval.
	                                             */
	_CX = (unsigned) (microseconds >> 16);      /* High order word. */
	_DX = (unsigned) (microseconds & 0xFFFF);   /* Low order word.  */

	geninterrupt(0x15);
        return;
}

/****************************************************************************
* Function Name:        main                                                *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          C's main function.                                  *
****************************************************************************/
void      main(void)
{
	unsigned  saved_DS;

	saved_DS = _DS;
	/*
	 * Save the pointers to our stack to used it later. program_SS = _SS;
	 * program_SP = _SP;
	 */

	/*
	 * The C startup code in c0.asm save some interrupt vectors used by
	 * the signal functions. However a TSR must save and restore this
	 * vectors by itself to continue using those functions. fdsbeep.c
	 * doesn't use any signal function but it must let the interrupt
	 * vectors unchanged except for the int 09h. For this reason the
	 * program would call the _restorezero() function defined in c0.asm
	 * (take a look on that file on the turbo C directory, it's very
	 * interesting) if it becomes resident without using the keep()
	 * function. If you use keep() to make your program resident it will
	 * restore the vectors replaced by the startup code (c0.asm). However
	 * if you call DOS directly you must use _restorezero() to restore
	 * the replaced vectors.
	 */

	_restorezero();

	/*
	 * Save the original vector of the interrupt 09h to be called just
	 * after the beep is produced. Equivalent to:       old_int09h =
	 * getvect(0x09);
	 */
	_AX = 0x3509;
	geninterrupt(0x21);
	old_int09h = MK_FP(_ES, _BX);

	/*
	 * Store our new int 09h vector to be called each time an int 09h is
	 * generated. Equivalent to:       setvect(0x09, fds_sav_int9h);
	 */
	_DS = (unsigned) ((unsigned long) (fds_sav_int9h) >> 16);
	_DX = (unsigned) fds_sav_int9h;
	_AX = 0x2509;
	geninterrupt(0x21);
	_DS = saved_DS;

	/*
	 * The next instructions will release the memory used by this
	 * program's enviroment. It's safe to do so and the freed memory can
	 * be reused by another program's enviroment. _ES = enviroment
	 * segment. _AH = 0x49 (DOS function: Free memory block). The offset
	 * 2Ch of the Program Segment Prefix contains (psp) the Enviroment
	 * segment address.
	 */
	_ES = peek(_psp, 0x2C);
	_AH = 0x49;
	geninterrupt(0x21);

	/* Print Title. */
	_DX = (unsigned) fds_msg;
	_AX = 0x0900;
	geninterrupt(0x21);
	/*
	 * keep() terminates the program leaving it resident in memory. It
	 * will return 3 to the calling program or to the DOS ERRORLEVEL
	 * variable. This lines are equivalent to ... keep(3, prog_size());
	 */
	_DX = prog_size();
	_AX = 0x3103;
	geninterrupt(0x21);
	return;
}


