/* IOSTREAM.CPP */

/****************************************************************************/
/* Global operator overloads for using string class with streams
/*
/* Steven L. Pearson
/* 11/30/93
/****************************************************************************/

#include <process.h>
#include "iostream.hpp"

istream& operator>>( istream& inStream, string& inString ) {
	char *buf = new char[inStream.width()+1];
	if( buf==NULL ) exit(-1);
	inStream.operator>>(buf) ; // prevent type conv. to string
	inString = buf;	// Constructor for C-string invoked automatically
	delete[] buf;
	return inStream;
}

// Corresponding ostream operator doesn't need to be overloaded
// because strings automatically promote to const char* when necessary

// Global overload for bool
ostream& operator<<(ostream& outStream, bool outBool) {
	if (outBool) outStream << "TRUE";
	else outStream << "FALSE";
	return outStream;
}

