/* STRING.HPP */

/****************************************************************************/
/* General purpose string class to replace C char arrays.
/* Includes operators =, +, +=, ==, !=, <, <=, >, >=, [], length,
/* upper/lower case conv., substring. All operations work with C-strings,
/* as well. Case-sensitivity in comparisons may be toggled.
/*
/* Steven L. Pearson
/* 11/30/93
/****************************************************************************/

#ifndef STRING_HPP
#define STRING_HPP
#endif
#ifndef BOOL_H
#include "bool.h"
#endif

class string {
public:
	static bool caseSensitive;			// Case sensitivity for comparisons

	string();									// Default constructor
	string(const string&);              // Copy constructor
	string& operator=(const string&);	// Assignment operator (C-strings, too. C-string constructor invoked by compiler)
	~string();									// Destructor

	string(const char*);						// Constructor for c-string
	int length(void) const;					// string length (not incl. '\0')
	string toUpper(void);					// Convert to upper case
	string toLower(void);					// Convert to lower case
	string subString(int, int);				// Substring
	string operator+(const string&) const; // Catenation
	string operator+(const char*) const;	// Catenation with C-string
	string& operator+=(const string&);		// Catenation to self
	bool operator==(const string&);			// Equality
	bool operator==(const char*);				// Equality with C-string
	bool operator!=(const string&);			// Inequality
	bool operator!=(const char*);				// Inequality with C-string
	bool operator<(const string&);			// <
	bool operator<(const char*);				// < with C-string
	bool operator<=(const string&);			// <=
	bool operator<=(const char*);				// <= with C-string
	bool operator>(const string&);			// >
	bool operator>(const char*);				// > with C-string
	bool operator>=(const string&);			// >=
	bool operator>=(const char*);				// >= with C-string
	char& operator[](int) const;				// index into string (l or r-value)
	operator const char *() const;			// Publish as c-string (used internally, also)

private:
	char *cString;									// Pointer to actual string (dynamic)
};

// Operator special cases: when leftmost operand is c-string
string operator+(const char*, const string&);	// Catenation with C-string
bool operator==(const char*, const string&);	// Equality with C-string
bool operator!=(const char*, const string&);	// Inequality with C-string
